/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.freemarker.model;

import aurora.ide.helpers.LoadSchemaManager;
import aurora.ide.meta.gef.Util;
import aurora.ide.prototype.freemarker.FreeMarkerGenerator;
import aurora.ide.prototype.freemarker.model.WarpperFactory;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.SimpleObjectWrapper;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import uncertain.composite.CompositeMap;
import uncertain.schema.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateModelWrapper
implements TemplateHashModel {
    private static final String INIT_PROCEDURE = "initprocedure";
    private static final String IS_BOX = "isbox";
    private static final String IS_LAYOUT = "islayout";
    private static final String HAS_CHILD = "haschild";
    private static final String U_ID = "u_id";
    private static final String NAME = "name";
    private static final String RAWNAME = "rawname";
    private static final String COMPONENTS = "components";
    private static final String CDATA = "cdata";
    protected SimpleObjectWrapper sow = new SimpleObjectWrapper();
    protected DefaultObjectWrapper dow = new DefaultObjectWrapper();
    private CompositeMap cm;
    private String name;
    private FreeMarkerGenerator fmg;
    private static final String[] INNER_KEYS = new String[]{"u_id", "cdata", "components", "rawname", "name", "islayout", "isbox", "haschild", "initprocedure"};

    public TemplateModelWrapper(String name, CompositeMap cm, FreeMarkerGenerator freeMarkerGenerator) {
        this.cm = cm;
        this.name = name;
        this.fmg = freeMarkerGenerator;
    }

    public Set<?> keys() {
        return this.cm.keySet();
    }

    public Collection<?> values() {
        return this.cm.values();
    }

    public TemplateModel get(String key) throws TemplateModelException {
        if (this.isInnerKey(key)) {
            return this.getInnerValue(key);
        }
        String compositeValue = Util.getCompositeValue(key, this.cm);
        if (compositeValue != null) {
            return this.dow.wrap((Object)compositeValue);
        }
        List childsNotNull = this.cm.getChildsNotNull();
        for (Object object : childsNotNull) {
            if (!(object instanceof CompositeMap) || !key.equalsIgnoreCase(((CompositeMap)object).getName())) continue;
            WarpperFactory wf = new WarpperFactory(this.fmg);
            return wf.createWrapper((CompositeMap)object);
        }
        return null;
    }

    private TemplateModel getInnerValue(String key) throws TemplateModelException {
        if (CDATA.equalsIgnoreCase(key)) {
            String text = this.cm.getText();
            return this.dow.wrap((Object)(text == null ? "" : text));
        }
        if (COMPONENTS.equalsIgnoreCase(key)) {
            List childsNotNull = this.cm.getChildsNotNull();
            ArrayList<TemplateModel> models = new ArrayList<TemplateModel>();
            WarpperFactory wf = new WarpperFactory(this.fmg);
            for (Object object : childsNotNull) {
                models.add(wf.createWrapper((CompositeMap)object));
            }
            return this.dow.wrap(models);
        }
        if (RAWNAME.equalsIgnoreCase(key)) {
            String text = this.cm.getRawName();
            return this.dow.wrap((Object)(text == null ? "" : text));
        }
        if (NAME.equalsIgnoreCase(key)) {
            String text = this.cm.getName();
            return this.dow.wrap((Object)(text == null ? "" : text));
        }
        if (U_ID.equalsIgnoreCase(key)) {
            return this.dow.wrap((Object)this.fmg.getUid().getID(this.cm));
        }
        if (IS_LAYOUT.equalsIgnoreCase(key)) {
            List childs = this.cm.getChildsNotNull();
            return this.dow.wrap((Object)(childs.size() > 0 ? 1 : 0));
        }
        if (HAS_CHILD.equalsIgnoreCase(key)) {
            List childs = this.cm.getChildsNotNull();
            return this.dow.wrap((Object)(childs.size() > 0 ? 1 : 0));
        }
        if (IS_BOX.equalsIgnoreCase(key)) {
            return this.dow.wrap((Object)false);
        }
        if (INIT_PROCEDURE.equalsIgnoreCase(key)) {
            CompositeMap child = this.cm.getChild("init-procedure");
            if (child != null) {
                WarpperFactory wf = new WarpperFactory(this.fmg);
                return wf.createWrapper(child);
            }
            return null;
        }
        return this.dow.wrap((Object)"null");
    }

    private boolean isInnerKey(String key) {
        return Arrays.asList(INNER_KEYS).contains(key.toLowerCase());
    }

    public int getMax(CompositeMap map) {
        Element element = null;
        try {
            element = LoadSchemaManager.getSchemaManager().getElement(map);
            return Integer.valueOf(element.getMaxOccurs());
        }
        catch (Exception exception) {
            return 1;
        }
    }

    public boolean isEmpty() throws TemplateModelException {
        return false;
    }

    public CompositeMap getCompositeMap() {
        return this.cm;
    }

    public void setCompositeMap(CompositeMap cm) {
        this.cm = cm;
    }

    public String getName() {
        return this.name;
    }
}

