/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.project;

import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.ProjectUtil;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.project.AuroraMetaProject;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class MetaProjectPropertyPage
extends PropertyPage {
    AuroraMetaProject amp;
    public static final String PROPERTY_ID = "aurora.ide.meta.project.property";
    public static final QualifiedName AURORA_PROJECT_QN = new QualifiedName("aurora.ide.meta.project.property", "project");
    private Text model;
    private Text screen;
    private Combo auroraProjectNameField;

    protected Control createContents(Composite parent) {
        String mf;
        this.noDefaultAndApplyButton();
        this.amp = new AuroraMetaProject(this.getProject());
        Composite content = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        content.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        Label label = new Label(content, 0);
        label.setText("Model Prototype Folder: ");
        this.model = new Text(content, 2048);
        gridData = new GridData(768);
        this.model.setLayoutData((Object)gridData);
        this.model.setEditable(false);
        try {
            mf = this.amp.getModelFolder().getName();
            if (MetaProjectPropertyPage.filtEmpty(mf) != null) {
                this.model.setText(mf);
            }
        }
        catch (Throwable e) {
            DialogUtil.showExceptionMessageBox((Throwable)e);
        }
        label = new Label(content, 0);
        label.setText("UI Prototype Folder: ");
        this.screen = new Text(content, 2048);
        gridData = new GridData(768);
        this.screen.setLayoutData((Object)gridData);
        this.screen.setEditable(false);
        try {
            mf = this.amp.getScreenFolder().getName();
            if (MetaProjectPropertyPage.filtEmpty(mf) != null) {
                this.screen.setText(mf);
            }
        }
        catch (Throwable e) {
            DialogUtil.showExceptionMessageBox((Throwable)e);
        }
        Label projectLabel = new Label(content, 0);
        projectLabel.setText("Aurora Project Name: ");
        projectLabel.setFont(parent.getFont());
        this.auroraProjectNameField = new Combo(content, 8);
        GridData data = new GridData(768);
        this.auroraProjectNameField.setLayoutData((Object)data);
        this.auroraProjectNameField.setFont(parent.getFont());
        this.auroraProjectNameField.select(0);
        this.auroraProjectNameField.add("");
        List projects = ProjectUtil.getALLAuroraProjects();
        for (IProject p : projects) {
            this.auroraProjectNameField.add(p.getName());
        }
        IProject auroraProject = null;
        try {
            auroraProject = this.amp.getAuroraProject();
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
        try {
            String mf2 = "";
            mf2 = auroraProject == null ? this.getProject().getPersistentProperty(AURORA_PROJECT_QN) : auroraProject.getName();
            if (MetaProjectPropertyPage.filtEmpty(mf2) != null) {
                int indexOf = this.auroraProjectNameField.indexOf(mf2);
                if (indexOf > -1) {
                    this.auroraProjectNameField.select(indexOf);
                } else {
                    this.auroraProjectNameField.select(0);
                }
            }
        }
        catch (Throwable e) {
            DialogUtil.showExceptionMessageBox((Throwable)e);
        }
        new Label(content, 0);
        return content;
    }

    public boolean performOk() {
        try {
            this.getProject().setPersistentProperty(AURORA_PROJECT_QN, this.auroraProjectNameField.getText());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.amp.setAuroraProject(this.auroraProjectNameField.getText());
        return true;
    }

    private IProject getProject() {
        return (IProject)this.getElement();
    }

    public static String filtEmpty(String str) {
        if ("".equals(str)) {
            return null;
        }
        return str;
    }
}

