/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.popup.actions;

import aurora.ide.helpers.DialogUtil;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.gef.designer.model.ModelMerger;
import aurora.ide.meta.project.AuroraMetaProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class OpenGeneratorFileAction
implements IObjectActionDelegate {
    private IFile file = null;
    private IWorkbenchPage page;
    private boolean isBm;
    private boolean isScreen;

    public IFile getFile() {
        return this.file;
    }

    public IWorkbenchPage getPage() {
        return this.page;
    }

    public void setPage(IWorkbenchPage page) {
        this.page = page;
    }

    public boolean isBm() {
        return this.isBm;
    }

    public boolean isScreen() {
        return this.isScreen;
    }

    public void run(IAction action) {
        if (this.file == null) {
            DialogUtil.showErrorMessageBox((String)"invalid selection.");
            return;
        }
        if (this.isBm) {
            this.openBMFile();
        }
        if (this.isScreen) {
            this.openScreenFile();
        }
    }

    private void openScreenFile() {
        AuroraMetaProject amp = new AuroraMetaProject(this.file.getProject());
        try {
            IFile newScreenFile = amp.getNewScreenFile(this.file);
            IDE.openEditor((IWorkbenchPage)this.getPage(), (IFile)newScreenFile, (String)"aurora.ide.ServiceEditor", (boolean)true);
        }
        catch (ResourceNotFoundException e) {
            DialogUtil.showWarningMessageBox((String)"relative file does not exists.");
        }
        catch (PartInitException e) {
            DialogUtil.showErrorMessageBox((String)("Error Occurred while open eidtor.\n" + e.getMessage()));
        }
    }

    public void openBMFile() {
        ModelMerger merger = new ModelMerger(this.file);
        IFile bmFile = merger.getBMFile();
        if (bmFile == null || !bmFile.exists()) {
            DialogUtil.showWarningMessageBox((String)"relative file does not exists.");
            return;
        }
        try {
            IDE.openEditor((IWorkbenchPage)this.page, (IFile)bmFile, (String)"aurora.ide.BusinessModelEditor", (boolean)true);
        }
        catch (PartInitException e) {
            DialogUtil.showErrorMessageBox((String)("Error Occurred while open eidtor.\n" + e.getMessage()));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection ss;
        Object o;
        this.file = null;
        this.isBm = false;
        this.isScreen = false;
        if (selection instanceof IStructuredSelection && (o = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this.file = (IFile)o;
            if ("bmq".equalsIgnoreCase(this.file.getFileExtension())) {
                this.isBm = true;
            }
            if ("uip".equalsIgnoreCase(this.file.getFileExtension())) {
                this.isScreen = true;
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.page = targetPart.getSite().getPage();
    }
}

