/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.popup.actions;

import aurora.ide.bm.AuroraDataBase;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.StatusUtil;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.gef.designer.editor.LookupCodeUtil;
import aurora.ide.meta.gef.designer.wizard.CreateSyscodeWizard;
import aurora.ide.meta.popup.actions.Messages;
import aurora.ide.meta.project.AuroraMetaProject;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import uncertain.composite.CompositeMap;

public class CreateSysCodeAction
implements IObjectActionDelegate,
IRunnableWithProgress {
    private IFile sysCodeFile;
    private Shell shell;
    private List<CompositeMap> list;
    private Connection conn;
    private Statement stmt;

    boolean initdb() {
        try {
            IProject proj = this.sysCodeFile.getProject();
            AuroraMetaProject amp = new AuroraMetaProject(proj);
            IProject project = amp.getAuroraProject();
            this.conn = new AuroraDataBase(project).getDBConnection();
            this.conn.setAutoCommit(false);
            this.stmt = this.conn.createStatement();
        }
        catch (ApplicationException e) {
            StatusUtil.showExceptionDialog((Shell)this.shell, (String)"Error", (String)Messages.AutoCreateTableAction_1, (boolean)true, (Throwable)e);
            return false;
        }
        catch (SQLException e) {
            StatusUtil.showExceptionDialog((Shell)this.shell, (String)"Error", (String)Messages.AutoCreateTableAction_3, (boolean)true, (Throwable)e);
            return false;
        }
        catch (ResourceNotFoundException e) {
            StatusUtil.showExceptionDialog((Shell)this.shell, (String)"Error", (String)Messages.AutoCreateTableAction_5, (boolean)true, (Throwable)e);
            return false;
        }
        return true;
    }

    void closedb() {
        if (this.stmt != null) {
            try {
                this.stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void run(IAction action) {
        if (!this.initdb()) {
            return;
        }
        CreateSyscodeWizard wizard = new CreateSyscodeWizard();
        wizard.setSysCodeFile(this.sysCodeFile);
        wizard.setConnection(this.conn);
        WizardDialog wd = new WizardDialog(this.shell, (IWizard)wizard);
        if (wd.open() == 0) {
            this.list = wizard.getResult();
            try {
                new ProgressMonitorDialog(null).run(false, true, (IRunnableWithProgress)this);
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
        this.closedb();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this.sysCodeFile = (IFile)obj;
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(Messages.CreateSysCodeAction_6, this.list.size());
        for (CompositeMap m : this.list) {
            String code = LookupCodeUtil.getCode(m);
            monitor.setTaskName(NLS.bind((String)Messages.CreateSysCodeAction_7, (Object)code));
            String sql = this.getSql(m);
            try {
                if (sql == null || sql.length() == 0) continue;
                this.stmt.execute(sql);
                this.conn.commit();
            }
            catch (SQLException e) {
                try {
                    this.conn.rollback();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
            monitor.worked(1);
        }
    }

    private String getSql(CompositeMap m) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        String code = LookupCodeUtil.getCode(m);
        root.put("code", code);
        root.put("codename", m.getString((Object)"code_name"));
        root.put("codeprompt", m.getString((Object)"code_prompt"));
        root.put("codenameprompt", m.getString((Object)"code_name_prompt"));
        ArrayList values = new ArrayList();
        root.put("values", values);
        List list = m.getChildsNotNull();
        for (CompositeMap v : list) {
            HashMap<String, String> value = new HashMap<String, String>();
            value.put("value", LookupCodeUtil.getValue(v));
            value.put("zhs", LookupCodeUtil.getValueNameZHS(v));
            value.put("us", LookupCodeUtil.getValueNameUS(v));
            values.add(value);
        }
        String sql = "";
        OutputStreamWriter writer = null;
        try {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                writer = new OutputStreamWriter(bos);
                Template tpl = LookupCodeUtil.getSourceTemplate();
                if (tpl != null) {
                    tpl.process(root, (Writer)writer);
                }
                sql = bos.toString().replace("\r\n", "\n").replace('\r', '\n');
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (TemplateException e) {
                e.printStackTrace();
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sql;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }
}

