/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.util;

import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Container;
import aurora.plugin.source.gen.screen.model.Grid;
import aurora.plugin.source.gen.screen.model.GridColumn;
import aurora.plugin.source.gen.screen.model.ScreenBody;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentUtil {
    public static Grid findParentGrid(AuroraComponent ac) {
        if (ac != null && "gridcolumn".equals(ac.getComponentType())) {
            Container parent = ac.getParent();
            if (parent instanceof Grid) {
                return (Grid)parent;
            }
            return ComponentUtil.findParentGrid((AuroraComponent)parent);
        }
        return null;
    }

    public static List<GridColumn> getGridColumns(GridColumn grid) {
        ArrayList<GridColumn> r = new ArrayList<GridColumn>();
        List children = grid.getChildren();
        for (AuroraComponent a : children) {
            if (!"gridcolumn".equals(a.getComponentType())) continue;
            GridColumn gc = (GridColumn)a;
            r.add(gc);
            if (gc.getChildren().size() <= 0) continue;
            r.addAll(ComponentUtil.getGridColumns(gc));
        }
        return r;
    }

    public static Container getNotHVBoxParent(AuroraComponent ac) {
        if (ac == null || ac.getParent() == null) {
            return null;
        }
        Container parent = ac.getParent();
        String componentType = parent.getComponentType();
        if ("hBox".equals(componentType) || "vBox".equals(componentType)) {
            return ComponentUtil.getNotHVBoxParent((AuroraComponent)parent);
        }
        return parent;
    }

    public static List<AuroraComponent> getAllInputChildren(Container container) {
        ArrayList<AuroraComponent> r = new ArrayList<AuroraComponent>();
        List children = container.getChildren();
        for (AuroraComponent a : children) {
            if (a instanceof Container) {
                r.addAll(ComponentUtil.getAllInputChildren((Container)a));
                continue;
            }
            r.add(a);
        }
        return r;
    }

    public static ScreenBody findScreenBody(AuroraComponent ac) {
        if (ac != null) {
            Container parent = ac.getParent();
            if (parent instanceof ScreenBody) {
                return (ScreenBody)parent;
            }
            ComponentUtil.findScreenBody((AuroraComponent)parent);
        }
        return null;
    }
}

