/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.wizard.dialog;

import aurora.ide.meta.ImageFromPlugin;
import aurora.ide.meta.gef.editors.template.Template;
import aurora.ide.meta.gef.editors.wizard.dialog.TLabel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.TypedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TComposite
extends SashForm {
    private Map<String, List<TLabel>> labels = new HashMap<String, List<TLabel>>();
    private String category;
    private int index = 0;
    private Template template = null;
    private int labelHeight = 120;
    private int labelWidth = 120;
    private Composite composite;
    private Composite leftComposite;
    private ScrolledComposite scrolledComposite;
    private org.eclipse.swt.widgets.List list;

    public TComposite(Composite parent, int style, Map<String, List<Template>> templates) {
        super(parent, style);
        this.createContent(templates);
    }

    public void clear() {
        this.labels.clear();
        this.category = null;
        this.index = 0;
        this.template = null;
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (!(c instanceof Sash)) {
                c.dispose();
            }
            ++n2;
        }
    }

    public void createContent(Map<String, List<Template>> templates) {
        this.setLayout((Layout)new GridLayout(2, false));
        this.leftComposite = new Composite((Composite)this, 0);
        this.leftComposite.setLayout((Layout)new GridLayout());
        this.leftComposite.setLayoutData((Object)new GridData(1808));
        this.leftComposite.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.list = new org.eclipse.swt.widgets.List(this.leftComposite, 0);
        this.list.setLayoutData((Object)new GridData(1808));
        this.list.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.scrolledComposite = new ScrolledComposite((Composite)this, 512);
        this.scrolledComposite.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.scrolledComposite.setLayoutData((Object)new GridData(1808));
        this.scrolledComposite.getVerticalBar().setIncrement(10);
        this.scrolledComposite.setMinWidth(this.labelWidth * 3 + 20);
        this.composite = new Composite((Composite)this.scrolledComposite, 0);
        this.composite.setLayout((Layout)new GridLayout(3, true));
        this.composite.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.composite.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 0x1000001: {
                        if (TComposite.this.index - 3 < 0) break;
                        TComposite tComposite = TComposite.this;
                        tComposite.index = tComposite.index - 3;
                        TComposite.this.selectLabel((TLabel)((Object)((List)TComposite.this.labels.get(TComposite.this.category)).get(TComposite.this.index)));
                        break;
                    }
                    case 0x1000002: {
                        if (TComposite.this.index + 3 >= ((List)TComposite.this.labels.get(TComposite.this.category)).size()) break;
                        TComposite tComposite = TComposite.this;
                        tComposite.index = tComposite.index + 3;
                        TComposite.this.selectLabel((TLabel)((Object)((List)TComposite.this.labels.get(TComposite.this.category)).get(TComposite.this.index)));
                        break;
                    }
                    case 0x1000003: {
                        if (TComposite.this.index - 1 < 0) break;
                        TComposite tComposite = TComposite.this;
                        tComposite.index = tComposite.index - 1;
                        TComposite.this.selectLabel((TLabel)((Object)((List)TComposite.this.labels.get(TComposite.this.category)).get(TComposite.this.index)));
                        break;
                    }
                    case 0x1000004: {
                        if (TComposite.this.index + 1 >= ((List)TComposite.this.labels.get(TComposite.this.category)).size()) break;
                        TComposite tComposite = TComposite.this;
                        tComposite.index = tComposite.index + 1;
                        TComposite.this.selectLabel((TLabel)((Object)((List)TComposite.this.labels.get(TComposite.this.category)).get(TComposite.this.index)));
                        break;
                    }
                    default: {
                        super.keyPressed(e);
                    }
                }
            }
        });
        this.composite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TComposite.this.composite.forceFocus();
            }
        });
        this.composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point size = TComposite.this.composite.computeSize(((TComposite)TComposite.this).composite.getSize().x, -1);
                TComposite.this.composite.setSize(size);
                TComposite.this.scrolledComposite.getVerticalBar().setMaximum(size.y);
                TComposite.this.scrolledComposite.setMinHeight(size.y);
                int scrollHeight = TComposite.this.scrolledComposite.getVerticalBar().getSelection() + ((TComposite)TComposite.this).scrolledComposite.getClientArea().height;
                if (scrollHeight >= size.y) {
                    TComposite.this.scrolledComposite.setOrigin(0, size.y);
                }
            }
        });
        this.scrolledComposite.setContent((Control)this.composite);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.setWeights(new int[]{20, 80});
        this.setSashWidth(1);
        for (String key : templates.keySet()) {
            this.list.add(key);
            this.labels.put(key, new ArrayList());
            Collections.sort(templates.get(key), new Comparator<Template>(){

                @Override
                public int compare(Template o1, Template o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            for (Template value : templates.get(key)) {
                TLabel label = this.createLabel(value);
                if (label == null) continue;
                this.labels.get(key).add(label);
            }
        }
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int n = TComposite.this.list.getSelectionIndex();
                if (n < 0 || n >= TComposite.this.list.getItemCount()) {
                    return;
                }
                TComposite.this.category = TComposite.this.list.getItem(n);
                TComposite.this.index = 0;
                TComposite.this.selectLabels();
            }
        });
        if (this.list.getItems().length > 0) {
            this.list.select(0);
            this.category = this.list.getItem(0);
            this.selectLabels();
        }
        this.layout();
    }

    private void selectLabels() {
        if (this.category == null) {
            return;
        }
        for (String key : this.labels.keySet()) {
            if (key.equals(this.category)) {
                for (TLabel label : this.labels.get(key)) {
                    label.setVisible(true);
                    ((GridData)label.getLayoutData()).exclude = false;
                }
                continue;
            }
            for (TLabel label : this.labels.get(key)) {
                label.setVisible(false);
                ((GridData)label.getLayoutData()).exclude = true;
            }
        }
        int x = (int)Math.ceil((double)this.labels.get(this.category).size() / 3.0);
        this.scrolledComposite.setMinHeight(x * this.labelHeight + x * 5 + 5);
        this.composite.layout(true);
        this.selectLabel(this.labels.get(this.category).get(this.index));
        this.notifyListeners(13, new Event());
    }

    private TLabel createLabel(Template t) {
        TLabel label = new TLabel(this.composite, 0x1000000);
        GridData gd = new GridData();
        gd.heightHint = this.labelHeight;
        gd.widthHint = this.labelWidth;
        label.setLayoutData(gd);
        label.setBackground(this.getShell().getDisplay().getSystemColor(1));
        label.setCursor(this.getShell().getDisplay().getSystemCursor(21));
        label.setData(t);
        label.setText(t.getName());
        label.setImage(ImageFromPlugin.getImage(t.getIcon()));
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TLabel lbl = (TLabel)((Object)e.getSource());
                TComposite.this.selectLabel(lbl);
                TComposite.this.composite.forceFocus();
            }
        });
        return label;
    }

    private void selectLabel(TLabel lbl) {
        this.setLabelChecked(lbl, true);
        this.template = (Template)lbl.getData();
        this.notifyListeners(13, new Event());
        int i = 0;
        while (i < this.labels.get(this.category).size()) {
            if (!((Object)((Object)this.labels.get(this.category).get(i))).equals((Object)lbl)) {
                this.setLabelChecked(this.labels.get(this.category).get(i), false);
            } else {
                this.index = i;
            }
            ++i;
        }
        Point p = new Point(lbl.getLocation().x, lbl.getLocation().y + this.composite.getLocation().y);
        if (p.y < 0) {
            this.scrolledComposite.setOrigin(0, lbl.getLocation().y - 5);
        } else {
            p.y = p.y + lbl.getSize().y - this.scrolledComposite.getClientArea().height;
            if (p.y > 0) {
                this.scrolledComposite.setOrigin(0, this.scrolledComposite.getOrigin().y + p.y + 5);
            }
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public Template getSelection() {
        return this.template;
    }

    private void setLabelChecked(TLabel label, boolean chencked) {
        if (chencked) {
            label.setBackground(this.getShell().getDisplay().getSystemColor(26));
        } else {
            label.setBackground(this.getShell().getDisplay().getSystemColor(1));
        }
    }

    public Composite getLeftComposite() {
        return this.leftComposite;
    }
}

