/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.template.handle;

import aurora.ide.meta.gef.editors.template.BMBindComponent;
import aurora.ide.meta.gef.editors.template.BMReference;
import aurora.ide.meta.gef.editors.template.ButtonComponent;
import aurora.ide.meta.gef.editors.template.Component;
import aurora.ide.meta.gef.editors.template.LinkComponent;
import aurora.ide.meta.gef.editors.template.TabComponent;
import aurora.ide.meta.gef.editors.template.Template;
import aurora.ide.meta.gef.editors.template.handle.AuroraModelFactory;
import aurora.ide.meta.gef.i18n.Messages;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TemplateParse
extends DefaultHandler {
    private Template template;
    private String qName;
    private Attributes attributes;
    private Stack<Component> stack = new Stack();

    public void startDocument() throws SAXException {
        this.template = new Template();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.qName = qName;
        this.attributes = attributes;
        int loc = qName.indexOf(":");
        if (loc >= 0) {
            qName = qName.substring(loc + 1);
        }
        if (!this.stack.isEmpty() && this.stack.peek() != null && "models".equals(this.stack.peek().getName())) {
            BMReference bm = new BMReference();
            bm.setId(this.getValue("id"));
            bm.setName(this.getValue("name"));
            if (qName.equals("model")) {
                this.template.addModel(bm);
            } else {
                this.template.addLinkModel(bm);
            }
            this.stack.push(null);
        } else if (qName.equals("button")) {
            ButtonComponent btn = new ButtonComponent();
            btn.setComponentType(qName);
            btn.setId(this.getValue("id"));
            btn.setTarget(this.getValue("target"));
            btn.setText(this.getValue("text"));
            btn.setType(this.getValue("type"));
            if (!this.stack.empty() && this.stack.peek() != null) {
                this.stack.peek().addChild(btn);
            }
            this.stack.push(btn);
        } else if ("link".equals(qName)) {
            LinkComponent link = new LinkComponent();
            link.setId(this.getValue("id"));
            this.template.addLink(link);
            this.stack.push(link);
        } else if (AuroraModelFactory.isComponent(qName)) {
            Component cpt = null;
            if (qName.equals("tab")) {
                cpt = new TabComponent();
                ((TabComponent)cpt).setModelQuery(this.getValue("model"));
                ((TabComponent)cpt).setRef(this.getValue("ref"));
                ((BMBindComponent)cpt).setBmReferenceID(this.getValue("model"));
                ((BMBindComponent)cpt).setQueryComponent(this.getValue("query"));
            } else if (this.isBMBindComponent()) {
                cpt = new BMBindComponent();
                ((BMBindComponent)cpt).setBmReferenceID(this.getValue("model"));
                ((BMBindComponent)cpt).setQueryComponent(this.getValue("query"));
            } else {
                cpt = new Component();
            }
            cpt.setComponentType(qName);
            cpt.setId(this.getValue("id"));
            cpt.setName(this.getValue("name"));
            if (!this.stack.empty() && this.stack.peek() != null) {
                this.stack.peek().addChild(cpt);
            }
            this.stack.push(cpt);
        } else if (qName.equals("template")) {
            this.template.setName(this.getValue("name"));
            this.template.setIcon(this.getValue("icon"));
            String category = this.getValue("category");
            this.template.setCategory("".equals(category) ? Messages.TemplateParse_Custom : category);
            this.template.setType(this.getValue("type"));
            this.stack.push(this.template);
        } else {
            Component c = new Component();
            c.setName(qName);
            this.stack.push(c);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String desc;
        if (this.qName.equals("description") && !"".equals(desc = new String(ch, start, length).trim())) {
            this.template.setDescription(desc);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.qName = "";
        this.stack.pop();
    }

    public void endDocument() throws SAXException {
    }

    public Template getTemplate() {
        return this.template;
    }

    private String getValue(String name) {
        String value = this.attributes.getValue(this.attributes.getIndex(name));
        return value == null ? "" : value;
    }

    private boolean isBMBindComponent() {
        int i = 0;
        while (i < this.attributes.getLength()) {
            if ("model".equalsIgnoreCase(this.attributes.getQName(i))) {
                return true;
            }
            if ("query".equalsIgnoreCase(this.attributes.getQName(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

