/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.template.handle;

import aurora.ide.meta.gef.editors.template.BMBindComponent;
import aurora.ide.meta.gef.editors.template.BMReference;
import aurora.ide.meta.gef.editors.template.ButtonComponent;
import aurora.ide.meta.gef.editors.template.Component;
import aurora.ide.meta.gef.editors.template.LinkComponent;
import aurora.ide.meta.gef.editors.template.TabComponent;
import aurora.ide.meta.gef.editors.template.Template;
import aurora.ide.meta.gef.editors.template.handle.AuroraModelFactory;
import aurora.ide.meta.gef.editors.template.handle.TemplateConfig;
import aurora.ide.meta.gef.editors.template.handle.TemplateParse;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Button;
import aurora.plugin.source.gen.screen.model.ButtonClicker;
import aurora.plugin.source.gen.screen.model.Container;
import aurora.plugin.source.gen.screen.model.Dataset;
import aurora.plugin.source.gen.screen.model.ScreenBody;
import aurora.plugin.source.gen.screen.model.TabItem;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateHelper {
    private static Map<String, Template> templates = new HashMap<String, Template>();
    private TemplateConfig config;
    private Map<String, String> queryRelated;
    private int tabItemIndex = 0;
    public static final String MODEL = "bm";
    public static final String TAB_ITEM = "tab";
    public static final String LINK = "link";
    public static final String INIT_MODEL = "initBm";

    public void clearTemplate() {
        templates.clear();
    }

    private void loadTemplate(IPath path) {
        if (path == null) {
            return;
        }
        templates.clear();
        List<File> files = this.getFiles(path.toString(), ".xml");
        SAXParser parser = null;
        try {
            parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            return;
        }
        catch (SAXException e) {
            return;
        }
        TemplateParse tp = new TemplateParse();
        for (File f : files) {
            try {
                parser.parse(f, (DefaultHandler)tp);
            }
            catch (SAXException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            Template tm = tp.getTemplate();
            tm.setIcon("template/thumbnails/" + tm.getIcon());
            String p = f.getPath();
            if (p.indexOf("template") > 0) {
                p = p.substring(p.indexOf("template"));
            }
            tm.setPath(p);
            templates.put(tm.getPath(), tm);
        }
    }

    private List<File> getFiles(String path, String extension) {
        ArrayList<File> files = new ArrayList<File>();
        File file = new File(path.toString());
        if (!file.exists() || !file.isDirectory()) {
            return files;
        }
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile() && f.getName().toLowerCase().endsWith(extension)) {
                files.add(f);
            }
            ++n2;
        }
        return files;
    }

    public boolean isMetaProject(IResource container) {
        try {
            return container.getProject().hasNature("aurora.ide.meta.nature");
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Map<String, List<Template>> getTemplates(IPath path) {
        if (templates.size() <= 0) {
            this.loadTemplate(path);
        }
        HashMap<String, List<Template>> tempMap = new HashMap<String, List<Template>>();
        for (Template tm : templates.values()) {
            if (tempMap.get(tm.getCategory()) == null) {
                tempMap.put(tm.getCategory(), new ArrayList());
            }
            ((List)tempMap.get(tm.getCategory())).add(tm);
        }
        return tempMap;
    }

    public Template getTemplate(String key) {
        if (templates.size() <= 0) {
            URL ts = FileLocator.find((Bundle)Platform.getBundle((String)"aurora.ide.meta"), (IPath)new Path("template"), null);
            try {
                ts = FileLocator.toFileURL((URL)ts);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            Path path = new Path(ts.getPath());
            this.loadTemplate((IPath)path);
        }
        return templates.get(key);
    }

    public ScreenBody createView(Template template) {
        this.initVariable(template);
        ScreenBody viewDiagram = new ScreenBody();
        for (Component c : template.getChildren()) {
            AuroraComponent ac = this.createAuroraComponent(c);
            if (!(ac instanceof AuroraComponent)) continue;
            viewDiagram.addChild(ac);
        }
        this.fillQueryRelated();
        viewDiagram.setTemplateType(template.getType());
        viewDiagram.setBindTemplate(template.getPath());
        if (this.config.get(TAB_ITEM) != null && this.config.get(TAB_ITEM).size() > 0) {
            ((TabItem)this.config.get(TAB_ITEM).get(0)).setCurrent(true);
        }
        return viewDiagram;
    }

    private void initVariable(Template template) {
        template.clear();
        this.config = new TemplateConfig();
        this.config.put(MODEL, template.getBms());
        this.config.put(INIT_MODEL, template.getLinkBms());
        this.config.put(LINK, template.getLink());
        this.queryRelated = new HashMap<String, String>();
        this.tabItemIndex = 0;
    }

    private AuroraComponent createAuroraComponent(Component c) {
        Object ac = AuroraModelFactory.createComponent(c.getComponentType());
        if (ac == null) {
            return null;
        }
        if (c.getName() != null) {
            ac.setName(c.getName());
        }
        if (c.getId() != null && !"".equals(c.getId())) {
            this.config.getAuroraComponents().put(c.getId(), (AuroraComponent)ac);
        }
        if (c instanceof BMBindComponent && ac instanceof Container) {
            this.fillContainer((BMBindComponent)c, (Container)ac);
        }
        if (ac instanceof TabItem) {
            ((TabItem)ac).setPrompt("tabItem" + this.tabItemIndex++);
            this.fillTabRef((TabItem)ac, (TabComponent)c);
        }
        if (c instanceof ButtonComponent && ac instanceof Button) {
            this.fillButton((ButtonComponent)c, (Button)ac);
        }
        if (c.getChildren() == null) {
            return ac;
        }
        for (Component c_child : c.getChildren()) {
            AuroraComponent ac_child = this.createAuroraComponent(c_child);
            if (!(ac instanceof Container)) continue;
            ((Container)ac).addChild(ac_child);
        }
        return ac;
    }

    private void fillQueryRelated() {
        for (String s : this.queryRelated.keySet()) {
            AuroraComponent obj = this.config.getAuroraComponents().get(s);
            if (obj instanceof Button) {
                Button btn = (Button)obj;
                AuroraComponent ac = this.config.getAuroraComponents().get(this.queryRelated.get(s));
                btn.getButtonClicker().setTargetComponent(ac);
                continue;
            }
            if (!(obj instanceof Container)) continue;
            Container c = (Container)obj;
            Dataset ds = c.getDataset();
            AuroraComponent ac = this.config.getAuroraComponents().get(this.queryRelated.get(s));
            if (!(ac instanceof Container)) continue;
            ds.setOwner((AuroraComponent)c);
            ds.setQueryContainer((Container)ac);
        }
    }

    private void fillButton(ButtonComponent btnc, Button btn) {
        if ("toolBar".equals(btnc.getParent().getComponentType()) && this.contains(Button.std_types, btnc.getType())) {
            btn.setButtonType(btnc.getType());
        } else if (this.contains(ButtonClicker.action_ids, btnc.getType())) {
            ButtonClicker bc = btn.getButtonClicker();
            if (bc == null) {
                bc = new ButtonClicker();
                bc.setButton(btn);
            }
            bc.setActionID(btnc.getType());
            btn.setButtonClicker(bc);
            btn.setText(btnc.getText());
            this.queryRelated.put(btnc.getId(), btnc.getTarget());
        }
    }

    private void fillTabRef(TabItem ac, TabComponent c) {
        if (!this.isRefTab(c)) {
            return;
        }
        if (this.config.get(TAB_ITEM) == null) {
            this.config.put(TAB_ITEM, new ArrayList());
        }
        this.config.get(TAB_ITEM).add(ac);
        String ibmId = c.getModelQuery();
        BMReference bm = null;
        for (Object b : this.config.get(INIT_MODEL)) {
            if (!ibmId.equals(((BMReference)b).getId())) continue;
            bm = (BMReference)b;
            break;
        }
        if (bm == null) {
            return;
        }
        if (this.config.getInitModelRelated().get(bm) == null) {
            this.config.getInitModelRelated().put(bm, new ArrayList());
        }
        this.config.getInitModelRelated().get(bm).add(ac);
    }

    private boolean isRefTab(TabComponent c) {
        if (c.getRef() == null && "".equals(c.getRef().trim())) {
            return false;
        }
        for (Object obj : this.config.get(LINK)) {
            if (!c.getRef().equals(((LinkComponent)obj).getId())) continue;
            return true;
        }
        return false;
    }

    private boolean contains(String[] ss, String s) {
        if (ss == null || s == null) {
            return false;
        }
        String[] stringArray = ss;
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String st = stringArray[n2];
            if (st.equals(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void fillContainer(BMBindComponent c, Container ac) {
        String bmId = c.getBmReferenceID();
        if (bmId == null || "".equals(bmId)) {
            return;
        }
        BMReference bm = null;
        for (Object b : this.config.get(MODEL)) {
            if (!bmId.equals(((BMReference)b).getId())) continue;
            bm = (BMReference)b;
            break;
        }
        if (bm == null) {
            return;
        }
        Dataset ds = new Dataset();
        ds.setComponentType("resultdataset");
        ds.setOwner((AuroraComponent)ac);
        ac.setDataset(ds);
        ac.setSectionType("SECTION_TYPE_RESULT");
        if (this.config.getModelRelated().get(bm) == null) {
            this.config.getModelRelated().put(bm, new ArrayList());
        }
        this.config.getModelRelated().get(bm).add(ac);
        String qcId = c.getQueryComponent();
        if (qcId != null && !"".equals(qcId)) {
            this.queryRelated.put(c.getId(), qcId);
            this.config.getQueryModelRelated().put(bm, qcId);
        }
    }

    public TemplateConfig getConfig() {
        return this.config;
    }

    public void setConfig(TemplateConfig config) {
        this.config = config;
    }
}

