/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.source.gen.core;

import aurora.ide.meta.MetaPlugin;
import aurora.ide.meta.gef.editors.source.gen.core.IDEModelMapParser;
import aurora.ide.meta.preference.UIPrototypeGeneratorPreferencePage;
import aurora.plugin.source.gen.BuilderSession;
import aurora.plugin.source.gen.ISourceTemplateProvider;
import aurora.plugin.source.gen.ModelMapParser;
import aurora.plugin.source.gen.SourceGenManager;
import aurora.plugin.source.gen.SourceTemplateProvider;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.composite.IterationHandle;

public class GeneratorManager {
    private SourceGenManager sgm;
    private SourceTemplateProvider stp;

    private GeneratorManager(final IProject project) {
        this.sgm = new SourceGenManager(){

            public ModelMapParser createModelMapParser(CompositeMap model) {
                IDEModelMapParser mmp = new IDEModelMapParser(model, project);
                return mmp;
            }

            protected void loadBuilders() {
                if (this.getBuilders() != null) {
                    return;
                }
                this.setBuilders(new HashMap());
                File f = new File(UIPrototypeGeneratorPreferencePage.getPath());
                File config = new File(f, "config");
                File component_file = new File(config, "components.xml");
                CompositeLoader loader = new CompositeLoader();
                try {
                    CompositeMap components = loader.loadByFullFilePath(component_file.getPath());
                    components.iterate(new IterationHandle(){

                        public int process(CompositeMap map) {
                            String component_type = map.getString((Object)"component_type", "");
                            String builder = map.getString((Object)"builder", "");
                            if (!"".equals(component_type)) {
                                this.getBuilders().put(component_type.toLowerCase(), builder);
                            }
                            return 0;
                        }
                    }, false);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        this.stp = new SourceTemplateProvider(){
            private File theme;

            protected File getTemplateTheme() {
                if (this.theme != null) {
                    return this.theme;
                }
                File f = new File(UIPrototypeGeneratorPreferencePage.getPath());
                File tFolder = new File(f, "template");
                this.theme = new File(tFolder, this.getTemplate());
                return this.theme;
            }
        };
        this.sgm.setTemplateProvider((ISourceTemplateProvider)this.stp);
        this.stp.setSourceGenManager(this.sgm);
        this.stp.setTemplate("default");
        this.stp.initialize();
    }

    public static IPath getDefaultSourceGenTemplatePath() {
        IPath template = MetaPlugin.getDefault().getStateLocation().append("source.gen");
        return template;
    }

    public static GeneratorManager createNewInstance(IProject project) {
        GeneratorManager generatorManager = new GeneratorManager(project);
        return generatorManager;
    }

    public CompositeMap buildScreen(CompositeMap modelMap, BuilderSession session) throws IOException, SAXException {
        return this.sgm.buildScreen(modelMap, session);
    }

    public BuilderSession createBuilderSession() {
        return new BuilderSession(this.sgm);
    }
}

