/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.property;

import aurora.ide.AuroraPlugin;
import aurora.ide.editor.textpage.ColorManager;
import aurora.ide.editor.textpage.JavaScriptConfiguration;
import aurora.ide.meta.gef.editors.composite.IPathChangeListener;
import aurora.ide.meta.gef.editors.composite.ScreenUIPBrowseButton;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import aurora.ide.meta.gef.editors.property.EditWizard;
import aurora.ide.meta.gef.editors.property.Messages;
import aurora.ide.meta.gef.editors.wizard.dialog.ParameterComposite;
import aurora.ide.meta.gef.util.MessageUtil;
import aurora.ide.meta.project.AuroraMetaProject;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.IDialogEditableObject;
import aurora.plugin.source.gen.screen.model.Renderer;
import aurora.plugin.source.gen.screen.model.ScreenBody;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class RendererEditDialog
extends EditWizard {
    private static final Color SELECTION_BG = new Color(null, 109, 187, 242);
    private Button[] radios = new Button[Renderer.RENDERER_TYPES.length];
    private Composite composite_right;
    private Renderer renderer;
    private String tmpOpenPath;
    private String tmpLabelText;
    private String tmpFunctionName;
    private String tmpFunction;
    private String tmpRendererType;
    private InnerPage page;
    public IProject auroraProject;
    private ParameterComposite pc;

    public RendererEditDialog() {
        this.setWindowTitle("renderer");
    }

    public void setDialogEdiableObject(IDialogEditableObject obj) {
        this.renderer = (Renderer)obj;
    }

    public void addPages() {
        this.page = new InnerPage("renderer");
        this.addPage((IWizardPage)this.page);
        super.addPages();
    }

    public boolean performFinish() {
        this.renderer.setRendererType(this.tmpRendererType);
        this.renderer.setOpenPath(this.tmpOpenPath);
        this.renderer.getParameters().clear();
        if (this.pc != null) {
            this.renderer.getParameters().addAll(this.pc.getParameters());
        }
        this.renderer.setLabelText(this.tmpLabelText);
        this.renderer.setFunctionName(this.tmpFunctionName);
        this.renderer.setFunction(this.tmpFunction);
        return true;
    }

    private class InnerPage
    extends WizardPage
    implements SelectionListener {
        private String[] displayTexts;

        protected InnerPage(String pageName) {
            super(pageName);
            this.displayTexts = new String[]{Messages.RendererEditDialog_2, Messages.RendererEditDialog_3, Messages.RendererEditDialog_4, Messages.RendererEditDialog_5};
            this.setTitle(Messages.RendererEditDialog_6);
        }

        public void createControl(Composite parent) {
            SashForm sashForm = new SashForm(parent, 0);
            sashForm.setBackground(ColorConstants.GRID_COLUMN_GRAY);
            sashForm.setSashWidth(1);
            Composite composite_left = new Composite((Composite)sashForm, 0);
            RowLayout rw = new RowLayout(512);
            rw.fill = true;
            rw.spacing = 5;
            composite_left.setLayout((Layout)rw);
            RendererEditDialog.this.composite_right = new Composite((Composite)sashForm, 0);
            boolean created = false;
            int i = 0;
            while (i < RendererEditDialog.this.radios.length) {
                ((RendererEditDialog)RendererEditDialog.this).radios[i] = new Button(composite_left, 16);
                RendererEditDialog.this.radios[i].setText(this.displayTexts[i]);
                RendererEditDialog.this.radios[i].addSelectionListener((SelectionListener)this);
                RendererEditDialog.this.tmpRendererType = RendererEditDialog.this.renderer.getRendererType();
                if (Renderer.RENDERER_TYPES[i].equals(RendererEditDialog.this.tmpRendererType)) {
                    RendererEditDialog.this.radios[i].setSelection(true);
                    RendererEditDialog.this.radios[i].setBackground(SELECTION_BG);
                    this.createRight(i);
                    created = true;
                }
                ++i;
            }
            if (!created) {
                RendererEditDialog.this.radios[0].setSelection(true);
                RendererEditDialog.this.radios[0].notifyListeners(13, null);
            }
            sashForm.setWeights(new int[]{1, 3});
            this.setControl((Control)sashForm);
        }

        private void createRight(int idx) {
            Control[] controlArray = RendererEditDialog.this.composite_right.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
            this.setErrorMessage(null);
            this.setPageComplete(true);
            if (idx == 0) {
                this.create_0();
            } else if (idx == 1) {
                this.create_1();
            } else if (idx == 2) {
                this.create_2();
            } else {
                this.create_3();
            }
            RendererEditDialog.this.composite_right.layout();
        }

        private void create_0() {
            RendererEditDialog.this.composite_right.setLayout((Layout)new FillLayout());
            Label l = new Label(RendererEditDialog.this.composite_right, 0x1000000);
            l.setForeground(ColorConstants.EDITOR_BORDER);
            l.setText(Messages.RendererEditDialog_7);
        }

        private void create_1() {
            RendererEditDialog.this.composite_right.setLayout((Layout)new GridLayout(3, false));
            Label label = new Label(RendererEditDialog.this.composite_right, 0);
            label.setText(Messages.RendererEditDialog_8);
            final Text text1 = new Text(RendererEditDialog.this.composite_right, 2048);
            text1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            RendererEditDialog.this.tmpLabelText = RendererEditDialog.this.renderer.getLabelText();
            if (RendererEditDialog.this.tmpLabelText == null) {
                RendererEditDialog.this.tmpLabelText = "";
            }
            text1.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RendererEditDialog.this.tmpLabelText = text1.getText();
                }
            });
            text1.setText(RendererEditDialog.this.tmpLabelText);
            new Label(RendererEditDialog.this.composite_right, 0);
            label = new Label(RendererEditDialog.this.composite_right, 0);
            label.setText(Messages.RendererEditDialog_10);
            final Text text = new Text(RendererEditDialog.this.composite_right, 2048);
            text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            RendererEditDialog.this.tmpOpenPath = RendererEditDialog.this.renderer.getOpenPath();
            if (RendererEditDialog.this.tmpOpenPath == null || RendererEditDialog.this.tmpOpenPath == "") {
                RendererEditDialog.this.tmpOpenPath = "";
                this.setPageComplete(false);
                this.setErrorMessage(Messages.RendererEditDialog_13);
            }
            text.setText(RendererEditDialog.this.tmpOpenPath);
            text.setEditable(false);
            ScreenUIPBrowseButton btn = new ScreenUIPBrowseButton(RendererEditDialog.this.composite_right, 0x800000);
            btn.setText(Messages.RendererEditDialog_14);
            IProject proj = AuroraPlugin.getActiveIFile().getProject();
            AuroraMetaProject mProj = new AuroraMetaProject(proj);
            try {
                RendererEditDialog.this.auroraProject = mProj.getAuroraProject();
            }
            catch (Exception e1) {
                RendererEditDialog.this.auroraProject = null;
            }
            if (RendererEditDialog.this.auroraProject == null) {
                btn.setEnabled(false);
                this.setErrorMessage(Messages.RendererEditDialog_15);
                this.setPageComplete(false);
                return;
            }
            btn.setAuroraProject(RendererEditDialog.this.auroraProject);
            btn.addListener(new IPathChangeListener(){

                public void pathChanged(String openPath) {
                    if (openPath != null) {
                        InnerPage.this.setPageComplete(true);
                        InnerPage.this.setErrorMessage(null);
                        RendererEditDialog.this.tmpOpenPath = openPath;
                        text.setText(RendererEditDialog.this.tmpOpenPath);
                    }
                }
            });
            this.createParaTable(RendererEditDialog.this.composite_right);
        }

        private void createParaTable(Composite composite_right) {
            AuroraComponent comp = (AuroraComponent)RendererEditDialog.this.renderer.getContextInfo();
            ScreenBody root = null;
            while (comp != null) {
                if (comp instanceof ScreenBody) {
                    root = (ScreenBody)comp;
                    break;
                }
                comp = comp.getParent();
            }
            if (root == null) {
                this.setErrorMessage(Messages.ButtonClickEditDialog_9);
                this.setPageComplete(false);
                return;
            }
            GridData data = new GridData(1808);
            data.horizontalSpan = 3;
            RendererEditDialog.this.pc = new ParameterComposite(root, composite_right, 0, (AuroraComponent)RendererEditDialog.this.renderer.getContextInfo());
            RendererEditDialog.this.pc.setLayoutData(data);
            RendererEditDialog.this.pc.setParameters(RendererEditDialog.this.renderer.getParameters());
        }

        private void create_2() {
            RendererEditDialog.this.composite_right.setLayout((Layout)new GridLayout(1, false));
            final Label l = new Label(RendererEditDialog.this.composite_right, 64);
            l.setLayoutData((Object)new GridData(4, 2, true, false));
            final List list = new List(RendererEditDialog.this.composite_right, 2048);
            list.setLayoutData((Object)new GridData(4, 4, true, true));
            list.setItems(Renderer.INNER_FUNCTIONS);
            list.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int idx = list.getSelectionIndex();
                    l.setText(MessageUtil.INNER_RENDERER_DESC()[idx]);
                    RendererEditDialog.this.tmpFunctionName = Renderer.INNER_FUNCTIONS[idx];
                    InnerPage.this.setErrorMessage(null);
                    InnerPage.this.setPageComplete(true);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            RendererEditDialog.this.tmpFunctionName = RendererEditDialog.this.renderer.getFunctionName();
            int i = 0;
            while (i < Renderer.INNER_FUNCTIONS.length) {
                if (Renderer.INNER_FUNCTIONS[i].equals(RendererEditDialog.this.tmpFunctionName)) {
                    list.select(i);
                    l.setText(MessageUtil.INNER_RENDERER_DESC()[i]);
                    break;
                }
                ++i;
            }
            if (list.getSelection().length == 0) {
                this.setErrorMessage(Messages.RendererEditDialog_18);
                this.setPageComplete(false);
            }
        }

        private void create_3() {
            RendererEditDialog.this.composite_right.setLayout((Layout)new GridLayout(1, false));
            Label l = new Label(RendererEditDialog.this.composite_right, 0);
            l.setLayoutData((Object)new GridData(4, 2, true, false));
            l.setText(Messages.RendererEditDialog_19);
            final SourceViewer jsEditor = new SourceViewer(RendererEditDialog.this.composite_right, null, 2818);
            jsEditor.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            jsEditor.configure((SourceViewerConfiguration)new JavaScriptConfiguration(new ColorManager()));
            jsEditor.getTextWidget().setFont(new Font(null, "Consolas", 10, 0));
            Document document = new Document();
            jsEditor.setDocument((IDocument)document);
            RendererEditDialog.this.tmpFunction = RendererEditDialog.this.renderer.getFunction();
            if (RendererEditDialog.this.tmpFunction == null || RendererEditDialog.this.tmpFunction.trim().length() == 0) {
                RendererEditDialog.this.tmpFunction = "function myRenderer(value,record,name){\n\treturn 'rendererText';\n}";
            }
            jsEditor.getTextWidget().setText(RendererEditDialog.this.tmpFunction);
            jsEditor.getTextWidget().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RendererEditDialog.this.tmpFunction = jsEditor.getTextWidget().getText();
                    String msg = RendererEditDialog.this.validateFunction(RendererEditDialog.this.tmpFunction);
                    InnerPage.this.setErrorMessage(msg.length() == 0 ? null : RendererEditDialog.this.validateFunction(RendererEditDialog.this.tmpFunction));
                    InnerPage.this.setPageComplete(msg.length() == 0);
                }
            });
        }

        public void widgetSelected(SelectionEvent e) {
            int i = 0;
            while (i < RendererEditDialog.this.radios.length) {
                if (RendererEditDialog.this.radios[i] == e.getSource()) {
                    if (RendererEditDialog.this.radios[i].getSelection()) {
                        this.createRight(i);
                        RendererEditDialog.this.tmpRendererType = Renderer.RENDERER_TYPES[i];
                        RendererEditDialog.this.radios[i].setBackground(SELECTION_BG);
                        this.setDescription(this.displayTexts[i]);
                    } else {
                        RendererEditDialog.this.radios[i].setBackground(RendererEditDialog.this.radios[i].getParent().getBackground());
                    }
                }
                ++i;
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

