/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.property;

import aurora.ide.meta.gef.editors.property.PropertyItem;
import aurora.ide.meta.gef.editors.property.PropertySheetSorter;
import aurora.ide.meta.gef.editors.property.PropertyViewer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetEntryListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertySheetViewer
extends Viewer {
    private Object[] input;
    private IPropertySheetEntry rootEntry;
    private PropertyViewer pv2;
    private HashMap<IPropertySheetEntry, PropertyItem> entryToItemMap = new HashMap();
    private IPropertySheetEntryListener entryListener;
    private PropertySheetSorter sorter = new PropertySheetSorter();

    public PropertySheetViewer(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        scrolledComposite.setLayoutData((Object)new GridData(1808));
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.pv2 = new PropertyViewer((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)this.pv2);
        this.createEntryListener();
    }

    private void createEntryListener() {
        this.entryListener = new IPropertySheetEntryListener(){

            public void childEntriesChanged(IPropertySheetEntry entry) {
                if (entry == PropertySheetViewer.this.rootEntry) {
                    PropertySheetViewer.this.updateChildrenOf(entry, PropertySheetViewer.this.pv2);
                }
            }

            public void valueChanged(IPropertySheetEntry entry) {
                PropertyItem item = PropertySheetViewer.this.findItem(entry);
                if (item != null) {
                    PropertySheetViewer.this.updateEntry(entry, item);
                }
            }

            public void errorMessageChanged(IPropertySheetEntry entry) {
            }
        };
    }

    private void createItem(IPropertySheetEntry node, int index) {
        PropertyItem item = this.pv2.createItem(node, index);
        this.entryToItemMap.put(node, item);
        item.getControl((Composite)this.pv2).addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Object possibleEntry = e.widget.getData();
                if (possibleEntry != null) {
                    PropertySheetViewer.this.entryToItemMap.remove(possibleEntry);
                }
            }
        });
        node.addPropertySheetEntryListener(this.entryListener);
    }

    private void entrySelectionChanged() {
        SelectionChangedEvent changeEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        this.fireSelectionChanged(changeEvent);
    }

    private PropertyItem findItem(IPropertySheetEntry entry) {
        PropertyItem[] items = this.pv2.getItems();
        int i = 0;
        while (i < items.length) {
            PropertyItem item = items[i];
            PropertyItem findItem = this.findItem(entry, item);
            if (findItem != null) {
                return findItem;
            }
            ++i;
        }
        return null;
    }

    private PropertyItem findItem(IPropertySheetEntry entry, PropertyItem item) {
        PropertyItem mapItem = this.entryToItemMap.get(entry);
        if (mapItem != null && mapItem instanceof PropertyItem) {
            return mapItem;
        }
        if (entry == item.getData()) {
            return item;
        }
        return null;
    }

    private List<IPropertySheetEntry> getChildren(Object node) {
        IPropertySheetEntry entry = null;
        if (!(node instanceof IPropertySheetEntry)) {
            return Collections.emptyList();
        }
        entry = (IPropertySheetEntry)node;
        return this.getChildren(entry);
    }

    private List<IPropertySheetEntry> getChildren(IPropertySheetEntry entry) {
        return this.getSortedEntries(this.getFilteredEntries(entry.getChildEntries()));
    }

    public Control getControl() {
        return this.pv2;
    }

    private List<IPropertySheetEntry> getFilteredEntries(IPropertySheetEntry[] entries) {
        ArrayList<IPropertySheetEntry> filteredEntries = new ArrayList<IPropertySheetEntry>(entries.length);
        int i = 0;
        while (i < entries.length) {
            IPropertySheetEntry entry = entries[i];
            if (entry != null) {
                String[] filters = entry.getFilters();
                boolean expert = false;
                if (filters != null) {
                    int j = 0;
                    while (j < filters.length) {
                        if (filters[j].equals("org.eclipse.ui.views.properties.expert")) {
                            expert = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (!expert) {
                    filteredEntries.add(entry);
                }
            }
            ++i;
        }
        return filteredEntries;
    }

    private List<IPropertySheetEntry> getSortedEntries(List<IPropertySheetEntry> unsortedEntries) {
        IPropertySheetEntry[] propertySheetEntries = unsortedEntries.toArray(new IPropertySheetEntry[unsortedEntries.size()]);
        return Arrays.asList(propertySheetEntries);
    }

    public Object getInput() {
        return this.input;
    }

    public IPropertySheetEntry getRootEntry() {
        return this.rootEntry;
    }

    public ISelection getSelection() {
        return new StructuredSelection(Collections.EMPTY_LIST);
    }

    public void refresh() {
        if (this.rootEntry != null) {
            this.updateChildrenOf(this.rootEntry, this.pv2);
        }
    }

    private void removeItem(PropertyItem item) {
        IPropertySheetEntry data = item.getData();
        data.removePropertySheetEntryListener(this.entryListener);
        this.entryToItemMap.remove(data);
        this.pv2.removeItem(item);
    }

    public void resetProperties() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        Iterator itr = selection.iterator();
        while (itr.hasNext()) {
            ((IPropertySheetEntry)itr.next()).resetPropertyValue();
        }
    }

    public void setInput(Object newInput) {
        this.input = (Object[])newInput;
        if (this.input == null) {
            this.input = new Object[0];
        }
        if (this.rootEntry != null) {
            this.rootEntry.setValues(this.input);
            this.updateChildrenOf(this.rootEntry, this.pv2);
        }
    }

    public void setRootEntry(IPropertySheetEntry root) {
        if (this.rootEntry != null) {
            this.rootEntry.removePropertySheetEntryListener(this.entryListener);
        }
        this.rootEntry = root;
        this.rootEntry.addPropertySheetEntryListener(this.entryListener);
        this.setInput(this.input);
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public void setSorter(PropertySheetSorter sorter) {
        if (sorter == null) {
            sorter = new PropertySheetSorter();
        }
        this.sorter = sorter;
    }

    private void updateChildrenOf(Object node, PropertyViewer widget) {
        PropertyItem[] childItems = this.pv2.getItems();
        List<IPropertySheetEntry> children = this.getChildren(node);
        HashSet<IPropertySheetEntry> set = new HashSet<IPropertySheetEntry>(childItems.length * 2 + 1);
        int i = 0;
        while (i < childItems.length) {
            IPropertySheetEntry data = childItems[i].getData();
            if (data != null) {
                IPropertySheetEntry e = data;
                int ix = children.indexOf(e);
                if (ix < 0) {
                    this.removeItem(childItems[i]);
                } else {
                    set.add(e);
                }
            } else if (data == null) {
                this.removeItem(childItems[i]);
            }
            ++i;
        }
        int newSize = children.size();
        int i2 = 0;
        while (i2 < newSize) {
            IPropertySheetEntry el = children.get(i2);
            if (!set.contains(el)) {
                this.createItem(el, i2);
            }
            ++i2;
        }
        this.pv2.setRedraw(false);
        this.pv2.setRedraw(true);
        childItems = this.pv2.getItems();
        this.entrySelectionChanged();
    }

    private void updateEntry(IPropertySheetEntry entry, PropertyItem item) {
        item.setData(entry);
        this.entryToItemMap.put(entry, item);
    }
}

