/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.property;

import aurora.plugin.source.gen.screen.model.AuroraComponent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetEntryListener;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class PropertySheetEntry
extends EventManager
implements IPropertySheetEntry {
    private Object[] values = new Object[0];
    private Map sources = new HashMap(0);
    private Object editValue;
    private PropertySheetEntry parent;
    private IPropertySourceProvider propertySourceProvider;
    private IPropertyDescriptor descriptor;
    private CellEditor editor;
    private String errorText;
    private PropertySheetEntry[] childEntries = null;
    private AuroraComponent lastAc = null;
    private PropertyChangeListener pcListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            PropertySheetEntry.this.refreshChildEntries();
            PropertySheetEntry.this.fireValueChanged();
        }
    };
    private ICellEditorListener cellEditorListener = new ICellEditorListener(){

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
        }

        public void cancelEditor() {
        }

        public void applyEditorValue() {
            PropertySheetEntry.this.applyEditorValue();
        }
    };

    public void addPropertySheetEntryListener(IPropertySheetEntryListener listener) {
        this.addListenerObject(listener);
    }

    public void applyEditorValue() {
        if (this.editor == null) {
            return;
        }
        if (!this.editor.isValueValid()) {
            return;
        }
        Object newValue = this.editor.getValue();
        this.setValue(newValue);
    }

    private List computeMergedPropertyDescriptors() {
        if (this.values.length == 0) {
            return new ArrayList(0);
        }
        IPropertySource firstSource = this.getPropertySource(this.values[0]);
        if (firstSource == null) {
            return new ArrayList(0);
        }
        if (this.values.length == 1) {
            return Arrays.asList(firstSource.getPropertyDescriptors());
        }
        Map[] propertyDescriptorMaps = new Map[this.values.length];
        int i = 0;
        while (i < this.values.length) {
            Object object = this.values[i];
            IPropertySource source = this.getPropertySource(object);
            if (source == null) {
                return new ArrayList(0);
            }
            propertyDescriptorMaps[i] = this.computePropertyDescriptorsFor(source);
            ++i;
        }
        Map intersection = propertyDescriptorMaps[0];
        int i2 = 1;
        while (i2 < propertyDescriptorMaps.length) {
            Object[] ids = intersection.keySet().toArray();
            int j = 0;
            while (j < ids.length) {
                Object object = propertyDescriptorMaps[i2].get(ids[j]);
                if (object == null || !((IPropertyDescriptor)intersection.get(ids[j])).isCompatibleWith((IPropertyDescriptor)object)) {
                    intersection.remove(ids[j]);
                }
                ++j;
            }
            ++i2;
        }
        ArrayList<IPropertyDescriptor> result = new ArrayList<IPropertyDescriptor>(intersection.size());
        IPropertyDescriptor[] firstDescs = firstSource.getPropertyDescriptors();
        int i3 = 0;
        while (i3 < firstDescs.length) {
            IPropertyDescriptor desc = firstDescs[i3];
            if (intersection.containsKey(desc.getId())) {
                result.add(desc);
            }
            ++i3;
        }
        return result;
    }

    private Map computePropertyDescriptorsFor(IPropertySource source) {
        IPropertyDescriptor[] descriptors = source.getPropertyDescriptors();
        HashMap<Object, IPropertyDescriptor> result = new HashMap<Object, IPropertyDescriptor>(descriptors.length * 2 + 1);
        int i = 0;
        while (i < descriptors.length) {
            result.put(descriptors[i].getId(), descriptors[i]);
            ++i;
        }
        return result;
    }

    private void createChildEntries() {
        List descriptors = this.computeMergedPropertyDescriptors();
        PropertySheetEntry[] newEntries = new PropertySheetEntry[descriptors.size()];
        int i = 0;
        while (i < descriptors.size()) {
            IPropertyDescriptor d = (IPropertyDescriptor)descriptors.get(i);
            PropertySheetEntry entry = this.createChildEntry();
            entry.setDescriptor(d);
            entry.setParent(this);
            entry.setPropertySourceProvider(this.propertySourceProvider);
            entry.refreshValues();
            newEntries[i] = entry;
            ++i;
        }
        this.childEntries = newEntries;
    }

    protected PropertySheetEntry createChildEntry() {
        return new PropertySheetEntry();
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        PropertySheetEntry[] entriesToDispose = this.childEntries;
        this.childEntries = null;
        if (entriesToDispose != null) {
            int i = 0;
            while (i < entriesToDispose.length) {
                if (entriesToDispose[i] != null) {
                    entriesToDispose[i].dispose();
                }
                ++i;
            }
        }
    }

    private void fireChildEntriesChanged() {
        Object[] array = this.getListeners();
        int i = 0;
        while (i < array.length) {
            IPropertySheetEntryListener listener = (IPropertySheetEntryListener)array[i];
            listener.childEntriesChanged((IPropertySheetEntry)this);
            ++i;
        }
    }

    private void fireErrorMessageChanged() {
        Object[] array = this.getListeners();
        int i = 0;
        while (i < array.length) {
            IPropertySheetEntryListener listener = (IPropertySheetEntryListener)array[i];
            listener.errorMessageChanged((IPropertySheetEntry)this);
            ++i;
        }
    }

    private void fireValueChanged() {
        Object[] array = this.getListeners();
        int i = 0;
        while (i < array.length) {
            IPropertySheetEntryListener listener = (IPropertySheetEntryListener)array[i];
            listener.valueChanged((IPropertySheetEntry)this);
            ++i;
        }
    }

    public String getCategory() {
        return this.descriptor.getCategory();
    }

    public IPropertySheetEntry[] getChildEntries() {
        if (this.childEntries == null) {
            this.createChildEntries();
        }
        return this.childEntries;
    }

    public String getDescription() {
        return this.descriptor.getDescription();
    }

    protected IPropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getDisplayName() {
        return this.descriptor.getDisplayName();
    }

    public CellEditor getEditor(Composite parent) {
        if (this.editor == null || this.editor.getControl().isDisposed()) {
            this.editor = this.descriptor.createPropertyEditor(parent);
            if (this.editor != null) {
                this.editor.addListener(this.cellEditorListener);
            }
        }
        if (this.editor != null) {
            this.editor.setValue(this.editValue);
        }
        return this.editor;
    }

    private boolean eq(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    protected Object getEditValue(int index) {
        Object value = this.values[index];
        IPropertySource source = this.getPropertySource(value);
        if (source != null) {
            value = source.getEditableValue();
        }
        return value;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public String[] getFilters() {
        return this.descriptor.getFilterFlags();
    }

    public Object getHelpContextIds() {
        return this.descriptor.getHelpContextIds();
    }

    public Image getImage() {
        ILabelProvider provider = this.descriptor.getLabelProvider();
        if (provider == null) {
            return null;
        }
        return provider.getImage(this.editValue);
    }

    protected PropertySheetEntry getParent() {
        return this.parent;
    }

    protected IPropertySource getPropertySource(Object object) {
        if (this.sources.containsKey(object)) {
            return (IPropertySource)this.sources.get(object);
        }
        IPropertySource result = null;
        IPropertySourceProvider provider = this.propertySourceProvider;
        if (provider != null) {
            result = provider.getPropertySource(object);
        }
        this.sources.put(object, result);
        return result;
    }

    public String getValueAsString() {
        if (this.editValue == null) {
            return "";
        }
        ILabelProvider provider = this.descriptor.getLabelProvider();
        if (provider == null) {
            return this.editValue.toString();
        }
        String text = provider.getText(this.editValue);
        if (text == null) {
            return "";
        }
        return text;
    }

    public Object[] getValues() {
        return this.values;
    }

    public boolean hasChildEntries() {
        if (this.childEntries != null && this.childEntries.length > 0) {
            return true;
        }
        return this.computeMergedPropertyDescriptors().size() > 0;
    }

    private void refreshChildEntries() {
        if (this.childEntries == null) {
            return;
        }
        List descriptors = this.computeMergedPropertyDescriptors();
        ArrayList<PropertySheetEntry> entriesToDispose = new ArrayList<PropertySheetEntry>(Arrays.asList(this.childEntries));
        this.childEntries = null;
        PropertySheetEntry[] newEntries = new PropertySheetEntry[descriptors.size()];
        boolean entriesChanged = true;
        int i = 0;
        while (i < descriptors.size()) {
            IPropertyDescriptor d = (IPropertyDescriptor)descriptors.get(i);
            PropertySheetEntry entry = null;
            entry = this.createChildEntry();
            entry.setDescriptor(d);
            entry.setParent(this);
            entry.setPropertySourceProvider(this.propertySourceProvider);
            entriesChanged = true;
            entry.refreshValues();
            newEntries[i] = entry;
            ++i;
        }
        this.childEntries = newEntries;
        if (entriesChanged) {
            this.fireChildEntriesChanged();
        }
        i = 0;
        while (i < entriesToDispose.size()) {
            ((IPropertySheetEntry)entriesToDispose.get(i)).dispose();
            ++i;
        }
    }

    protected void refreshFromRoot() {
        this.refreshChildEntries();
    }

    private void refreshValues() {
        Object[] currentSources = this.parent.getValues();
        Object[] newValues = new Object[currentSources.length];
        int i = 0;
        while (i < currentSources.length) {
            IPropertySource source = this.parent.getPropertySource(currentSources[i]);
            newValues[i] = source.getPropertyValue(this.descriptor.getId());
            ++i;
        }
        this.setValues(newValues);
    }

    public void removePropertySheetEntryListener(IPropertySheetEntryListener listener) {
        this.removeListenerObject(listener);
    }

    public void resetPropertyValue() {
        if (this.parent == null) {
            return;
        }
        boolean change = false;
        Object[] objects = this.parent.getValues();
        int i = 0;
        while (i < objects.length) {
            IPropertySource source = this.getPropertySource(objects[i]);
            if (source.isPropertySet(this.descriptor.getId())) {
                source.resetPropertyValue(this.descriptor.getId());
                change = true;
            }
            ++i;
        }
        if (change) {
            this.refreshFromRoot();
        }
    }

    private void setDescriptor(IPropertyDescriptor newDescriptor) {
        if (this.descriptor != newDescriptor && this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        this.descriptor = newDescriptor;
    }

    private void setParent(PropertySheetEntry propertySheetEntry) {
        this.parent = propertySheetEntry;
    }

    public void setPropertySourceProvider(IPropertySourceProvider provider) {
        this.propertySourceProvider = provider;
    }

    private void setValue(Object newValue) {
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = newValue;
            ++i;
        }
        this.parent.valueChanged(this);
        this.refreshFromRoot();
    }

    public void setValues(Object[] objects) {
        this.values = objects;
        this.sources = new HashMap(this.values.length * 2 + 1);
        if (this.values.length == 0) {
            this.editValue = null;
        } else {
            Object newValue = this.values[0];
            IPropertySource source = this.getPropertySource(newValue);
            if (source != null && (newValue = source.getEditableValue()) instanceof AuroraComponent) {
                if (this.lastAc != null) {
                    this.lastAc.removePropertyChangeListener(this.pcListener);
                }
                this.lastAc = (AuroraComponent)newValue;
                this.lastAc.addPropertyChangeListener(this.pcListener);
            }
            this.editValue = newValue;
        }
        this.refreshChildEntries();
        this.fireValueChanged();
    }

    protected void valueChanged(PropertySheetEntry child) {
        int i = 0;
        while (i < this.values.length) {
            IPropertySource source = this.getPropertySource(this.values[i]);
            source.setPropertyValue(child.getDescriptor().getId(), child.getEditValue(i));
            ++i;
        }
        if (this.parent != null) {
            this.parent.valueChanged(this);
        }
    }
}

