/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.property;

import aurora.ide.libs.AuroraImagesUtils;
import aurora.ide.meta.gef.editors.property.EditWizard;
import aurora.plugin.source.gen.screen.model.DialogEditableObject;
import aurora.plugin.source.gen.screen.model.IDialogEditableObject;
import java.io.FileNotFoundException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class IconSelectionDialog
extends EditWizard {
    private DialogEditableObject obj;

    public IconSelectionDialog() {
        this.setWindowTitle("ICON");
    }

    public void addPages() {
        this.addPage((IWizardPage)new InnerPage("LocalIconSelection"));
    }

    public void setDialogEdiableObject(IDialogEditableObject obj) {
        if (obj instanceof DialogEditableObject && "icon_bytes_data".equals(((DialogEditableObject)obj).getPropertyId())) {
            this.obj = (DialogEditableObject)obj;
        }
    }

    private String getIconData() {
        if (this.obj instanceof DialogEditableObject && "icon_bytes_data".equals(this.obj.getPropertyId())) {
            Object data = this.obj.getData();
            return data == null ? "" : data.toString();
        }
        return "";
    }

    public boolean performFinish() {
        return true;
    }

    private class InnerPage
    extends WizardPage {
        private Text t;

        protected InnerPage(String pageName) {
            super(pageName);
            this.setTitle("ICON");
            this.setMessage("\u9009\u62e9\u4e00\u4e2a16*16\u5927\u5c0f\u7684\u56fe\u7247");
        }

        public void createControl(Composite parent) {
            Composite root = new Composite(parent, 0);
            root.setLayout((Layout)new GridLayout(4, false));
            Label l = new Label(root, 0);
            l.setText("ICON:");
            this.t = new Text(root, 2056);
            this.t.setLayoutData((Object)new GridData(768));
            Button b1 = new Button(root, 0);
            b1.setText("\u6d4f\u89c8");
            b1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InnerPage.this.queryIcon();
                }
            });
            Button b2 = new Button(root, 0);
            b2.setText("\u6e05\u9664");
            b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InnerPage.this.clear();
                }
            });
            this.setControl((Control)root);
            this.refreshText();
        }

        private void refreshText() {
            String iconData = IconSelectionDialog.this.getIconData();
            this.t.setText(!"".equals(iconData) ? "\u5df2\u8bbe\u7f6e" : "\u672a\u8bbe\u7f6e");
        }

        private void queryIcon() {
            String path = AuroraImagesUtils.queryFile((Shell)this.getShell());
            if (path != null) {
                try {
                    Path p = new Path(path);
                    String fileExtension = p.getFileExtension();
                    int iconType = AuroraImagesUtils.getIconType((String)fileExtension);
                    if (iconType == -1) {
                        return;
                    }
                    ImageData loadImageData = AuroraImagesUtils.loadImageData((Path)p);
                    byte[] bytes = AuroraImagesUtils.toBytes((ImageData)loadImageData, (int)iconType);
                    if (IconSelectionDialog.this.obj instanceof DialogEditableObject) {
                        IconSelectionDialog.this.obj.setData((Object)AuroraImagesUtils.toString((byte[])bytes));
                        IconSelectionDialog.this.obj.setDescripition("Y");
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
            this.refreshText();
        }

        private void clear() {
            if (IconSelectionDialog.this.obj instanceof DialogEditableObject) {
                IconSelectionDialog.this.obj.setData((Object)"");
                IconSelectionDialog.this.obj.setDescripition("N");
            }
            this.refreshText();
        }
    }
}

