/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.property;

import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.ide.meta.gef.editors.property.EditablePropertyFactory;
import aurora.ide.meta.gef.editors.property.PropertyManager;
import aurora.ide.meta.gef.editors.property.StylePropertyDescriptor;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.IDatasetDelegate;
import aurora.plugin.source.gen.screen.model.IDatasetFieldDelegate;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class DefaultPropertySource
implements IPropertySource {
    private IPropertyDescriptor[] defaultPD = EditablePropertyFactory.NONE_PROPS;
    private PropertyManager manager;
    private AuroraComponent component;

    public DefaultPropertySource(ComponentPart componentPart, PropertyManager manager) {
        this.manager = manager;
        this.component = componentPart.getComponent();
        this.defaultPD = manager.getPropertyDescriptors(componentPart);
    }

    public void setPropertyValue(Object id, Object value) {
        this.manager.setPropertyValue(id, value, this.getRealComponent(id));
    }

    public void resetPropertyValue(Object id) {
    }

    public boolean isPropertySet(Object id) {
        return true;
    }

    public Object getPropertyValue(Object id) {
        return this.getRealComponent(id).getPropertyValue("" + id);
    }

    private AuroraComponent getRealComponent(Object id) {
        IPropertyDescriptor[] iPropertyDescriptorArray = this.defaultPD;
        int n = this.defaultPD.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyDescriptor pd = iPropertyDescriptorArray[n2];
            if (pd instanceof StylePropertyDescriptor) {
                int style = ((StylePropertyDescriptor)pd).getStyle();
                boolean flag = pd.getId().equals(id);
                if (flag && (style & 4) != 0 && this.component instanceof IDatasetDelegate) {
                    return ((IDatasetDelegate)this.component).getDataset();
                }
                if (flag && (style & 8) != 0 && this.component instanceof IDatasetFieldDelegate) {
                    return ((IDatasetFieldDelegate)this.component).getDatasetField();
                }
                if (flag && (style & 0x10) != 0) {
                    AuroraComponent ac = this.component.getAuroraComponentPropertyValue(((StylePropertyDescriptor)pd).getChildPropertyId());
                    if (ac != null) {
                        return ac;
                    }
                    return this.component;
                }
            }
            ++n2;
        }
        return this.component;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.defaultPD;
    }

    public Object getEditableValue() {
        return this.component;
    }
}

