/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.parts;

import aurora.ide.meta.gef.editors.figures.GridColumnCellEditorLocator;
import aurora.ide.meta.gef.editors.figures.GridColumnFigure;
import aurora.ide.meta.gef.editors.layout.GridColumnBackLayout2;
import aurora.ide.meta.gef.editors.parts.ContainerPart;
import aurora.ide.meta.gef.editors.policies.ComponentDirectEditPolicy;
import aurora.ide.meta.gef.editors.policies.GridLayoutEditPolicy;
import aurora.ide.meta.gef.editors.policies.NodeDirectEditManager;
import aurora.ide.prototype.consultant.demonstrate.DemonstrateEditorMode;
import aurora.plugin.source.gen.screen.model.GridColumn;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.jface.viewers.TextCellEditor;

public class SysLovGridColumnPart
extends ContainerPart {
    protected IFigure createFigure() {
        GridColumnFigure figure = new GridColumnFigure();
        figure.setModel(this.getModel());
        return figure;
    }

    public GridColumn getModel() {
        return (GridColumn)super.getModel();
    }

    public GridColumnFigure getFigure() {
        return (GridColumnFigure)super.getFigure();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new GridLayoutEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ComponentDirectEditPolicy());
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        String stringPropertyValue = this.getModel().getStringPropertyValue("fsd_meaning");
        if ("".equals(stringPropertyValue) || stringPropertyValue == null) {
            this.getFigure().setToolTip(null);
        } else {
            this.getFigure().setToolTip((IFigure)new Label(stringPropertyValue));
        }
    }

    public int getResizeDirection() {
        return 24;
    }

    public Rectangle layout() {
        GridColumnBackLayout2 layout = new GridColumnBackLayout2();
        return layout.layout(this);
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType()) && req instanceof LocationRequest) {
            int idx = this.getEditIndex((LocationRequest)req);
            String value = this.getModel().getStringPropertyValue("grid_column_simple_data_" + idx);
            if (this.getEditorMode() instanceof DemonstrateEditorMode) {
                ((DemonstrateEditorMode)this.getEditorMode()).getDemonstratingDialog().applyValue(value, idx);
            }
        }
        if (req.getType().equals("direct edit") && req instanceof DirectEditRequest) {
            GridColumnFigure figure = this.getFigure();
            int idx = this.getEditIndex((LocationRequest)req);
            if (idx == 0) {
                this.performPromptDirectEditRequest(figure);
            } else {
                this.performSimpleDataDirectEditRequest(figure, idx);
            }
        } else {
            super.performRequest(req);
        }
    }

    protected int getEditIndex(LocationRequest req) {
        GridColumnFigure figure = this.getFigure();
        Point location = req.getLocation();
        Rectangle bounds = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)bounds);
        int columnHight = figure.getColumnHight();
        int _y = location.y - bounds.y - columnHight;
        int idx = _y <= 0 ? 0 : _y / 25 + 1;
        return idx;
    }

    protected void performSimpleDataDirectEditRequest(GridColumnFigure figure, int idx) {
        NodeDirectEditManager manager = new NodeDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, new GridColumnCellEditorLocator(figure, idx), "grid_column_simple_data_" + idx);
        manager.show();
    }

    protected void performPromptDirectEditRequest(GridColumnFigure figure) {
        NodeDirectEditManager manager = new NodeDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, new GridColumnCellEditorLocator(figure, 0), "prompt");
        manager.show();
    }
}

