/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.parts;

import aurora.ide.helpers.ImagesUtils;
import aurora.ide.meta.gef.editors.figures.BoxFigure;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import aurora.ide.meta.gef.editors.figures.FigureUtil;
import aurora.ide.meta.gef.editors.figures.ResourceDisposer;
import aurora.ide.meta.gef.editors.layout.RowColBackLayout;
import aurora.ide.meta.gef.editors.parts.BoxPart;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.ide.meta.gef.editors.policies.NoSelectionEditPolicy;
import aurora.ide.meta.gef.util.BoundsConvert;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.BOX;
import aurora.plugin.source.gen.screen.model.QueryForm;
import java.util.List;
import org.eclipse.draw2d.AbstractBackground;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;

public class QueryFormToolBarPart
extends BoxPart {
    private ResourceDisposer disposer = new ResourceDisposer();

    protected IFigure createFigure() {
        BoxFigure figure = new BoxFigure();
        figure.setBox((BOX)this.getModel());
        figure.setBorder((Border)new AbstractBackground(){
            private Image bgImage = ImagesUtils.getImage((String)"toolbar_bg");

            public void paint(IFigure figure, Graphics g, Insets insets) {
            }

            public void paintBackground(IFigure figure, Graphics graphics, Insets insets) {
                graphics.drawImage(this.bgImage, new Rectangle(this.bgImage.getBounds()), figure.getBounds());
                List childs = figure.getChildren();
                if (((IFigure)childs.get(0)).getChildren().size() == 0) {
                    Rectangle hBoxRect = ((IFigure)childs.get(0)).getBounds();
                    hBoxRect = hBoxRect.getShrinked(new Insets(10, 10, 10, 10));
                    graphics.setForegroundColor(ColorConstants.WHITE);
                    graphics.fillRectangle(hBoxRect);
                    graphics.setForegroundColor(ColorConstants.EDITOR_BORDER);
                    graphics.drawRectangle(hBoxRect);
                    String hint = ((QueryForm)QueryFormToolBarPart.this.getParent().getModel()).getDefaultQueryHint();
                    FigureUtil.paintText(graphics, hBoxRect.translate(3, 1), hint, -1, 0);
                }
                tempRect.setBounds(1.getPaintRectangle((IFigure)figure, (Insets)insets));
                QueryFormToolBarPart.this.paintEtchedBorder(graphics, 1.tempRect);
            }
        });
        return figure;
    }

    private void paintEtchedBorder(Graphics g, Rectangle r) {
        this.disposeResource("shadow");
        this.disposeResource("highlight");
        Color rgb = g.getBackgroundColor();
        Color shadow = FigureUtilities.darker((Color)rgb);
        Color highlight = FigureUtilities.lighter((Color)rgb);
        this.handleResource("shadow", (Resource)shadow);
        this.handleResource("highlight", (Resource)highlight);
        FigureUtilities.paintEtchedBorder((Graphics)g, (Rectangle)r, (Color)shadow, (Color)highlight);
    }

    public void deactivate() {
        this.disposeResource();
        super.deactivate();
    }

    private void disposeResource() {
        this.disposer.disposeResource();
        this.disposer = null;
    }

    private void handleResource(String id, Resource r) {
        this.disposer.handleResource(id, r);
    }

    private void disposeResource(String prop_id) {
        this.disposer.disposeResource(prop_id);
    }

    protected void createEditPolicies() {
    }

    protected void addChild(EditPart child, int index) {
        child.installEditPolicy((Object)"translate_selection_to_parent", (EditPolicy)new NoSelectionEditPolicy());
        super.addChild(child, index);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
    }

    public Rectangle layout() {
        List list = this.getChildren();
        Rectangle rect = BoundsConvert.toDraw2d(((AuroraComponent)this.getModel()).getBoundsCopy());
        int buttonGap = 10;
        rect.height = 40;
        int buttonWidth = 80;
        int i = list.size() - 1;
        while (i > 0) {
            IFigure f1 = ((ComponentPart)list.get(i)).getFigure();
            Rectangle r1 = ((ComponentPart)list.get(i)).layout();
            buttonWidth = r1.width;
            r1.x = rect.width + rect.x - (r1.width + buttonGap) * (list.size() - i);
            r1.y = rect.y + (rect.height - r1.height) / 2;
            f1.setBounds(r1);
            --i;
        }
        ComponentPart hbox = (ComponentPart)list.get(0);
        IFigure f0 = hbox.getFigure();
        if (f0.getBorder() != null) {
            f0.setBorder(null);
        }
        f0.setBounds(new Rectangle(rect.x, rect.y, rect.width - buttonWidth * (list.size() - 1) - buttonGap * list.size(), rect.height));
        RowColBackLayout rowColBackLayout = new RowColBackLayout();
        rowColBackLayout.setPadding(new Insets(6, 0, 0, 0));
        rowColBackLayout.layout(hbox);
        return rect;
    }

    public boolean isLayoutHorizontal() {
        return true;
    }

    public int getResizeDirection() {
        return 0;
    }
}

