/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.parts;

import aurora.ide.meta.gef.editors.EditorMode;
import aurora.ide.meta.gef.editors.figures.IResourceDispose;
import aurora.ide.meta.gef.editors.layout.BackLayout;
import aurora.ide.meta.gef.editors.parts.ViewDiagramPart;
import aurora.ide.meta.gef.editors.policies.NodeEditPolicy;
import aurora.ide.meta.gef.editors.property.IPropertySource2;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public abstract class ComponentPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
PositionConstants {
    protected static final String RESIZE_KEY = "resize-key";
    private EditorMode editorMode;

    public void propertyChange(PropertyChangeEvent evt) {
        this.getFigure().getBounds();
        String prop = evt.getPropertyName();
        if (!"component_children".equals(prop)) {
            this.refreshVisuals();
        }
        if ("height".equals(prop) || "width".equals(prop) || "component_bounds".equals(prop) || "size".equals(prop) || "location".equals(prop) || "colspan".equals(prop) || "rowspan".equals(prop) || "minColWidth".equals(prop) || "minRowHeight".equals(prop)) {
            this.getFigure().revalidate();
        }
    }

    protected ViewDiagramPart getDiagramPart(EditPart ep) {
        if (ep instanceof ViewDiagramPart) {
            return (ViewDiagramPart)ep;
        }
        return this.getDiagramPart(ep.getParent());
    }

    public void activate() {
        super.activate();
        this.getComponent().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public AuroraComponent getComponent() {
        return (AuroraComponent)this.getModel();
    }

    public void deactivate() {
        this.getComponent().removePropertyChangeListener((PropertyChangeListener)this);
        IFigure figure = this.getFigure();
        if (figure instanceof IResourceDispose) {
            ((IResourceDispose)figure).disposeResource();
        }
        super.deactivate();
    }

    protected void refreshVisuals() {
        this.getFigure().repaint();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new NodeEditPolicy());
    }

    public EditorMode getEditorMode() {
        return this.editorMode;
    }

    public void setEditorMode(EditorMode editorMode) {
        this.editorMode = editorMode;
    }

    protected abstract IFigure createFigure();

    public int getResizeDirection() {
        return 0;
    }

    public IPropertySource2 getPropertySource2() {
        return (IPropertySource2)this.getModel();
    }

    public Rectangle layout() {
        return new BackLayout().layout(this);
    }
}

