/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.parts;

import aurora.ide.meta.MetaPlugin;
import aurora.ide.meta.gef.editors.figures.ButtonFigure;
import aurora.ide.meta.gef.editors.models.commands.ChangeTextStyleCommand;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.ide.meta.gef.editors.policies.ComponentDirectEditPolicy;
import aurora.ide.meta.gef.editors.policies.NodeDirectEditManager;
import aurora.ide.meta.gef.editors.wizard.dialog.TextEditDialog;
import aurora.ide.prototype.consultant.demonstrate.Demonstrating;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Button;
import aurora.plugin.source.gen.screen.model.StyledStringText;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Text;

public class ButtonPart
extends ComponentPart {
    private String type;

    protected IFigure createFigure() {
        ButtonFigure buttonFigure = new ButtonFigure();
        Button model = this.getModel();
        buttonFigure.setModel(model);
        return buttonFigure;
    }

    protected void refreshVisuals() {
        String title = this.getModel().getTitle();
        this.getFigure().setToolTip((IFigure)(title != null && title.length() > 0 ? new Label(title) : null));
        super.refreshVisuals();
        String stringPropertyValue = this.getModel().getStringPropertyValue("fsd_desc");
        if ("".equals(stringPropertyValue) || stringPropertyValue == null) {
            this.getFigure().setToolTip(null);
        } else {
            this.getFigure().setToolTip((IFigure)new Label(stringPropertyValue));
        }
    }

    public Button getModel() {
        return (Button)super.getModel();
    }

    public ButtonFigure getFigure() {
        return (ButtonFigure)super.getFigure();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ComponentDirectEditPolicy());
    }

    public int getResizeDirection() {
        return 29;
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType()) && req instanceof LocationRequest) {
            if (MetaPlugin.isDemonstrate) {
                new Demonstrating(this).demonstrating(this.getViewer().getControl().getShell());
                return;
            }
            this.performEditStyledStringText("text");
        }
        if (req.getType().equals("direct edit") && req instanceof DirectEditRequest) {
            ButtonFigure figure = this.getFigure();
            Rectangle bounds = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)bounds);
            this.performPromptDirectEditRequest(figure);
        } else {
            super.performRequest(req);
        }
    }

    protected void performEditStyledStringText(String propertyID) {
        TextEditDialog ted = new TextEditDialog(this.getViewer().getControl().getShell());
        StyledStringText sst = new StyledStringText();
        Object obj = this.getModel().getPropertyValue(String.valueOf(propertyID) + "_text_style");
        if (obj instanceof StyledStringText) {
            sst = (StyledStringText)obj;
        }
        sst.setText(this.getModel().getStringPropertyValue(propertyID));
        ted.setStyledStringText(sst);
        if (ted.open() == 0) {
            sst = ted.getStyledStringText();
            ChangeTextStyleCommand command = new ChangeTextStyleCommand((AuroraComponent)this.getModel(), propertyID, sst.getText(), sst);
            this.getViewer().getEditDomain().getCommandStack().execute((Command)command);
        }
    }

    protected void performPromptDirectEditRequest(final ButtonFigure figure) {
        NodeDirectEditManager manager = new NodeDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, new CellEditorLocator(){

            public void relocate(CellEditor celleditor) {
                Text text = (Text)celleditor.getControl();
                Rectangle bounds = figure.getBounds().getCopy();
                figure.translateToAbsolute((Translatable)bounds);
                text.setBounds(bounds.x - 1, bounds.y - 1, bounds.width + 1, bounds.height + 1);
            }
        }, "text");
        manager.show();
    }
}

