/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.parts;

import aurora.ide.meta.gef.editors.figures.BoxFigure;
import aurora.ide.meta.gef.editors.layout.RowColSpanBackLayout;
import aurora.ide.meta.gef.editors.parts.ContainerPart;
import aurora.plugin.source.gen.screen.model.BOX;
import aurora.plugin.source.gen.screen.model.Rectangle;
import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.AbstractLabeledBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;

public class BoxPart
extends ContainerPart {
    private static final Insets BOX_PADDING = new Insets(8, 16, 8, 6);

    protected IFigure createFigure() {
        BoxFigure figure = new BoxFigure();
        BOX model = (BOX)this.getModel();
        figure.setBox(model);
        return figure;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
    }

    protected void refreshVisuals() {
        BOX model = (BOX)this.getModel();
        BoxFigure figure = (BoxFigure)this.getFigure();
        Border border = figure.getBorder();
        if (border instanceof AbstractLabeledBorder) {
            ((AbstractLabeledBorder)border).setLabel(model.getTitle());
        }
        super.refreshVisuals();
        String stringPropertyValue = this.getComponent().getStringPropertyValue("fsd_desc");
        if ("".equals(stringPropertyValue) || stringPropertyValue == null) {
            this.getFigure().setToolTip(null);
        } else {
            this.getFigure().setToolTip((IFigure)new Label(stringPropertyValue));
        }
    }

    public void applyToModel() {
        super.applyToModel();
        org.eclipse.draw2d.geometry.Rectangle bounds = this.getFigure().getBounds();
        this.getComponent().applyToModel(new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String prop = evt.getPropertyName();
        if ("row".equals(prop) || "column".equals(prop)) {
            this.getFigure().revalidate();
        }
    }

    public int getResizeDirection() {
        return 29;
    }

    public boolean isLayoutHorizontal() {
        BOX model = (BOX)this.getModel();
        int col = model.getCol();
        return col > 1;
    }

    public org.eclipse.draw2d.geometry.Rectangle layout() {
        RowColSpanBackLayout rowColBackLayout = new RowColSpanBackLayout();
        rowColBackLayout.setPadding(BOX_PADDING);
        return rowColBackLayout.layout(this);
    }
}

