/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models.commands;

import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.ide.meta.gef.editors.parts.ContainerPart;
import aurora.ide.meta.gef.editors.parts.GridColumnPart;
import aurora.ide.meta.gef.editors.request.PasteComponentRequest;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Container;
import aurora.plugin.source.gen.screen.model.ScreenBody;
import aurora.plugin.source.gen.screen.model.io.CompositeMap2Object;
import aurora.plugin.source.gen.screen.model.io.Object2CompositeMap;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import uncertain.composite.CompositeMap;

public class PasteComponentCommand
extends Command {
    private PasteComponentRequest req;
    private Container target;
    private List<AuroraComponent> pasteComponents;

    public PasteComponentCommand(PasteComponentRequest req, Container target) {
        this.req = req;
        this.target = target;
        this.setLabel("Paste Components");
    }

    public boolean canExecute() {
        List<AuroraComponent> pasteParts = this.req.getPasteAuroraComponent();
        for (AuroraComponent ac : pasteParts) {
            if (!this.target.isResponsibleChild(ac)) {
                return false;
            }
            if (!(ac instanceof ScreenBody)) continue;
            return false;
        }
        return pasteParts.size() > 0;
    }

    public void execute() {
        this.pasteComponents = new ArrayList<AuroraComponent>();
        List<AuroraComponent> pasteAuroraComponent = this.req.getPasteAuroraComponent();
        ComponentPart selectionComponentPart = this.req.getSelectionComponentPart();
        int insertIDX = -1;
        if (selectionComponentPart instanceof GridColumnPart || !(selectionComponentPart instanceof ContainerPart)) {
            AuroraComponent component = selectionComponentPart.getComponent();
            Container parent = component.getParent();
            insertIDX = parent.getChildren().indexOf(component);
        }
        for (AuroraComponent c : pasteAuroraComponent) {
            AuroraComponent cloneObject = this.cloneObject(c);
            this.pasteComponents.add(cloneObject);
            if (insertIDX == -1) {
                this.target.addChild(cloneObject);
                continue;
            }
            this.target.addChild(cloneObject, ++insertIDX);
        }
    }

    private AuroraComponent cloneObject(AuroraComponent ac) {
        Object2CompositeMap o2c = new Object2CompositeMap();
        CompositeMap map = o2c.createCompositeMap(ac);
        CompositeMap2Object c2o = new CompositeMap2Object();
        AuroraComponent createObject = c2o.createObject(map);
        return createObject;
    }

    public void redo() {
        super.redo();
    }

    public void undo() {
        if (this.pasteComponents != null) {
            for (AuroraComponent ac : this.pasteComponents) {
                this.target.removeChild(ac);
            }
        }
    }
}

