/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models.commands;

import aurora.ide.meta.gef.util.BoundsConvert;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.TabBody;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;

public class MoveComponentCommand
extends Command {
    private AuroraComponent node;
    private Point oldPos;
    private Point newPos;

    public void setLocation(Point p) {
        this.newPos = p;
    }

    public void setNode(AuroraComponent node) {
        this.node = node;
    }

    public void execute() {
        this.oldPos = BoundsConvert.toDraw2d(this.node.getLocation());
        this.node.setLocation(BoundsConvert.toAurora(this.newPos));
    }

    public String getLabel() {
        return "Move Component";
    }

    public void redo() {
        this.node.setLocation(BoundsConvert.toAurora(this.newPos));
    }

    public void undo() {
        this.node.setLocation(BoundsConvert.toAurora(this.oldPos));
    }

    public boolean canExecute() {
        return super.canExecute() && !this.node.getClass().equals(TabBody.class);
    }

    public boolean canUndo() {
        return super.canUndo() && !this.node.getClass().equals(TabBody.class);
    }
}

