/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.layout;

import aurora.ide.meta.gef.editors.layout.BackLayout;
import aurora.ide.meta.gef.editors.layout.GraphLayoutManager;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.plugin.source.gen.screen.model.RowCol;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class RowColSpanBackLayout
extends BackLayout {
    private Insets padding = new Insets(0, 0, 0, 0);
    protected Rectangle zero = new Rectangle(0, 0, 0, 0);
    protected Rectangle selfRectangle = new Rectangle();
    protected Point location = new Point();
    protected RowCol rowCol;
    protected int col;
    protected int row;
    protected int titleHight;
    protected ComponentPart host;
    protected int t_col = 0;
    protected int t_row = 0;
    protected int[] maxColWidths;
    protected int[] maxRowHights;
    protected int realRow;
    protected Map<ComponentPart, Rectangle> partMap;
    protected Map<Integer, Row> rowcol = new HashMap<Integer, Row>();

    protected void init(ComponentPart parent) {
        if (parent.getComponent() instanceof RowCol) {
            this.host = parent;
            this.rowCol = (RowCol)parent.getComponent();
            this.col = this.rowCol.getCol();
            if (this.col == 0) {
                return;
            }
            this.row = this.rowCol.getRow();
            Rectangle fBounds = parent.getFigure().getBounds();
            this.selfRectangle = fBounds.isEmpty() ? this.toDraw2d(this.rowCol.getBoundsCopy()) : fBounds;
            this.titleHight = this.rowCol.getHeadHight();
            this.location.x += this.getPadding().left;
            this.location.y = this.location.y + this.titleHight + this.getPadding().top;
            this.location.translate(this.selfRectangle.getTopLeft());
            this.t_col = 0;
            this.t_row = 0;
            this.maxColWidths = new int[this.col];
            int i = 0;
            while (i < this.col) {
                this.maxColWidths[i] = this.rowCol.getMinColWidth();
                ++i;
            }
            this.partMap = new HashMap<ComponentPart, Rectangle>();
            List children = this.getChildren();
            int i2 = 0;
            while (i2 < children.size()) {
                ComponentPart ep = (ComponentPart)children.get(i2);
                this.nextRow();
                this.fillRowCol(ep, this.t_row, this.t_col);
                Rectangle layout = GraphLayoutManager.layout(ep);
                this.partMap.put(ep, layout);
                int cs = ep.getComponent().getColspan();
                this.t_col = this.getRow(this.t_row).nowCol();
                ++i2;
            }
            this.realRow = this.rowcol.size();
            if (this.realRow == 0) {
                return;
            }
            this.maxRowHights = new int[this.realRow];
            i2 = 0;
            while (i2 < this.realRow) {
                this.maxRowHights[i2] = this.rowCol.getMinRowHeight();
                ++i2;
            }
        }
    }

    private void nextRow() {
        if (this.t_col >= this.col) {
            ++this.t_row;
            this.t_col = this.getRow(this.t_row).nowCol();
            this.nextRow();
        }
    }

    private Row getRow(int i) {
        Row r = this.rowcol.get(i);
        if (r == null) {
            r = new Row();
            r.l = i;
            r.nodes = new Node[this.col];
            this.rowcol.put(i, r);
        }
        return r;
    }

    private void fillRowCol(ComponentPart ep, int _row, int _col) {
        int cs = ep.getComponent().getColspan();
        int rs = ep.getComponent().getRowspan();
        Node n = new Node(ep, _row, _col);
        int k = _row;
        while (k < _row + rs) {
            this.fillCol(n, k, _col, cs);
            ++k;
        }
    }

    private void fillCol(Node n, int _row, int _col, int colspan) {
        Row r = this.getRow(_row);
        int j = _col;
        while (j < _col + colspan && j < this.col) {
            r.add(n, j);
            ++j;
        }
    }

    public Rectangle layout(ComponentPart parent) {
        this.init(parent);
        if (this.getRealRow() == 0 || this.col == 0) {
            return this.calculateRectangle(parent);
        }
        this.calculateMaxWidthHight();
        this.calculateChildLocation();
        this.applyToChildren();
        Rectangle calculateRectangle = this.calculateRectangle(parent);
        return calculateRectangle;
    }

    protected void applyToChildren() {
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            ComponentPart ep = (ComponentPart)children.get(i);
            Rectangle layout = this.partMap.get(ep);
            this.applyToFigure(ep, layout);
            ++i;
        }
    }

    public List getChildren() {
        return this.getHost().getChildren();
    }

    private int getRowNodeHight(Node n, int row) {
        if (n == null) {
            return this.rowCol.getMinRowHeight();
        }
        int h = this.rowCol.getMinRowHeight();
        if (row == n.row + n.rowspan - 1) {
            Rectangle rr = this.partMap.get(n.part);
            int mmh = 0;
            int i = n.row;
            while (i < row) {
                mmh += this.maxRowHights[i] + this.getPadding().top;
                ++i;
            }
            h = rr.height - mmh;
        }
        return h;
    }

    private int getColNodeWidth(Node n, int col) {
        if (n == null) {
            return this.rowCol.getMinColWidth();
        }
        int w = this.rowCol.getMinColWidth();
        if (col == n.col + n.colspan - 1) {
            Rectangle rr = this.partMap.get(n.part);
            int mmw = 0;
            int i = n.col;
            while (i < col) {
                mmw += this.maxColWidths[i] + this.getPadding().left;
                ++i;
            }
            w = rr.width - mmw;
        }
        return w;
    }

    protected void calculateMaxWidthHight() {
        Node n;
        int i = 0;
        while (i < this.realRow) {
            Row r = this.rowcol.get(i);
            int k = 0;
            while (k < r.nodes.length) {
                n = r.nodes[k];
                this.maxRowHights[i] = Math.max(this.maxRowHights[i], this.getRowNodeHight(n, i));
                ++k;
            }
            ++i;
        }
        int j = 0;
        while (j < this.col) {
            int k = 0;
            while (k < this.realRow) {
                Row r = this.rowcol.get(k);
                if (r.nodes.length <= j) break;
                n = r.nodes[j];
                this.maxColWidths[j] = Math.max(this.maxColWidths[j], this.getColNodeWidth(n, j));
                ++k;
            }
            ++j;
        }
    }

    protected void calculateChildLocation() {
        int i = 0;
        while (i < this.realRow) {
            int j = 0;
            while (j < this.col) {
                Row r = this.rowcol.get(i);
                if (r.nodes.length <= j) break;
                Node n = r.nodes[j];
                if (n != null) {
                    ComponentPart rp = n.part;
                    if (rp == null) {
                        return;
                    }
                    if (n.row == i && n.col == j) {
                        Rectangle rr = this.partMap.get(rp);
                        rr.setLocation(this.location);
                    }
                    this.location.x += this.maxColWidths[j] + this.getPadding().left;
                }
                ++j;
            }
            this.location.x = this.getPadding().left + this.selfRectangle.getTopLeft().x;
            this.location.y = this.location.y + this.maxRowHights[i] + this.getPadding().top;
            ++i;
        }
    }

    protected Rectangle calculateRectangle(ComponentPart parent) {
        Rectangle selfRectangle = this.zero.getCopy().setLocation(parent.getFigure().getBounds().getLocation());
        List children = parent.getChildren();
        Rectangle modelRectangle = this.toDraw2d(parent.getComponent().getBoundsCopy());
        if (children.size() == 0 || selfRectangle.equals((Object)this.zero)) {
            return modelRectangle;
        }
        int i = 0;
        while (i < children.size()) {
            ComponentPart cp = (ComponentPart)children.get(i);
            selfRectangle.union(this.partMap.get(cp).getCopy());
            ++i;
        }
        Rectangle expand = selfRectangle.expand(5, 5);
        return new Rectangle(expand.x, expand.y, Math.max(expand.width, modelRectangle.width), Math.max(expand.height, modelRectangle.height));
    }

    private Rectangle calculateFormRectangle(ComponentPart parent) {
        Rectangle selfRectangle = this.zero.getCopy().setLocation(parent.getFigure().getBounds().getLocation());
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            ComponentPart cp = (ComponentPart)children.get(i);
            selfRectangle.union(cp.getFigure().getBounds().getCopy());
            ++i;
        }
        if (selfRectangle.width > this.rowCol.getBoundsCopy().width) {
            return selfRectangle.expand(5, 5);
        }
        int nw = Math.max(selfRectangle.width, this.rowCol.getBoundsCopy().width);
        int nh = Math.max(selfRectangle.height, this.rowCol.getBoundsCopy().height);
        return this.selfRectangle.getCopy().setSize(nw, nh).expand(0, 5);
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        this.padding = padding;
    }

    public ComponentPart getHost() {
        return this.host;
    }

    public void setHost(ComponentPart host) {
        this.host = host;
    }

    protected int getRealRow() {
        return this.realRow;
    }

    protected Rectangle getSelfRectangle() {
        return this.selfRectangle;
    }

    private class Node {
        int row;
        int col;
        ComponentPart part;
        int rowspan;
        int colspan;

        Node(ComponentPart part, int row, int col) {
            this.part = part;
            this.row = row;
            this.col = col;
            this.rowspan = part.getComponent().getRowspan();
            this.colspan = part.getComponent().getColspan();
        }
    }

    private class Row {
        int l;
        Node[] nodes;

        private Row() {
        }

        void add(Node n, int i) {
            this.nodes[i] = n;
        }

        public int nowCol() {
            int size = this.nodes.length;
            int i = 0;
            while (i < size) {
                Node node = this.nodes[i];
                if (node == null) {
                    return i;
                }
                ++i;
            }
            return size;
        }
    }
}

