/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.layout;

import aurora.ide.meta.gef.editors.parts.DatasetDiagramPart;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class DatasetLayout
extends AbstractLayout {
    private static final Insets PADDING = new Insets(5, 5, 0, 2);
    private Point lastLocation = new Point();
    private DatasetDiagramPart dsDiagram;

    public DatasetLayout(DatasetDiagramPart datasetDiagramPart) {
        this.dsDiagram = datasetDiagramPart;
    }

    public void layout(IFigure container) {
        int line = 1;
        this.lastLocation = this.newLine(0, line);
        boolean reLayout = true;
        List children = container.getChildren();
        for (IFigure f : children) {
            this.lastLocation.translate(DatasetLayout.PADDING.left, 0);
            Dimension size = f.getPreferredSize();
            if (this.lastLocation.x + size.width >= container.getSize().width) {
                this.lastLocation = this.newLine(f.getSize().height + this.lastLocation.y, line);
                ++line;
                this.lastLocation.translate(DatasetLayout.PADDING.left, 0);
            }
            f.setLocation(this.lastLocation);
            this.lastLocation.translate(size.width, 0);
        }
        if (reLayout) {
            Composite parent = this.dsDiagram.getViewer().getControl().getParent();
            GridData layoutData = new GridData(768);
            layoutData.heightHint = line * 25;
            parent.setLayoutData((Object)layoutData);
            parent.getParent().layout();
        }
    }

    private Point newLine(int y, int line) {
        return new Point().translate(0, y + DatasetLayout.PADDING.top);
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        container.validate();
        List children = container.getChildren();
        Rectangle result = new Rectangle().setLocation(container.getClientArea().getLocation());
        int i = 0;
        while (i < children.size()) {
            result.union(((IFigure)children.get(i)).getBounds());
            ++i;
        }
        result.resize(container.getInsets().getWidth(), container.getInsets().getHeight());
        return result.getSize();
    }
}

