/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.figures;

import aurora.ide.meta.gef.editors.PrototypeImagesUtils;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import aurora.ide.meta.gef.editors.figures.IResourceDispose;
import aurora.ide.meta.gef.editors.figures.ResourceDisposer;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TitleBarBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;

public class TitleBorder
extends TitleBarBorder
implements IResourceDispose {
    private String imageKey = "toolbar_bg";
    private ResourceDisposer disposer = new ResourceDisposer();

    public TitleBorder(String string) {
        super(string);
    }

    public TitleBorder(String title, String imageKey) {
        super(title);
        this.imageKey = imageKey;
    }

    public void paint(IFigure figure, Graphics g, Insets insets) {
        g.pushState();
        tempRect.setBounds(TitleBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        this.paintEtchedBorder(g, tempRect);
        Rectangle rec = tempRect;
        rec.height = 25;
        g.clipRect(rec);
        g.fillRectangle(rec);
        Image i = this.getBGImage();
        Rectangle src = new Rectangle(i.getBounds().x, i.getBounds().y, i.getBounds().width, 25);
        g.drawImage(i, src, rec);
        int x = rec.x + 5;
        int y = rec.getCenter().y;
        g.setFont(this.getFont(figure));
        g.setForegroundColor(this.getTextColor());
        g.drawString(this.getLabel(), x, y -= this.getTextExtents((IFigure)figure).height / 2);
        this.paintEtchedBorder(g, tempRect);
        g.popState();
    }

    private Image getBGImage() {
        return PrototypeImagesUtils.getImage(this.imageKey);
    }

    public Color getTextColor() {
        return ColorConstants.TITLETEXT;
    }

    private void paintEtchedBorder(Graphics g, Rectangle r) {
        this.disposeResource("shadow");
        this.disposeResource("highlight");
        Color rgb = g.getBackgroundColor();
        Color shadow = FigureUtilities.darker((Color)rgb);
        Color highlight = FigureUtilities.lighter((Color)rgb);
        this.handleResource("shadow", (Resource)shadow);
        this.handleResource("highlight", (Resource)highlight);
        FigureUtilities.paintEtchedBorder((Graphics)g, (Rectangle)r, (Color)shadow, (Color)highlight);
    }

    public void disposeResource() {
        this.disposer.disposeResource();
        this.disposer = null;
    }

    protected void handleResource(String id, Resource r) {
        this.disposer.handleResource(id, r);
    }

    protected void disposeResource(String prop_id) {
        this.disposer.disposeResource(prop_id);
    }
}

