/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.figures;

import aurora.ide.meta.gef.editors.PrototypeImagesUtils;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import aurora.ide.meta.gef.editors.figures.InputField;
import aurora.ide.meta.gef.util.TextStyleUtil;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Input;
import aurora.plugin.source.gen.screen.model.RadioItem;
import aurora.plugin.source.gen.screen.model.StyledStringText;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class RadioItemFigure
extends InputField {
    private static final Image img_unchecked = PrototypeImagesUtils.getImage("palette/radio_01.png");
    private RadioItem model;

    public void setModel(RadioItem model) {
        super.setModel((Input)model);
        this.model = model;
    }

    public int getLabelWidth() {
        return 0;
    }

    protected void paintFigure(Graphics g) {
        Rectangle bounds = this.getBounds();
        Image img = img_unchecked;
        if (img != null) {
            Point imgPos = new Point();
            imgPos.x = bounds.getTopLeft().x + 2;
            imgPos.y = bounds.y + (bounds.height - img.getBounds().height) / 2;
            g.drawImage(img, imgPos);
        }
        Rectangle inputRectangle = this.getInputRectangle();
        Rectangle translated = inputRectangle.getTranslated(18, 0).setWidth(inputRectangle.width - 20);
        Rectangle textRectangle = this.getTextRectangle("text", translated);
        String text = this.model.getText();
        if (text != null) {
            if (!TextStyleUtil.isTextLayoutUseless((AuroraComponent)this.model, "text")) {
                this.paintStyledText(g, text, "text", textRectangle.getTopLeft());
            } else {
                g.setForegroundColor(ColorConstants.BLACK);
                g.drawText(text, textRectangle.getTopLeft());
            }
        }
    }

    protected void paintStyledText(Graphics g, String text, String property_id, Point p) {
        g.pushState();
        this.disposeResource(property_id);
        g.setForegroundColor(ColorConstants.BLACK);
        TextLayout tl = new TextLayout(null);
        tl.setText(text);
        tl.setFont(this.getFont());
        Object obj = this.model.getPropertyValue(String.valueOf(property_id) + "_text_style");
        TextStyle ts = null;
        ts = obj instanceof StyledStringText ? TextStyleUtil.createTextStyle((StyledStringText)obj, Display.getDefault(), this.getFont()) : new TextStyle();
        tl.setStyle(ts, 0, text.length() - 1);
        g.drawTextLayout(tl, p.x, p.y);
        this.handleResource(property_id, (Resource)tl);
        g.popState();
    }
}

