/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.figures;

import aurora.ide.meta.gef.editors.PrototypeImagesUtils;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import aurora.ide.meta.gef.editors.figures.GridColumnFigure;
import aurora.plugin.source.gen.screen.model.GridSelectionCol;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class GridSelectionColFigure
extends GridColumnFigure {
    private static final Image img_check = PrototypeImagesUtils.getImage("palette/checkbox_01.png");
    private static final Image img_radio = PrototypeImagesUtils.getImage("palette/radio_01.png");
    private static final Image img_border = PrototypeImagesUtils.getImage("grid_bg.gif");
    private GridSelectionCol model;

    public GridSelectionColFigure() {
        this.setLayoutManager(null);
        this.setBorder(null);
        this.setFocusTraversable(false);
    }

    public void handleFocusGained(FocusEvent event) {
        super.handleFocusGained(event);
    }

    protected void paintFigure(Graphics g) {
        if ("".equals(this.model.getSelectionMode())) {
            return;
        }
        Rectangle rect = this.getBounds().getCopy();
        g.setBackgroundColor(ColorConstants.GRID_ROW);
        g.fillRectangle(rect);
        int ch = this.getColumnHight();
        Rectangle columnHeaderRect = new Rectangle(rect.x, rect.y, 25, ch);
        org.eclipse.swt.graphics.Rectangle imgBounds = img_border.getBounds();
        Rectangle imgRect = new Rectangle(imgBounds);
        imgRect.setHeight(Math.min(ch, imgRect.height));
        columnHeaderRect.height = Math.min(columnHeaderRect.height, imgRect.height);
        g.drawImage(img_border, imgRect, columnHeaderRect);
        Image img = img_radio;
        imgRect = new Rectangle(img.getBounds());
        if ("multiple".equals(this.model.getSelectionMode())) {
            img = img_check;
            imgRect = new Rectangle(img.getBounds());
            g.drawImage(img, rect.x + (rect.width - imgRect.width) / 2, rect.y + (ch - imgRect.height) / 2);
        }
        g.setForegroundColor(ColorConstants.GRID_COLUMN_GRAY);
        g.drawLine(rect.x, rect.y + ch - 1, rect.x + rect.width, rect.y + ch - 1);
        int i = rect.y + ch;
        while (i < rect.y + rect.height) {
            Rectangle rc = new Rectangle(rect.x, i, rect.width, 25);
            if (i > rect.y + ch) {
                g.drawLine(rc.getTopLeft(), rc.getTopRight());
            }
            g.drawImage(img, imgRect, rc.getShrinked((rc.width - imgRect.width) / 2, (rc.height - imgRect.height) / 2));
            i += 25;
        }
        g.drawLine(rect.getTopRight().getTranslated(-1, 0), rect.getBottomRight().getTranslated(-1, 0));
    }

    public void setModel(GridSelectionCol component) {
        this.model = component;
    }
}

