/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.figures;

import aurora.ide.meta.gef.editors.PrototypeImagesUtils;
import aurora.ide.meta.gef.editors.consultant.property.ConsultantPropertyFactory;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import aurora.ide.meta.gef.editors.figures.DummyLayout;
import aurora.ide.meta.gef.editors.figures.FigureUtil;
import aurora.ide.meta.gef.editors.figures.GridColumnBorder;
import aurora.ide.meta.gef.editors.figures.IResourceDispose;
import aurora.ide.meta.gef.editors.figures.ResourceDisposer;
import aurora.ide.meta.gef.util.TextStyleUtil;
import aurora.plugin.source.gen.screen.model.GridColumn;
import aurora.plugin.source.gen.screen.model.Renderer;
import aurora.plugin.source.gen.screen.model.StyledStringText;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class GridColumnFigure
extends Figure
implements IResourceDispose {
    public static final int ROW_HEIGHT = 25;
    private static Image checkImg = PrototypeImagesUtils.getImage("palette/checkbox_01.png");
    private int labelWidth;
    private int columnHight = 25;
    private GridColumn gridColumn;
    private ResourceDisposer disposer = new ResourceDisposer();

    public GridColumnFigure() {
        this.setLayoutManager((LayoutManager)new DummyLayout());
        this.setBorder((Border)new GridColumnBorder("prompt", "grid_bg", this));
    }

    public int getLabelWidth() {
        return this.labelWidth;
    }

    public void setLabelWidth(int labelWidth) {
        this.labelWidth = labelWidth;
    }

    public void handleFocusGained(FocusEvent event) {
        super.handleFocusGained(event);
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle copy = this.getBounds().getCopy();
        Rectangle firstCellRect = copy.getTranslated(0, this.columnHight).setHeight(this.gridColumn.getRowHight());
        if (this.getChildren().size() > 0) {
            return;
        }
        int k = 1;
        int i = copy.y + this.columnHight;
        while (i < copy.y + copy.height) {
            if (k % 2 == 0) {
                graphics.setBackgroundColor(ColorConstants.GRID_ROW);
                graphics.fillRectangle(copy.x, i, copy.width, 25);
            }
            graphics.setForegroundColor(ColorConstants.GRID_COLUMN_GRAY);
            graphics.drawLine(copy.x, i, copy.x + copy.width, i);
            ++k;
            i += 25;
        }
        String editor = this.gridColumn.getEditor();
        if (editor == null || editor.length() == 0) {
            this.paintEffectForRenderer(graphics, this.gridColumn.getRenderer(), firstCellRect);
        } else if ("checkBox".equals(editor)) {
            FigureUtil.paintImageAtCenter(graphics, firstCellRect, checkImg);
        } else {
            graphics.setBackgroundColor(ColorConstants.WHITE);
            if (this.gridColumn.getDatasetField().isRequired()) {
                graphics.setBackgroundColor(ColorConstants.REQUIRED_BG);
            }
            if (this.gridColumn.getDatasetField().isReadOnly()) {
                graphics.setBackgroundColor(ColorConstants.READONLY_BG);
            }
            Rectangle rect = firstCellRect.getShrinked(2, 2).translate(-1, 0);
            graphics.fillRectangle(rect);
            graphics.setForegroundColor(ColorConstants.GRID_COLUMN_GRAY);
            graphics.drawRectangle(rect);
            Image img = this.getImageOfEditor(editor);
            if (img != null) {
                rect.x += rect.width - rect.height;
                rect.width = rect.height;
                FigureUtil.paintImageAtCenter(graphics, rect, img);
            }
        }
        this.paintSimpleDatas(graphics);
    }

    private void paintSimpleDatas(Graphics graphics) {
        Rectangle copy = this.getBounds().getCopy();
        int k = 1;
        int i = copy.y + this.columnHight;
        while (i < copy.y + copy.height - this.columnHight) {
            String propId = "grid_column_simple_data_" + k;
            String sd = this.gridColumn.getStringPropertyValue(propId);
            Object obj = this.gridColumn.getPropertyValue(String.valueOf(propId) + "_text_style");
            if (obj instanceof StyledStringText && !((StyledStringText)obj).isUseless()) {
                this.paintStyledText(graphics, sd, propId, new Rectangle(copy.x + 2, i, copy.width - 6, 25));
            } else {
                this.paintSimpleData(graphics, sd, new Rectangle(copy.x + 2, i, copy.width - 6, 25));
            }
            ++k;
            i += 25;
        }
    }

    protected void paintStyledText(Graphics g, String text, String property_id, Rectangle r) {
        g.pushState();
        this.disposeResource(property_id);
        Rectangle copy = r.getCopy();
        g.setForegroundColor(ColorConstants.BLACK);
        Dimension dim = FigureUtilities.getTextExtents((String)text, (Font)this.getFont());
        TextLayout tl = new TextLayout(null);
        tl.setText(text);
        tl.setFont(this.getFont());
        Object obj = this.gridColumn.getPropertyValue(String.valueOf(property_id) + "_text_style");
        TextStyle ts = null;
        ts = obj instanceof StyledStringText ? TextStyleUtil.createTextStyle((StyledStringText)obj, Display.getDefault(), this.getFont()) : new TextStyle();
        tl.setStyle(ts, 0, text.length() - 1);
        Point point = TextStyleUtil.getTextAlignment(r, text, this.getFont(), this.getAlignmentStyle(property_id));
        if ("prompt".equals(property_id)) {
            g.drawTextLayout(tl, copy.x, copy.y);
        } else {
            g.drawTextLayout(tl, point.x, point.y);
        }
        this.handleResource(property_id, (Resource)tl);
        g.popState();
    }

    private int getAlignmentStyle(String property_id) {
        String align = this.gridColumn.getStringPropertyValue("grid_column_alignment");
        if (ConsultantPropertyFactory.aligns[0].equals(align)) {
            return 16384;
        }
        if (ConsultantPropertyFactory.aligns[1].equals(align)) {
            return 0x1000000;
        }
        if (ConsultantPropertyFactory.aligns[2].equals(align)) {
            return 131072;
        }
        return 16384;
    }

    protected void paintSimpleData(Graphics g, String text, Rectangle r) {
        if (text == null || "".equals(text)) {
            return;
        }
        g.pushState();
        g.setForegroundColor(ColorConstants.BLACK);
        Dimension dim = FigureUtilities.getTextExtents((String)text, (Font)this.getFont());
        Point point = TextStyleUtil.getTextAlignment(r, text, this.getFont(), this.getAlignmentStyle(""));
        g.drawText(text, point);
        g.popState();
    }

    private Image getImageOfEditor(String editor) {
        if ("comboBox".equals(editor)) {
            return PrototypeImagesUtils.getImage("palette/itembar_01.png");
        }
        if ("datePicker".equals(editor) || "dateTimePicker".equals(editor)) {
            return PrototypeImagesUtils.getImage("palette/itembar_02.png");
        }
        if ("lov".equals(editor)) {
            return PrototypeImagesUtils.getImage("palette/itembar_03.png");
        }
        if ("textField".equals(editor)) {
            return PrototypeImagesUtils.getImage("palette/itembar_04.png");
        }
        if ("numberField".equals(editor)) {
            return PrototypeImagesUtils.getImage("palette/itembar_05.png");
        }
        return null;
    }

    private void paintEffectForRenderer(Graphics g, Renderer renderer, Rectangle rect) {
        if (renderer == null) {
            return;
        }
        String rendererType = renderer.getRendererType();
        if ("PAGE_REDIRECT".equals(rendererType)) {
            boolean u;
            String text = renderer.getDescripition();
            g.setForegroundColor(ColorConstants.LINK_COLOR);
            String lt = text.toLowerCase();
            int idx1 = lt.indexOf("<u>");
            int idx2 = lt.indexOf("</u>");
            boolean bl = u = idx1 + idx2 > 0;
            if (u) {
                text = text.substring(idx1 + 3, idx2);
            }
            FigureUtil.paintTextAtCenter(g, rect, text, u);
        } else if ("USER_FUNCTION".equals(rendererType)) {
            Image fxImg = PrototypeImagesUtils.getImage("palette/fx.png");
            FigureUtil.paintImageAtCenter(g, rect, fxImg);
        }
    }

    public void setModel(GridColumn component) {
        this.gridColumn = component;
    }

    public String getPrompt() {
        return this.gridColumn.getPrompt();
    }

    public int getColumnHight() {
        return this.columnHight;
    }

    public void setColumnHight(int columnHight) {
        this.columnHight = columnHight;
        if (this.gridColumn != null) {
            this.gridColumn.setHeadHight(columnHight);
        }
    }

    public GridColumn getModel() {
        return this.gridColumn;
    }

    private void handleResource(String id, Resource r) {
        this.disposer.handleResource(id, r);
    }

    private void disposeResource(String prop_id) {
        this.disposer.disposeResource(prop_id);
    }

    public void disposeResource() {
        Border border = this.getBorder();
        if (border instanceof IResourceDispose) {
            ((IResourceDispose)border).disposeResource();
        }
        this.disposer.disposeResource();
        this.disposer = null;
    }
}

