/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.figures;

import aurora.ide.meta.gef.editors.PrototypeImagesUtils;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import aurora.ide.meta.gef.editors.figures.GridColumnFigure;
import aurora.ide.meta.gef.editors.figures.IResourceDispose;
import aurora.ide.meta.gef.editors.figures.ResourceDisposer;
import aurora.ide.meta.gef.util.TextStyleUtil;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.StyledStringText;
import org.eclipse.draw2d.AbstractLabeledBorder;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class GridColumnBorder
extends AbstractLabeledBorder
implements IResourceDispose {
    private String imageKey;
    private GridColumnFigure figure;
    private ResourceDisposer disposer = new ResourceDisposer();

    public GridColumnBorder(String title, String imageKey, GridColumnFigure figure) {
        super(title);
        this.imageKey = imageKey;
        this.figure = figure;
    }

    private Image getImage(String key) {
        return PrototypeImagesUtils.getImage(key);
    }

    public Color getTextColor() {
        return ColorConstants.TITLETEXT;
    }

    public GridColumnBorder() {
    }

    public void paint(IFigure figure, Graphics g, Insets insets) {
        g.pushState();
        Rectangle rect = figure.getBounds();
        g.clipRect(rect);
        Rectangle r = rect.getTranslated(-1, -1);
        g.setForegroundColor(ColorConstants.GRID_COLUMN_GRAY);
        g.drawRectangle(r);
        Image bgimg = this.getImage(this.imageKey);
        Rectangle headRect = rect.getCopy().setHeight(this.getColumnHight());
        IFigure gf = figure;
        while (gf.getParent() instanceof GridColumnFigure) {
            gf = gf.getParent();
        }
        Rectangle src = new Rectangle(0, rect.y - gf.getBounds().y, 1, this.getColumnHight());
        Rectangle imgBounds = new Rectangle(bgimg.getBounds());
        src = imgBounds.intersect(src).setLocation(src.getLocation());
        g.drawImage(bgimg, src, headRect.getCopy().setHeight(src.height));
        if (this.figure.getModel().getBooleanPropertyValue("grid_column_sortable").booleanValue()) {
            Image sortimg = this.getImage("palette/sort_desc.gif");
            Rectangle sortImgBounds = new Rectangle(sortimg.getBounds());
            g.drawImage(sortimg, sortImgBounds, new Rectangle(headRect.getTopRight().x - 15, headRect.getCenter().y, sortImgBounds.width, sortImgBounds.height));
        }
        Dimension textExtents = FigureUtilities.getTextExtents((String)this.getPrompt(), (Font)this.getFont(figure));
        g.setFont(this.getFont(figure));
        g.setForegroundColor(this.getTextColor());
        if (!TextStyleUtil.isTextLayoutUseless((AuroraComponent)this.figure.getModel(), "prompt")) {
            this.paintStyledText(g, this.getPrompt(), "prompt", headRect.getCenter().x - textExtents.width / 2, headRect.getCenter().y - textExtents.height / 2);
        } else {
            g.drawString(this.getPrompt(), headRect.getCenter().x - textExtents.width / 2, headRect.getCenter().y - textExtents.height / 2);
        }
        g.setForegroundColor(ColorConstants.WHITE);
        g.drawRectangle(headRect);
        g.setForegroundColor(ColorConstants.GRID_COLUMN_GRAY);
        g.drawRectangle(headRect.getTranslated(-1, -1));
        g.popState();
    }

    protected void paintStyledText(Graphics g, String text, String property_id, int x, int y) {
        g.pushState();
        this.disposer.disposeResource(property_id);
        TextLayout tl = new TextLayout(null);
        tl.setText(text);
        tl.setFont(this.figure.getFont());
        Object obj = this.figure.getModel().getPropertyValue(String.valueOf(property_id) + "_text_style");
        TextStyle ts = null;
        ts = obj instanceof StyledStringText ? TextStyleUtil.createTextStyle((StyledStringText)obj, Display.getDefault(), this.figure.getFont()) : new TextStyle();
        tl.setStyle(ts, 0, text.length() - 1);
        g.drawTextLayout(tl, x, y);
        this.disposer.handleResource(property_id, (Resource)tl);
        g.popState();
    }

    protected String getPrompt() {
        String prompt = this.figure.getPrompt();
        return prompt == null ? "prompt" : prompt;
    }

    private int getColumnHight() {
        return this.figure.getColumnHight();
    }

    protected Insets calculateInsets(IFigure figure) {
        return new Insets(0, 0, 0, 0);
    }

    public void disposeResource() {
        this.disposer.disposeResource();
        this.disposer = null;
    }
}

