/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.figures;

import aurora.ide.meta.gef.editors.PrototypeImagesUtils;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import aurora.plugin.source.gen.screen.model.Dataset;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class DatasetFigure
extends Figure {
    private static Image bgImg = PrototypeImagesUtils.getImage("btn.gif");
    private static String[] buttonTypes = new String[]{"add", "save", "delete", "clear", "excel"};
    private static Image stdimg = PrototypeImagesUtils.getImage("aurora/toolbar_btn.gif");
    private static Image defaultimg = PrototypeImagesUtils.getImage("aurora/default.gif");
    private Dataset model = null;

    public DatasetFigure(Dataset model) {
        this.setModel(model);
    }

    public void handleFocusGained(FocusEvent event) {
        super.handleFocusGained(event);
    }

    protected void paintFigure(Graphics g) {
        super.paintFigure(g);
        g.pushState();
        Image bgImage = this.getBgImage();
        Dimension textExtents = FigureUtilities.getTextExtents((String)"", (Font)this.getFont());
        org.eclipse.draw2d.geometry.Rectangle rect = this.getBounds();
        String text = "";
        Rectangle b2 = bgImage.getBounds();
        org.eclipse.draw2d.geometry.Rectangle r1 = new org.eclipse.draw2d.geometry.Rectangle(b2.x, b2.y, b2.width, b2.height);
        g.setForegroundColor(ColorConstants.BLACK);
        g.drawImage(this.getBgImage(), r1.x, r1.y, r1.width, r1.height, rect.x, rect.y + 1, r1.width, r1.height);
        g.drawString(text, rect.x + r1.width, rect.y + (rect.height - textExtents.height) / 2);
        g.popState();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Image bgImage = this.getBgImage();
        Dimension iconSize = new Dimension(bgImage.getBounds().width, bgImage.getBounds().height);
        Dimension textExtents = FigureUtilities.getTextExtents((String)"", (Font)this.getFont());
        Dimension dimension = new Dimension(iconSize.width + textExtents.width, Math.max(iconSize.height, textExtents.height));
        this.setSize(dimension);
        return dimension;
    }

    private org.eclipse.draw2d.geometry.Rectangle getStdImgRect() {
        return new org.eclipse.draw2d.geometry.Rectangle(0, 17, 16, 17);
    }

    private Image getBgImage() {
        return PrototypeImagesUtils.getImage("bm.gif");
    }

    public void setModel(Dataset model) {
        this.model = model;
    }
}

