/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.figures;

import aurora.ide.meta.gef.editors.PrototypeImagesUtils;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import aurora.ide.meta.gef.editors.figures.IResourceDispose;
import aurora.ide.meta.gef.editors.figures.ResourceDisposer;
import aurora.ide.meta.gef.editors.figures.ToolbarFigure;
import aurora.ide.meta.gef.util.BoundsConvert;
import aurora.ide.meta.gef.util.MessageUtil;
import aurora.ide.meta.gef.util.TextStyleUtil;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Button;
import aurora.plugin.source.gen.screen.model.StyledStringText;
import java.util.Arrays;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class ButtonFigure
extends Figure
implements IResourceDispose {
    private static Image bgImg = PrototypeImagesUtils.getImage("btn.gif");
    private static String[] buttonTypes = new String[]{"add", "save", "delete", "clear", "excel"};
    private static Image stdimg = PrototypeImagesUtils.getImage("aurora/toolbar_btn.gif");
    private static Image defaultimg = PrototypeImagesUtils.getImage("aurora/default.gif");
    private Button model = null;
    private ResourceDisposer disposer = new ResourceDisposer();

    public void handleFocusGained(FocusEvent event) {
        super.handleFocusGained(event);
    }

    protected void paintFigure(Graphics g) {
        super.paintFigure(g);
        g.pushState();
        Rectangle rect = this.getBounds();
        Dimension dim = BoundsConvert.getSize((AuroraComponent)this.model);
        IFigure parentFigure = this.getParent();
        if (!(parentFigure instanceof ToolbarFigure)) {
            g.drawImage(bgImg, 0, 0, 3, 2, rect.x, rect.y, 3, 2);
            g.drawImage(bgImg, 0, 6, 1, 2, rect.x + 3, rect.y, dim.width - 6, 2);
            g.drawImage(bgImg, 3, 0, 3, 2, rect.x + dim.width - 3, rect.y, 3, 2);
            g.drawImage(bgImg, 0, 24, 3, 1, rect.x, rect.y + 2, 3, dim.height - 4);
            g.drawImage(bgImg, 3, 24, 3, 1, rect.x + dim.width - 3, rect.y + 2, 3, dim.height - 4);
            g.drawImage(bgImg, 0, 1096, 1, dim.height - 4, rect.x + 3, rect.y + 2, dim.width - 6, dim.height - 4);
            g.drawImage(bgImg, 0, 4, 3, 2, rect.x, rect.y + dim.height - 2, 3, 2);
            g.drawImage(bgImg, 0, 16, 1, 2, rect.x + 3, rect.y + dim.height - 2, dim.width - 3, 2);
            g.drawImage(bgImg, 3, 4, 3, 2, rect.x + dim.width - 3, rect.y + dim.height - 2, 3, 2);
        }
        String text = MessageUtil.getButtonText(this.model);
        Dimension textExtents = FigureUtilities.getTextExtents((String)text, (Font)this.getFont());
        Rectangle r1 = this.getStdImgRect();
        g.setForegroundColor(ColorConstants.BLACK);
        if (r1 == null) {
            if (!TextStyleUtil.isTextLayoutUseless((AuroraComponent)this.model, "text")) {
                this.paintStyledText(g, text, "text", rect.x + (dim.width - textExtents.width) / 2, rect.y + (dim.height - textExtents.height) / 2);
            } else {
                g.drawString(text, rect.x + (dim.width - textExtents.width) / 2, rect.y + (dim.height - textExtents.height) / 2);
            }
        } else {
            Rectangle r2 = new Rectangle(rect.x + (dim.width - textExtents.width - 16) / 2, rect.y + (dim.height - r1.height) / 2, 16, 17);
            g.drawImage(this.getBgImage(), r1, r2);
            g.drawString(text, rect.x + (dim.width - textExtents.width) / 2 + 8, rect.y + (dim.height - textExtents.height) / 2);
        }
        g.popState();
    }

    protected void paintStyledText(Graphics g, String text, String property_id, int x, int y) {
        g.pushState();
        this.disposer.disposeResource(property_id);
        TextLayout tl = new TextLayout(null);
        tl.setText(text);
        tl.setFont(this.getFont());
        Object obj = this.model.getPropertyValue(String.valueOf(property_id) + "_text_style");
        TextStyle ts = null;
        ts = obj instanceof StyledStringText ? TextStyleUtil.createTextStyle((StyledStringText)obj, Display.getDefault(), this.getFont()) : new TextStyle();
        tl.setStyle(ts, 0, text.length() - 1);
        g.drawTextLayout(tl, x, y);
        this.disposer.handleResource(property_id, (Resource)tl);
        g.popState();
    }

    private Rectangle getStdImgRect() {
        String btype = this.model.getButtonType();
        int i = 0;
        while (i < buttonTypes.length) {
            if (buttonTypes[i].equals(btype)) {
                return new Rectangle(0, 17 * i, 16, 17);
            }
            ++i;
        }
        if (this.model.getIcon() == null || this.model.getIcon().length() == 0) {
            return null;
        }
        return new Rectangle(defaultimg.getBounds());
    }

    private Image getBgImage() {
        return this.isStdButton(this.model) ? stdimg : defaultimg;
    }

    private boolean isStdButton(Button model) {
        return Arrays.asList(Button.std_types).indexOf(model.getButtonType()) > 0;
    }

    public void setModel(Button model) {
        this.model = model;
    }

    public void disposeResource() {
        this.disposer.disposeResource();
        this.disposer = null;
    }
}

