/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.actions;

import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.ide.meta.gef.editors.parts.ContainerPart;
import aurora.ide.meta.gef.editors.request.PasteComponentRequest;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasteComponentsAction
extends SelectionAction {
    private GraphicalEditor editor;

    public PasteComponentsAction(GraphicalEditor part) {
        super((IWorkbenchPart)part);
        this.editor = part;
    }

    protected boolean calculateEnabled() {
        return this.getSelectedObjects().size() == 1 && this.getClipboardContents() != null;
    }

    protected void init() {
        this.setId(ActionFactory.PASTE.getId());
        this.setText("Paste");
    }

    private List<AuroraComponent> getPasteAuroraComponent() {
        ArrayList<AuroraComponent> pasteParts = new ArrayList<AuroraComponent>();
        List clipboardContents = this.getClipboardContents();
        if (clipboardContents != null) {
            for (Object object : clipboardContents) {
                if (!(object instanceof AuroraComponent)) continue;
                pasteParts.add((AuroraComponent)object);
            }
        }
        return pasteParts;
    }

    public void run() {
        if (!this.calculateEnabled()) {
            return;
        }
        Object object = this.getSelectedObjects().get(0);
        if (object instanceof ComponentPart) {
            ComponentPart part = (ComponentPart)object;
            if (!(object instanceof ContainerPart)) {
                part = (ComponentPart)((ComponentPart)object).getParent();
            }
            PasteComponentRequest pcr = new PasteComponentRequest();
            org.eclipse.swt.graphics.Point p = this.getGraphicalControl().toControl(Display.getCurrent().getCursorLocation());
            pcr.setLocation(new Point(p.x, p.y));
            pcr.setSelectionComponentPart((ComponentPart)object);
            pcr.setPasteAuroraComponent(this.getPasteAuroraComponent());
            Command command = part.getCommand((Request)pcr);
            if (command != null && command.canExecute()) {
                this.getCommandStack().execute(command);
            }
        }
    }

    private Control getGraphicalControl() {
        GraphicalViewer viewer = (GraphicalViewer)this.editor.getAdapter(GraphicalViewer.class);
        return viewer.getControl();
    }

    protected List getClipboardContents() {
        Object contents = Clipboard.getDefault().getContents();
        if (contents instanceof List) {
            return (List)contents;
        }
        return null;
    }
}

