/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.actions;

import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.ide.meta.gef.editors.parts.ViewDiagramPart;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.io.CompositeMap2Object;
import aurora.plugin.source.gen.screen.model.io.Object2CompositeMap;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import uncertain.composite.CompositeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyComponentsAction
extends SelectionAction {
    private GraphicalEditor editor;

    public CopyComponentsAction(GraphicalEditor part) {
        super((IWorkbenchPart)part);
        this.editor = part;
    }

    protected boolean calculateEnabled() {
        return !this.getSelectedObjects().isEmpty();
    }

    protected void init() {
        this.setId(ActionFactory.COPY.getId());
        this.setText("Copy");
    }

    public void run() {
        List<ComponentPart> pasteParts = this.getPasteParts();
        ArrayList<AuroraComponent> pasteComponents = new ArrayList<AuroraComponent>();
        for (ComponentPart cp : pasteParts) {
            AuroraComponent c = cp.getComponent();
            AuroraComponent cloneObject = this.cloneObject(c);
            pasteComponents.add(cloneObject);
        }
        Clipboard.getDefault().setContents(pasteComponents);
    }

    private AuroraComponent cloneObject(AuroraComponent ac) {
        Object2CompositeMap o2c = new Object2CompositeMap();
        CompositeMap map = o2c.createCompositeMap(ac);
        CompositeMap2Object c2o = new CompositeMap2Object();
        AuroraComponent createObject = c2o.createObject(map);
        return createObject;
    }

    private List<ComponentPart> getPasteParts() {
        ArrayList<ComponentPart> pasteParts = new ArrayList<ComponentPart>();
        List clipboardContents = this.getSelectedObjects();
        for (Object object : clipboardContents) {
            ComponentPart part;
            if (!(object instanceof ComponentPart) || (part = (ComponentPart)object) instanceof ViewDiagramPart || this.isOverlap(part)) continue;
            pasteParts.add(part);
        }
        return pasteParts;
    }

    private boolean isOverlap(ComponentPart part) {
        EditPart parent = part.getParent();
        if (parent instanceof ViewDiagramPart) {
            return false;
        }
        List clipboardContents = this.getSelectedObjects();
        if (clipboardContents.contains(parent)) {
            return true;
        }
        if (!(parent instanceof ComponentPart)) {
            return false;
        }
        return this.isOverlap((ComponentPart)parent);
    }
}

