/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors;

import aurora.ide.bm.BMUtil;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.gef.Util;
import aurora.ide.meta.gef.designer.BMCompositeMap;
import aurora.ide.meta.gef.editors.PrototypeImagesUtils;
import aurora.ide.meta.gef.editors.VScreenEditor;
import aurora.ide.meta.gef.editors.dnd.BMTransfer;
import aurora.ide.meta.gef.editors.property.ResourceSelector;
import aurora.ide.meta.gef.i18n.Messages;
import aurora.ide.meta.project.AuroraMetaProject;
import aurora.ide.project.propertypage.ProjectPropertyPage;
import aurora.ide.search.cache.CacheManager;
import aurora.plugin.source.gen.screen.model.ScreenBody;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.DelegatingDragAdapter;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import uncertain.composite.CompositeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BMViewer {
    private VScreenEditor vse;
    private IProject project;
    private TreeViewer viewer;

    public BMViewer(Composite c, VScreenEditor vScreenEditor) {
        this.vse = vScreenEditor;
        this.init();
        this.configrueTreeViewer(c);
    }

    private void init() {
        IEditorInput editorInput = this.vse.getEditorInput();
        if (editorInput == null) {
            return;
        }
        Object file = editorInput.getAdapter(IFile.class);
        if (file instanceof IFile) {
            this.project = ((IFile)file).getProject();
        }
    }

    public String getBMHome() {
        AuroraMetaProject amp = new AuroraMetaProject(this.project);
        try {
            IProject auroraProject = amp.getAuroraProject();
            return auroraProject.getPersistentProperty(ProjectPropertyPage.BMQN);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public IProject getAuroraProject() {
        AuroraMetaProject amp = new AuroraMetaProject(this.project);
        try {
            return amp.getAuroraProject();
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return null;
        }
    }

    private void configrueTreeViewer(Composite c) {
        this.viewer = new TreeViewer(c, 0);
        DelegatingDragAdapter dragAdapter = new DelegatingDragAdapter();
        dragAdapter.addDragSourceListener(new TransferDragSourceListener(){

            public Transfer getTransfer() {
                return BMTransfer.getInstance();
            }

            public void dragStart(DragSourceEvent event) {
                List<CompositeMap> data = this.getData();
                if (data == null) {
                    return;
                }
                event.detail = 1;
                event.doit = true;
                BMTransfer.getInstance().setObject(data);
            }

            protected List<CompositeMap> getFields(Object data) throws CoreException, ApplicationException {
                ArrayList<CompositeMap> fs = new ArrayList<CompositeMap>();
                if (data instanceof IFile) {
                    ModelField[] createFields;
                    ModelField[] modelFieldArray = createFields = BMViewer.this.createFields((IFile)data);
                    int n = createFields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ModelField mf = modelFieldArray[n2];
                        fs.add(this.getFieldMap(mf));
                        ++n2;
                    }
                }
                if (data instanceof ModelField) {
                    CompositeMap fieldMap = this.getFieldMap((ModelField)data);
                    fs.add(fieldMap);
                }
                return fs;
            }

            private CompositeMap getFieldMap(ModelField data) {
                CompositeMap fieldMap = data.fieldMap;
                if ("ref-field".equals(data.editor)) {
                    fieldMap = (CompositeMap)fieldMap.clone();
                    fieldMap.put((Object)"prompt", (Object)data.getPrompt());
                }
                fieldMap.put((Object)"model", (Object)aurora.ide.search.core.Util.toBMPKG((IFile)data.parent));
                return fieldMap;
            }

            private List<CompositeMap> getData() {
                TreeSelection selection = (TreeSelection)BMViewer.this.viewer.getSelection();
                Object obj = selection.getFirstElement();
                try {
                    return this.getFields(obj);
                }
                catch (CoreException coreException) {
                }
                catch (ApplicationException applicationException) {
                    // empty catch block
                }
                return null;
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = this.getData();
            }

            public void dragFinished(DragSourceEvent event) {
                BMTransfer.getInstance().setObject(null);
            }
        });
        this.viewer.addDragSupport(1, dragAdapter.getTransfers(), (DragSourceListener)dragAdapter);
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new VLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null));
        this.refreshInput();
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.hookContextMenu();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action addBM = new Action(){

                    public void run() {
                        BMViewer.this.addFile();
                        BMViewer.this.vse.markDirty();
                    }
                };
                addBM.setText("\u589e\u52a0");
                addBM.setImageDescriptor(PrototypeImagesUtils.getImageDescriptor("palette/toolbar_btn_01.png"));
                manager.add((IAction)addBM);
                Action delBM = new Action(){

                    public void run() {
                        Object selectObject = BMViewer.this.getSelectObject();
                        if (selectObject instanceof IFile) {
                            String bmpkg = aurora.ide.search.core.Util.toBMPKG((IFile)((IFile)selectObject));
                            BMViewer.this.getViewDiagram().getUnBindModels().remove(bmpkg);
                            BMViewer.this.vse.markDirty();
                            BMViewer.this.refreshInput();
                        }
                    }
                };
                delBM.setText("\u5220\u9664");
                delBM.setImageDescriptor(PrototypeImagesUtils.getImageDescriptor("delete.gif"));
                Object selectObject = BMViewer.this.getSelectObject();
                if (selectObject instanceof IFile) {
                    manager.add((IAction)delBM);
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    public IFile openResourceSelector(Shell shell, String[] exts, IContainer root) {
        ResourceSelector fss = new ResourceSelector(shell);
        fss.setExtFilter(exts);
        fss.setInput(root);
        IResource obj = fss.getSelection();
        if (!(obj instanceof IFile)) {
            return null;
        }
        return (IFile)obj;
    }

    protected void addFile() {
        String[] as = new String[]{"bm"};
        IFolder bmHome = this.getModelFolder();
        if (bmHome == null || !bmHome.exists()) {
            DialogUtil.showWarningMessageBox((String)"\u627e\u4e0d\u5230BM\u4e3b\u76ee\u5f55\uff0c\u9700\u8981\u914d\u7f6e\u5173\u8054\u5de5\u7a0b\u3002");
            return;
        }
        IFile file = this.openResourceSelector(this.viewer.getControl().getShell(), as, (IContainer)bmHome);
        if (file == null || !file.exists()) {
            return;
        }
        String bmpkg = aurora.ide.search.core.Util.toBMPKG((IFile)file);
        this.getViewDiagram().addUnBindModel(bmpkg);
        this.refreshInput();
    }

    public void refreshInput() {
        this.viewer.setInput((Object)this.getViewDiagram());
    }

    public List<IFile> getModelFiles(ScreenBody viewDiagram) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        List models = viewDiagram.getModels();
        for (String classPath : models) {
            try {
                IResource bm = BMUtil.getBMResourceFromClassPath((IProject)this.getAuroraProject(), (String)classPath);
                if (!(bm instanceof IFile) || !bm.exists() || files.contains((IFile)bm)) continue;
                files.add((IFile)bm);
            }
            catch (ApplicationException applicationException) {
                // empty catch block
            }
        }
        return files;
    }

    public IFolder getModelFolder() {
        String bmHome = this.getBMHome();
        IProject auroraProject = this.getAuroraProject();
        if (bmHome != null && auroraProject != null) {
            return auroraProject.getWorkspace().getRoot().getFolder((IPath)new Path(bmHome));
        }
        return null;
    }

    private ScreenBody getViewDiagram() {
        ScreenBody model = this.vse.getDiagram();
        if (model instanceof ScreenBody) {
            return model;
        }
        return null;
    }

    private ModelField[] createFields(IFile model) {
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            CompositeMap modelMap = CacheManager.getWholeBMCompositeMap((IFile)model);
            BMCompositeMap bmMap = new BMCompositeMap(modelMap);
            List<CompositeMap> fields = bmMap.getFields();
            for (CompositeMap qf : fields) {
                if (!"field".equals(qf.getName()) || qf.get((Object)"name") == null) continue;
                Object field = new ModelField(model, qf, Util.getType(qf));
                result.add(field);
                String lookupcode = Util.getValueIgnoreCase(qf, "lookupcode");
                String lookupfield = Util.getValueIgnoreCase(qf, "lookupfield");
                if (lookupcode == null || lookupfield == null) continue;
                CompositeMap clone = (CompositeMap)qf.clone();
                clone.remove((Object)"defaulteditor");
                clone.remove((Object)"defaultEditor");
                clone.put((Object)"name", (Object)lookupfield);
                field = new ModelField(model, clone, "ref-field");
                result.add(field);
            }
            List<CompositeMap> refFields = bmMap.getRefFields();
            for (CompositeMap qf : refFields) {
                if (!"ref-field".equals(qf.getName()) || qf.get((Object)"name") == null) continue;
                ModelField field = new ModelField(model, qf, "ref-field");
                result.add(field);
            }
            List<CompositeMap> queryFields = bmMap.getQueryFields();
            for (CompositeMap qf : queryFields) {
                if (!"query-field".equals(qf.getName()) || qf.get((Object)"name") == null) continue;
                ModelField field = new ModelField(model, qf, "query-field");
                result.add(field);
            }
        }
        catch (CoreException coreException) {
        }
        catch (ApplicationException applicationException) {
            // empty catch block
        }
        return result.toArray(new ModelField[result.size()]);
    }

    private Object getSelectObject() {
        TreeItem[] items = this.viewer.getTree().getSelection();
        if (items.length > 0) {
            return items[0].getData();
        }
        return null;
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            IProject auroraProject = BMViewer.this.getAuroraProject();
            if (auroraProject == null) {
                return new String[]{Messages.BMViewer_No_aurora_project};
            }
            if (inputElement instanceof ScreenBody) {
                ((ScreenBody)inputElement).isBindTemplate();
                List<IFile> modelFiles = BMViewer.this.getModelFiles((ScreenBody)inputElement);
                if (modelFiles.size() == 0) {
                    return new String[]{Messages.BMViewer_No_model};
                }
                return modelFiles.toArray(new IFile[modelFiles.size()]);
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IFile) {
                return BMViewer.this.createFields((IFile)parentElement);
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof ModelField) {
                return ((ModelField)element).parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IFile;
        }
    }

    private class ModelField {
        public IFile parent;
        public CompositeMap fieldMap;
        public String editor;
        static final String REF_FIELD = "ref-field";
        static final String QUERY_FIELD = "query-field";

        public ModelField(IFile parent, CompositeMap fieldMap, String editor) {
            this.parent = parent;
            this.fieldMap = fieldMap;
            this.editor = editor;
        }

        public String getPrompt() {
            String prompt = null;
            prompt = REF_FIELD.equals(this.editor) ? Util.getRefFieldSourcePrompt(BMViewer.this.getAuroraProject(), this.fieldMap, "") : Util.getPrompt(this.fieldMap, "");
            return prompt == null ? this.fieldMap.getString((Object)"prompt", "") : prompt;
        }

        public String getName() {
            String fname = this.fieldMap.getString((Object)"name", "");
            return "[" + fname + "]";
        }
    }

    private class VLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private ResourceManager resourceManager;

        private VLabelProvider() {
        }

        private ResourceManager getResourceManager() {
            if (this.resourceManager == null) {
                this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
            }
            return this.resourceManager;
        }

        protected final Object getAdapter(Object sourceObject) {
            Object result;
            IAdaptable adaptable;
            Object result2;
            Class<IWorkbenchAdapter> adapterType = IWorkbenchAdapter.class;
            if (sourceObject == null) {
                return null;
            }
            if (adapterType.isInstance(sourceObject)) {
                return sourceObject;
            }
            if (sourceObject instanceof IAdaptable && (result2 = (adaptable = (IAdaptable)sourceObject).getAdapter(adapterType)) != null) {
                Assert.isTrue((boolean)adapterType.isInstance(result2));
                return result2;
            }
            if (!(sourceObject instanceof PlatformObject) && (result = Platform.getAdapterManager().getAdapter(sourceObject, adapterType)) != null) {
                return result;
            }
            return null;
        }

        public final Image getImage(Object element) {
            if (element instanceof IFile) {
                IWorkbenchAdapter adapter = (IWorkbenchAdapter)this.getAdapter(element);
                if (adapter == null) {
                    return null;
                }
                ImageDescriptor descriptor = adapter.getImageDescriptor(element);
                if (descriptor == null) {
                    return null;
                }
                return (Image)this.getResourceManager().get((DeviceResourceDescriptor)descriptor);
            }
            if (element instanceof ModelField) {
                return this.getImage((ModelField)element);
            }
            return null;
        }

        private Image getImage(ModelField model) {
            String type = model.editor;
            if ("comboBox".equalsIgnoreCase(type)) {
                return PrototypeImagesUtils.getImage("palette/itembar_01.png");
            }
            if ("datePicker".equalsIgnoreCase(type) || "dateTimePicker".equalsIgnoreCase(type)) {
                return PrototypeImagesUtils.getImage("palette/itembar_02.png");
            }
            if ("lov".equalsIgnoreCase(type)) {
                return PrototypeImagesUtils.getImage("palette/itembar_03.png");
            }
            if ("textField".equalsIgnoreCase(type)) {
                return PrototypeImagesUtils.getImage("palette/itembar_04.png");
            }
            if ("numberField".equalsIgnoreCase(type)) {
                return PrototypeImagesUtils.getImage("palette/itembar_05.png");
            }
            if ("checkBox".equalsIgnoreCase(type)) {
                return PrototypeImagesUtils.getImage("palette/checkbox_01.png");
            }
            if ("ref-field".equalsIgnoreCase(type)) {
                return PrototypeImagesUtils.getImage("palette/ref.png");
            }
            if ("query-field".equalsIgnoreCase(type)) {
                return PrototypeImagesUtils.getImage("palette/search.png");
            }
            return PrototypeImagesUtils.getImage("palette/itembar_04.png");
        }

        public final String getText(Object element) {
            return this.getStyledText(element).getString();
        }

        public StyledString getStyledText(Object element) {
            StyledString s = new StyledString();
            if (element instanceof IFile) {
                s.append(((IFile)element).getFullPath().removeFileExtension().lastSegment());
                s.append(" ");
                String pkg = aurora.ide.search.core.Util.getPKG((IPath)((IFile)element).getProjectRelativePath());
                s.append("[" + pkg + "]", StyledString.DECORATIONS_STYLER);
                return s;
            }
            if (element instanceof ModelField) {
                s.append(((ModelField)element).getPrompt());
                s.append(" ");
                s.append(((ModelField)element).getName(), StyledString.QUALIFIER_STYLER);
                return s;
            }
            if (element instanceof String) {
                return s.append(element.toString());
            }
            return s;
        }
    }
}

