/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer.wizard;

import aurora.ide.meta.gef.designer.editor.LookupCodeViewer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import uncertain.composite.CompositeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateSyscodeWizardPage
extends WizardPage {
    private CompositeMap codeMap;
    private LookupCodeViewer editor;
    private boolean init = false;

    public CreateSyscodeWizardPage() {
        super("wizardPage");
        this.setTitle("Auto register SYS_CODE");
        this.setDescription("Select which sys_code(s) you want to create.\nNote that, if the syscode already exists in database, then it will be delete before create without prompt.");
    }

    public void setCodeMap(CompositeMap map) {
        this.codeMap = map;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.editor = new LookupCodeViewer(container, 2080);
        Tree tree = this.editor.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 4));
        this.editor.setInput(this.codeMap);
        this.editor.refresh();
        this.setControl((Control)container);
        Button btnNewButton = new Button(container, 0);
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateSyscodeWizardPage.this.selectAll();
            }
        });
        btnNewButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnNewButton.setText("Select All");
        Button btnNewButton_2 = new Button(container, 0);
        btnNewButton_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateSyscodeWizardPage.this.selectNone();
            }
        });
        btnNewButton_2.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnNewButton_2.setText("Select None");
        Button btnNewButton_3 = new Button(container, 0);
        btnNewButton_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateSyscodeWizardPage.this.selectByDatabase();
            }
        });
        btnNewButton_3.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnNewButton_3.setText("Default");
        new Label(container, 0);
    }

    private void selectAll() {
        TreeItem[] treeItemArray = this.editor.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            ti.setChecked(true);
            ++n2;
        }
    }

    private void selectNone() {
        TreeItem[] treeItemArray = this.editor.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            ti.setChecked(false);
            ++n2;
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!this.init) {
            this.init = true;
            this.selectByDatabase();
        }
    }

    private void selectByDatabase() {
        TreeItem[] treeItemArray = this.editor.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti;
            CompositeMap m = (CompositeMap)(ti = treeItemArray[n2]).getData();
            ti.setChecked(m.getBoolean((Object)"exists") == false);
            ++n2;
        }
    }

    public List<CompositeMap> getCodeToCreate() {
        ArrayList<CompositeMap> list = new ArrayList<CompositeMap>();
        TreeItem[] treeItemArray = this.editor.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            if (ti.getChecked()) {
                list.add((CompositeMap)ti.getData());
            }
            ++n2;
        }
        return list;
    }
}

