/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer.wizard;

import aurora.ide.meta.gef.designer.model.BMModel;
import aurora.ide.meta.gef.designer.wizard.Messages;
import aurora.ide.meta.gef.editors.property.ResourceSelector;
import aurora.ide.meta.project.AuroraMetaProject;
import aurora.ide.meta.project.AuroraMetaProjectNature;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BaseInfoWizardPage
extends WizardPage {
    private static String fileNamePattern = "[\\w\\d_]+(.bmq)?";
    private IResource resource;
    private ValidateDirListener dirValidator = new ValidateDirListener();
    private ValidateFileNameListener fnValidator = new ValidateFileNameListener();
    private Text text_dir;
    private Text text_fileName;
    private Text text;
    private BMModel model;

    public BaseInfoWizardPage() {
        super("BaseInfoWizardPage");
        this.setTitle(Messages.BaseInfoWizardPage_3);
        this.setDescription(Messages.BaseInfoWizardPage_4);
    }

    void setCurrentSelection(IResource resource) {
        this.resource = resource;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(container, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label.setText(Messages.BaseInfoWizardPage_5);
        this.text_dir = new Text(container, 2048);
        this.text_dir.addModifyListener((ModifyListener)this.dirValidator);
        this.text_dir.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button button = new Button(container, 0);
        button.setText(Messages.BaseInfoWizardPage_6);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseInfoWizardPage.this.selectDir();
            }
        });
        Label label_1 = new Label(container, 0);
        label_1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label_1.setText(Messages.BaseInfoWizardPage_7);
        this.text_fileName = new Text(container, 2048);
        this.text_fileName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.text_fileName.addModifyListener((ModifyListener)this.fnValidator);
        this.text_dir.setText(this.getDefaultDir());
        this.text_fileName.setText("");
        new Label(container, 0);
        Group group = new Group(container, 0);
        group.setText(Messages.BaseInfoWizardPage_9);
        group.setLayout((Layout)new GridLayout(4, false));
        group.setLayoutData((Object)new GridData(4, 4, false, true, 3, 1));
        new Label((Composite)group, 0);
        this.text = new Text((Composite)group, 2818);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Button btnNewButton = new Button((Composite)group, 0);
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseInfoWizardPage.this.format();
            }
        });
        btnNewButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        btnNewButton.setText(Messages.BaseInfoWizardPage_10);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.dirValidator.getMessage() == null && this.fnValidator.getMessage() != null) {
            this.text_fileName.forceFocus();
        }
    }

    private void selectDir() {
        ResourceSelector rs = new ResourceSelector(this.getShell());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        rs.setDirOnly(true);
        rs.setInput((IContainer)root);
        IResource res = rs.getSelection();
        if (res != null) {
            this.text_dir.setText(res.getFullPath().toString());
        }
    }

    private void format() {
        String str = this.text.getText();
        StringBuilder sb = new StringBuilder(str.length());
        StringTokenizer st = new StringTokenizer(str, Messages.BaseInfoWizardPage_1);
        while (st.hasMoreElements()) {
            sb.append(st.nextElement() + "\n");
        }
        this.text.setText(sb.toString());
    }

    private String getDefaultDir() {
        IProject proj;
        block6: {
            if (this.resource == null) {
                return "";
            }
            proj = this.resource.getProject();
            try {
                if (AuroraMetaProjectNature.hasAuroraNature(proj)) break block6;
                return "";
            }
            catch (Exception exception) {
                return "";
            }
        }
        AuroraMetaProject mProj = new AuroraMetaProject(proj);
        IFolder folder = mProj.getModelFolder();
        IPath path1 = folder.getFullPath();
        IPath path2 = this.resource.getFullPath();
        if (this.resource instanceof IFile) {
            path2 = this.resource.getParent().getFullPath();
        }
        if (path1.isPrefixOf(path2)) {
            return path2.toString();
        }
        return path1.toString();
    }

    private String getRealFileName(String fn) {
        int idx = fn.indexOf(46);
        if (idx == -1) {
            fn = String.valueOf(fn) + ".bmq";
        }
        return fn;
    }

    private boolean isInAuroraMetaProject(IResource res) {
        if (res == null) {
            return false;
        }
        IProject proj = res.getProject();
        try {
            return AuroraMetaProjectNature.hasAuroraNature(proj);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getFileFullPath() {
        String path = this.text_dir.getText();
        String fn = this.text_fileName.getText();
        fn = this.getRealFileName(fn);
        return path.charAt(path.length() - 1) == '/' ? String.valueOf(path) + fn : String.valueOf(path) + "/" + fn;
    }

    public String getShortName() {
        String fn = this.text_fileName.getText();
        int idx = fn.indexOf(46);
        if (idx != -1) {
            return fn.substring(0, idx);
        }
        return fn;
    }

    public String[] getPreInput() {
        this.format();
        String input = this.text.getText();
        StringTokenizer st = new StringTokenizer(input);
        String[] ss = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreElements()) {
            ss[i] = st.nextToken();
            ++i;
        }
        return ss;
    }

    public void setModel(BMModel model) {
        this.model = model;
    }

    private class ValidateDirListener
    implements ModifyListener {
        private ValidateDirListener() {
        }

        public void modifyText(ModifyEvent e) {
            String msg = this.getMessage();
            if (msg != null) {
                BaseInfoWizardPage.this.setErrorMessage(msg);
                BaseInfoWizardPage.this.setPageComplete(false);
            } else {
                BaseInfoWizardPage.this.setErrorMessage(null);
                BaseInfoWizardPage.this.setPageComplete(true);
                msg = BaseInfoWizardPage.this.fnValidator.getMessage();
                if (msg != null) {
                    BaseInfoWizardPage.this.setErrorMessage(msg);
                    BaseInfoWizardPage.this.setPageComplete(false);
                }
            }
        }

        public String getMessage() {
            String t = BaseInfoWizardPage.this.text_dir.getText();
            if (t == null || t.trim().length() == 0) {
                return Messages.BaseInfoWizardPage_0;
            }
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(t);
            if (res == null || !(res instanceof IFolder)) {
                return Messages.BaseInfoWizardPage_17;
            }
            if (!BaseInfoWizardPage.this.isInAuroraMetaProject(res)) {
                return Messages.BaseInfoWizardPage_18;
            }
            return null;
        }
    }

    private class ValidateFileNameListener
    implements ModifyListener {
        private ValidateFileNameListener() {
        }

        public void modifyText(ModifyEvent e) {
            String msg = this.getMessage();
            if (msg != null) {
                BaseInfoWizardPage.this.setErrorMessage(msg);
                BaseInfoWizardPage.this.setPageComplete(false);
            } else {
                BaseInfoWizardPage.this.setErrorMessage(null);
                BaseInfoWizardPage.this.setPageComplete(true);
                msg = BaseInfoWizardPage.this.dirValidator.getMessage();
                if (msg != null) {
                    BaseInfoWizardPage.this.setErrorMessage(msg);
                    BaseInfoWizardPage.this.setPageComplete(false);
                }
            }
        }

        public String getMessage() {
            String t = BaseInfoWizardPage.this.text_fileName.getText();
            if (t == null || !t.toLowerCase().matches(fileNamePattern)) {
                return Messages.BaseInfoWizardPage_19;
            }
            t = BaseInfoWizardPage.this.getRealFileName(t);
            int extLen = 1 + "bmq".length();
            if (t.length() > 27 + extLen) {
                return "Base file name is too long!(" + (t.length() - extLen) + ">27)";
            }
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(String.valueOf(BaseInfoWizardPage.this.text_dir.getText()) + "/" + t);
            if (res != null) {
                String type = res.getClass().getSimpleName().toLowerCase();
                return String.format(Messages.BaseInfoWizardPage_21, type, res.getName());
            }
            return null;
        }
    }
}

