/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer.model;

import aurora.ide.meta.gef.designer.IDesignerConst;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;

public class Record
implements IDesignerConst {
    private HashMap<String, Object> map = new HashMap();
    PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    public final Object get(String key) {
        if (key != null) {
            key = key.toLowerCase();
        }
        return this.map.get(key);
    }

    public final void put(String key, Object value) {
        this.put(key, value, true);
    }

    public final void put(String key, Object value, boolean notify) {
        String okey = key;
        if (key != null) {
            key = key.toLowerCase();
        }
        Object old = this.map.get(key);
        this.map.put(key, value);
        if (notify && !this.eq(old, value)) {
            this.firePropertyChange(okey, old, value);
        }
    }

    protected boolean eq(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public String getString(String key) {
        Object obj = this.get(key);
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public String getStringNotNull(String key) {
        String value = this.getString(key);
        return value == null ? "" : value;
    }

    public int getNum() {
        return this.getInt("no.");
    }

    public void setNum(int num) {
        this.put("no.", num, false);
    }

    public String getPrompt() {
        return this.getString("prompt");
    }

    public void setPrompt(String prompt) {
        this.put("prompt", prompt);
    }

    public String getOptions() {
        return this.getStringNotNull("options");
    }

    public void setOptions(String str) {
        this.put("options", str);
    }

    public Integer getInt(String key) {
        Object obj = this.get(key);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return Integer.parseInt((String)obj);
        }
        return (Integer)obj;
    }

    public boolean getBoolean(String key) {
        Object obj = this.get(key);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return Boolean.parseBoolean((String)obj);
        }
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String prop, Object old, Object newValue) {
        this.listeners.firePropertyChange(prop, old, newValue);
    }

    public Record clone() {
        Record r = new Record();
        r.map = (HashMap)this.map.clone();
        return r;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1000);
        String[] stringArray = TABLE_COLUMN_PROPERTIES;
        int n = TABLE_COLUMN_PROPERTIES.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (key.length() != 0) {
                sb.append(key);
                sb.append(" = ");
                sb.append(this.get(key));
                sb.append(" ;  ");
            }
            ++n2;
        }
        return sb.toString();
    }

    public String getName() {
        return this.getStringNotNull("name");
    }

    public void setName(String name) {
        this.put("name", name);
    }

    public String getType() {
        return this.getStringNotNull("type");
    }

    public void setType(String type) {
        this.put("type", type);
    }

    public String getEditor() {
        return this.getStringNotNull("editor");
    }

    public void setEditor(String editor) {
        this.put("editor", editor);
    }

    public boolean isForUpdate() {
        return this.getBoolean("forUpdate");
    }

    public void setForUpdate(boolean update) {
        this.put("forUpdate", update);
    }

    public boolean isForInsert() {
        return this.getBoolean("forInsert");
    }

    public void setForInsert(boolean insert) {
        this.put("forInsert", insert);
    }

    public boolean isForDisplay() {
        return this.getBoolean("forDisplay");
    }

    public void setForDisplay(boolean display) {
        this.put("forDisplay", display);
    }

    public boolean isForQuery() {
        return this.getBoolean("forQuery");
    }

    public void setForQuery(boolean query) {
        this.put("forQuery", query);
    }

    public boolean isForLov() {
        return this.getBoolean("forLov");
    }

    public void setForLov(boolean lov) {
        this.put("forLov", lov);
    }

    public String getUpdateExpression() {
        return this.getStringNotNull("updateExpression");
    }

    public void setUpdateExpression(String exp) {
        this.put("updateExpression", exp);
    }

    public String getInsertExpression() {
        return this.getStringNotNull("insertExpression");
    }

    public void setInsertExpression(String exp) {
        this.put("insertExpression", exp);
    }
}

