/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer.model;

import aurora.ide.api.composite.map.CommentCompositeLoader;
import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.builder.ResourceUtil;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.gef.designer.BMCompositeMap;
import aurora.ide.meta.gef.designer.DataType;
import aurora.ide.meta.gef.designer.model.BMModel;
import aurora.ide.meta.gef.designer.model.ModelUtil;
import aurora.ide.meta.gef.designer.model.Record;
import aurora.ide.meta.gef.designer.model.Relation;
import aurora.ide.meta.gef.editors.source.gen.DataSetFieldUtil;
import aurora.ide.meta.project.AuroraMetaProject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.composite.CompositeMapParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelMerger {
    private IFile file;
    private IFile bmFile;
    private AuroraMetaProject amProject;
    private IProject aProject;
    private IFolder classFolder;
    private IFolder modelFolder;
    private CompositeMap bmMap;
    private BMModel model;
    private char seqRefAlias = (char)112;
    protected boolean dirty = false;

    public ModelMerger(IFile file) {
        this.file = file;
        try {
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void init() throws ResourceNotFoundException, CoreException, ApplicationException, SAXException, IOException {
        this.amProject = new AuroraMetaProject(this.file.getProject());
        this.aProject = this.amProject.getAuroraProject();
        this.classFolder = ResourceUtil.getBMHomeFolder((IProject)this.aProject);
        this.modelFolder = this.amProject.getModelFolder();
        this.bmFile = this.getBMFile();
    }

    public void initModel() throws SAXException, IOException, CoreException {
        CompositeMapParser parser = new CompositeMapParser((CompositeLoader)new CommentCompositeLoader());
        if (this.bmFile != null && this.bmFile.exists()) {
            this.bmMap = parser.parseStream(this.bmFile.getContents(true));
        }
        CompositeMap map = parser.parseStream(this.file.getContents());
        this.model = ModelUtil.fromCompositeMap(map);
    }

    public IFile getBMFile() {
        if (this.bmFile == null) {
            IPath modelPath = this.file.getFullPath().makeRelativeTo(this.modelFolder.getFullPath());
            IPath bmPath = modelPath.removeFileExtension().addFileExtension("bm");
            bmPath = this.classFolder.getFullPath().append(bmPath);
            this.bmFile = this.aProject.getParent().getFile(bmPath);
        }
        return this.bmFile;
    }

    public IFolder getClassFolder() {
        return this.classFolder;
    }

    public IFolder getModelFolder() {
        return this.modelFolder;
    }

    public IProject getAuroraProject() {
        return this.aProject;
    }

    public BMModel getOriginalModel() {
        return this.model;
    }

    public CompositeMap getOriginalBMMap() {
        return this.bmMap;
    }

    public BMModel getMergedModel() {
        this.model.setNamePrefix(ModelUtil.computeNamePrefix(this.file));
        return this.model;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void updateModel() {
        this.model.setTitle(this.bmMap.getString((Object)"title"));
        BMCompositeMap bmc = new BMCompositeMap(this.bmMap);
        this.updateRecordsOfModel(this.model, bmc);
        this.updateRelationsOfModel(this.model, bmc);
        String ddf = this.getMapString(this.bmMap, "defaultDisplayField");
        for (Record r : this.model.getRecordList()) {
            if (!r.getName().equals(ddf)) continue;
            this.model.setDefaultDisplay(r.getPrompt());
        }
    }

    private void updateRecordsOfModel(BMModel model, BMCompositeMap bmc) {
        Record r;
        CompositeMap fieldsMap = bmc.getFieldsMap();
        if (fieldsMap == null) {
            model.removeAll();
            return;
        }
        ArrayList<CompositeMap> list = new ArrayList<CompositeMap>(bmc.getFields());
        ArrayList<Record> records = model.getRecordList();
        int i = 0;
        while (i < records.size()) {
            r = records.get(i);
            String prompt = r.getPrompt();
            CompositeMap m = this.searchCmList(list, "prompt", prompt);
            if (m == null) {
                model.remove(r);
                --i;
            } else {
                this.updateRecordUseCompositeMap(r, m);
                list.remove(m);
            }
            ++i;
        }
        CompositeMap pkf = bmc.getFieldOfPk();
        if (pkf != null) {
            r = model.getPkRecord();
            this.updateRecordUseCompositeMap(r, pkf);
        }
        for (CompositeMap m : list) {
            if (m.getString((Object)"name").equals(model.getPkRecord().getName())) continue;
            model.add(this.createNewRecord(m));
        }
    }

    private void updateRecordUseCompositeMap(Record r, CompositeMap fMap) {
        r.setName(fMap.getString((Object)"name"));
        r.setPrompt(fMap.getString((Object)"prompt"));
        String code = this.getMapString(fMap, "lookupCode");
        if (code == null || code.length() == 0) {
            r.setOptions(fMap.getString((Object)"options"));
        } else {
            r.setOptions(code);
        }
        r.setEditor(this.getMapString(fMap, "defaultEditor"));
    }

    private Record createNewRecord(CompositeMap m) {
        Record r = new Record();
        this.updateRecordUseCompositeMap(r, m);
        return r;
    }

    private void updateRelationsOfModel(BMModel model, BMCompositeMap bmc) {
        CompositeMap relMap = bmc.getRelationsMap();
        if (relMap == null) {
            model.removeAllRelations();
            return;
        }
        ArrayList<CompositeMap> list = new ArrayList<CompositeMap>(bmc.getRelations());
        ArrayList<Relation> relations = model.getRelationList();
        int i = 0;
        while (i < relations.size()) {
            Relation r = relations.get(i);
            String name = r.getName();
            CompositeMap m = this.searchCmList(list, "name", name);
            if (m == null) {
                model.remove(r);
                --i;
            } else {
                r.setJoinType(this.getMapString(m, "joinType"));
                r.setRefTable(this.getMapString(m, "refModel"));
                CompositeMap mm = m.getChild("reference");
                if (mm != null) {
                    this.updateReferenceOfModel(mm, r);
                }
                list.remove(m);
            }
            ++i;
        }
        for (CompositeMap m : list) {
            model.add(this.createNewRelation(m));
        }
    }

    private void updateReferenceOfModel(CompositeMap refMap, Relation r) {
        for (Record record : this.model.getRelationList()) {
            if (!record.getName().equals(this.getMapString(refMap, "localField"))) continue;
            r.setLocalField(record.getPrompt());
            break;
        }
        DataSetFieldUtil dataSetFieldUtil = new DataSetFieldUtil(this.file.getProject(), "", r.getRefTable());
        ArrayList<CompositeMap> locField = dataSetFieldUtil.getLocalFields(dataSetFieldUtil.getBmMap(), false);
        for (CompositeMap lfm : locField) {
            if (!lfm.getString((Object)"name").equals(this.getMapString(refMap, "sourceField"))) continue;
            r.setSrcField(lfm.getString((Object)"prompt"));
            break;
        }
    }

    private Relation createNewRelation(CompositeMap m) {
        Relation r = new Relation();
        r.setName(m.getString((Object)"name"));
        r.setJoinType(this.getMapString(m, "joinType"));
        r.setRefTable(this.getMapString(m, "refModel"));
        CompositeMap mm = m.getChild("reference");
        this.updateReferenceOfModel(mm, r);
        return r;
    }

    public CompositeMap getMergedCompositeMap() {
        return this.bmMap;
    }

    private void updateBmMap(CompositeMap bmMap, BMModel model) {
        BMCompositeMap bmc = new BMCompositeMap(bmMap);
        bmMap.put((Object)"title", (Object)model.getTitle());
        Record r = model.getDefaultDisplayRecord();
        if (r != null) {
            bmMap.put((Object)"defaultDisplayField", (Object)r.getName());
        }
        this.updateFieldsOfBm(bmc, model);
        this.updateRelationsOfBm(bmc, model);
    }

    private void updateFieldsOfBm(BMCompositeMap bmc, BMModel model) {
        CompositeMap fieldsMap = bmc.getFieldsMap();
        ArrayList<CompositeMap> list = new ArrayList<CompositeMap>(bmc.getFields());
        ArrayList<Record> records = new ArrayList<Record>(model.getRecordList());
        String pk_name = bmc.getPkFieldName();
        int i = 0;
        while (i < list.size()) {
            CompositeMap m = (CompositeMap)list.get(i);
            String prompt = m.getString((Object)"prompt");
            if (prompt != null && !m.getString((Object)"name").equals(pk_name)) {
                Record r = this.searchReList(records, "prompt", prompt);
                if (r == null) {
                    fieldsMap.removeChild(m);
                } else {
                    this.updateFieldUseRecord(m, r);
                    records.remove(r);
                }
            }
            ++i;
        }
        for (Record r : records) {
            fieldsMap.addChild(this.getNewFieldMap(r));
        }
        this.updatePk(model, bmc);
    }

    private void updatePk(BMModel model, BMCompositeMap bmc) {
        CompositeMap pkf;
        Record r = model.getPkRecord();
        CompositeMap pkfMap = bmc.getFieldOfPk();
        if (pkfMap != null) {
            pkfMap.put((Object)"name", (Object)r.getName());
        }
        if ((pkf = bmc.getFirstPkField()) != null) {
            pkf.put((Object)"name", (Object)r.getName());
        }
    }

    private void updateFieldUseRecord(CompositeMap m, Record r) {
        m.put((Object)"name", (Object)r.getName());
        DataType dt = DataType.fromString(r.getType());
        if (dt == null) {
            dt = DataType.TEXT;
        }
        m.put((Object)"databaseType", (Object)dt.getDbType());
        m.put((Object)"dataType", (Object)dt.getJavaType());
        String editor = r.getString("editor");
        m.put((Object)"defaultEditor", (Object)editor);
        if (editor.equals("comboBox") || editor.equals("lov")) {
            String options = r.getString("options");
            if (dt.getDisplayType().equalsIgnoreCase("lookupCode")) {
                m.put((Object)"lookupCode", (Object)options);
                m.put((Object)"lookupField", (Object)(String.valueOf(r.getName()) + "_lookup"));
            } else {
                m.put((Object)"options", (Object)options);
            }
        }
    }

    private void updateRelationsOfBm(BMCompositeMap bmc, BMModel model) {
        CompositeMap relMap = bmc.getRelationsMap();
        ArrayList<CompositeMap> list = new ArrayList<CompositeMap>(bmc.getRelations());
        ArrayList<Relation> relations = new ArrayList<Relation>(model.getRelationList());
        int i = 0;
        while (i < list.size()) {
            CompositeMap m = (CompositeMap)list.get(i);
            String name = m.getString((Object)"name");
            Relation r = this.searchReList(relations, "name", name);
            if (r == null) {
                relMap.removeChild(m);
            } else {
                m.put((Object)"joinType", (Object)r.getJoinType());
                m.put((Object)"refModel", (Object)r.getRefTable());
                CompositeMap rm = m.getChild("reference");
                rm.put((Object)"localField", (Object)ModelUtil.getLocalFieldName(model, r.getLocalField()));
                rm.put((Object)"foreignField", (Object)ModelUtil.getForeignFieldName(this.file.getProject(), r.getSrcField(), r.getRefTable()));
                relations.remove(r);
            }
            ++i;
        }
        for (Relation r : relations) {
            relMap.addChild(this.getNewRelationMap(r));
        }
    }

    private CompositeMap getNewRelationMap(Relation r) {
        CompositeMap map = this.newCompositeMap("relation");
        map.put((Object)"name", (Object)r.getName());
        map.put((Object)"refModel", (Object)r.getRefTable());
        map.put((Object)"joinType", (Object)r.getJoinType());
        map.put((Object)"refAlias", (Object)this.getRefAlias(r));
        CompositeMap m = this.newCompositeMap("reference");
        m.put((Object)"localField", (Object)ModelUtil.getLocalFieldName(this.model, r.getLocalField()));
        m.put((Object)"foreignField", (Object)ModelUtil.getForeignFieldName(this.file.getProject(), r.getSrcField(), r.getRefTable()));
        map.addChild(m);
        return map;
    }

    private String getRefAlias(Relation r) {
        char c = this.seqRefAlias;
        this.seqRefAlias = (char)(c + '\u0001');
        return "rel_" + Character.toString(c);
    }

    private CompositeMap getNewFieldMap(Record r) {
        CompositeMap map = this.newCompositeMap("field");
        map.put((Object)"name", (Object)r.getName());
        DataType dt = DataType.fromString(r.getType());
        if (dt == null) {
            dt = DataType.TEXT;
        }
        map.put((Object)"databaseType", (Object)dt.getDbType());
        map.put((Object)"dataType", (Object)dt.getJavaType());
        map.put((Object)"defaultEditor", (Object)r.getString("editor"));
        map.put((Object)"prompt", (Object)r.getPrompt());
        return map;
    }

    private CompositeMap newCompositeMap(String name) {
        CommentCompositeMap map = new CommentCompositeMap(name);
        map.setPrefix("bm");
        return map;
    }

    private String getMapString(CompositeMap map, String attr) {
        String value = BMCompositeMap.getMapAttribute(map, attr);
        return value == null ? "" : value;
    }

    private CompositeMap searchCmList(List<CompositeMap> list, String property, String value) {
        for (CompositeMap m : list) {
            if (!value.equals(m.getString((Object)property))) continue;
            return m;
        }
        return null;
    }

    private <T extends Record> T searchReList(List<T> list, String property, String value) {
        for (Record r : list) {
            if (!value.equals(r.getString(property))) continue;
            return (T)r;
        }
        return null;
    }
}

