/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer.gen;

import aurora.ide.meta.gef.designer.DataType;
import aurora.ide.meta.gef.designer.IDesignerConst;
import aurora.ide.meta.gef.designer.model.BMModel;
import aurora.ide.meta.gef.designer.model.Record;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlGenerator
implements IDesignerConst {
    private static final String line_sep = String.format("%n", new Object[0]);
    private static final String prefix = "    ";
    private static final String header = "create table %s (" + line_sep;
    private static final String tail = ")";
    private static final String column_model = "    %%-%ds %%s";
    private static final String comment_model = "comment on column %%-%ss is '%%s'";
    private static final String[] who_fields = new String[]{"created_by", "creation_date", "last_updated_by", "last_update_date"};
    private static final String[] who_fields_type = new String[]{"number", "date", "number", "date"};
    private BMModel model;
    private String name;
    private int maxNameLength = 0;

    public SqlGenerator(BMModel model, String name) {
        this.model = model;
        this.name = name;
    }

    public String[] gen() {
        ArrayList<String> sqls = new ArrayList<String>();
        String[][] rs = this.getFieldsInfo();
        StringBuilder sb = new StringBuilder(10000);
        sb.append(String.format(header, this.name));
        this.maxNameLength = this.getMaxNameLength();
        String cm = String.format(column_model, this.maxNameLength);
        String t = rs.length == 0 ? "" : ",";
        Record r = this.model.getPkRecord();
        sb.append(String.valueOf(String.format(cm, r.getName(), this.getSqlType(r.getType()))) + " not null" + t + line_sep);
        int i = 0;
        while (i < rs.length) {
            t = i == rs.length - 1 ? "" : ",";
            sb.append(String.valueOf(String.format(cm, rs[i][0], rs[i][1])) + t + line_sep);
            ++i;
        }
        sb.append(tail);
        sqls.add(sb.toString());
        this.addComment(sqls);
        String[] sqlArr = new String[sqls.size()];
        sqls.toArray(sqlArr);
        return sqlArr;
    }

    private String[][] getFieldsInfo() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (Record r : this.model.getRecordList()) {
            list.add(new String[]{r.getName(), this.getSqlType(r.getType())});
        }
        if (this.model.isWhoEnabled()) {
            int i = 0;
            while (i < who_fields.length) {
                list.add(new String[]{who_fields[i], who_fields_type[i]});
                ++i;
            }
        }
        return (String[][])list.toArray((T[])new String[list.size()][]);
    }

    private void addComment(ArrayList<String> sqls) {
        String cm = String.format(comment_model, this.name.length() + 1 + this.maxNameLength);
        Record pkr = this.model.getPkRecord();
        sqls.add(String.format(cm, String.valueOf(this.name) + "." + pkr.getName(), pkr.getPrompt()));
        for (Record r : this.model.getRecordList()) {
            sqls.add(String.format(cm, String.valueOf(this.name) + "." + r.getName(), r.getPrompt()));
        }
    }

    private int getMaxNameLength() {
        int length = 0;
        for (Record r : this.model.getRecordList()) {
            int l = r.getName().length();
            if (l <= length) continue;
            length = l;
        }
        int l = this.model.getPkRecord().getName().length();
        if (l > length) {
            length = l;
        }
        if (this.model.isWhoEnabled()) {
            String[] stringArray = who_fields;
            int n = who_fields.length;
            int n2 = 0;
            while (n2 < n) {
                String n3 = stringArray[n2];
                if (n3.length() > length) {
                    length = n3.length();
                }
                ++n2;
            }
        }
        return length;
    }

    private String getSqlType(String type) {
        DataType dt = DataType.fromString(type);
        if (dt == null) {
            dt = DataType.TEXT;
        }
        return dt.getSqlType();
    }
}

