/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer.gen;

import aurora.ide.meta.gef.designer.DataType;
import aurora.ide.meta.gef.designer.IDesignerConst;
import aurora.ide.meta.gef.designer.gen.AbstractBmGenerator;
import aurora.ide.meta.gef.designer.gen.DuplicateException;
import aurora.ide.meta.gef.designer.gen.ExtendBmGenerator;
import aurora.ide.meta.gef.designer.model.BMModel;
import aurora.ide.meta.gef.designer.model.ModelMerger;
import aurora.ide.meta.gef.designer.model.ModelUtil;
import aurora.ide.meta.gef.designer.model.Record;
import aurora.ide.meta.gef.designer.model.Relation;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import uncertain.composite.CompositeMap;
import uncertain.composite.CompositeUtil;

public class BaseBmGenerator
extends AbstractBmGenerator {
    private char seqRefAlias = (char)102;
    private BMModel model;
    private String name;
    private IFile file;
    private ModelMerger merger;

    public BaseBmGenerator() {
    }

    public BaseBmGenerator(IFile file) {
        this();
        this.name = file.getName();
        int idx = this.name.indexOf(46);
        if (idx != -1) {
            this.name = this.name.substring(0, idx);
        }
        this.file = file;
        this.merger = new ModelMerger(file);
        try {
            this.merger.initModel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.model = this.merger.getOriginalModel();
    }

    public void process() throws Exception {
        IFile bmFile = this.merger.getBMFile();
        CompositeMap bmMap = null;
        bmMap = this.gen();
        this.createOrWriteFile(bmFile, bmMap);
        new ExtendBmGenerator(this.model, bmFile).gen();
    }

    protected void createOrWriteFile(IFile file, CompositeMap map) throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" + map.toXML();
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        if (file.exists()) {
            file.setContents((InputStream)is, 1, (IProgressMonitor)new NullProgressMonitor());
            ((InputStream)is).close();
        } else {
            CreateFileOperation cfo = new CreateFileOperation(file, null, (InputStream)is, "write " + file.getFullPath());
            cfo.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
    }

    protected CompositeMap newModelMap() {
        CompositeMap map = super.newModelMap();
        map.put((Object)"alias", (Object)"e");
        map.put((Object)"baseTable", (Object)this.name);
        return map;
    }

    private CompositeMap genFieldsMap() throws DuplicateException {
        CompositeMap fMap = this.newCompositeMap("fields");
        String pk_name = this.model.getPkRecord().getName();
        boolean haspk = false;
        for (Record r : this.model.getRecordList()) {
            if (CompositeUtil.findChild((CompositeMap)fMap, (String)"field", (String)"name", (String)r.getName()) != null) {
                throw new DuplicateException("field", "name", r.getName());
            }
            CompositeMap m = this.getNewFieldMap(r);
            if (pk_name.equals(m.getString((Object)"name"))) {
                haspk = true;
            }
            fMap.addChild(this.getNewFieldMap(r));
        }
        if (!haspk) {
            fMap.addChild(0, this.genPkFieldMap());
        }
        return fMap;
    }

    private CompositeMap genPkFieldMap() {
        CompositeMap pk = this.newCompositeMap("field");
        Record r = this.model.getPkRecord();
        pk.put((Object)"name", (Object)r.getName());
        pk.put((Object)"databaseType", (Object)"BIGINT");
        pk.put((Object)"dataType", (Object)"java.lang.Long");
        pk.put((Object)"prompt", (Object)"primary_key");
        pk.put((Object)"forInsert", (Object)r.isForInsert());
        pk.put((Object)"forUpdate", (Object)r.isForUpdate());
        return pk;
    }

    private CompositeMap getNewFieldMap(Record r) {
        CompositeMap map = this.newCompositeMap("field");
        map.put((Object)"name", (Object)r.getName());
        DataType dt = DataType.fromString(r.getType());
        if (dt == null) {
            dt = DataType.TEXT;
        }
        map.put((Object)"databaseType", (Object)dt.getDbType());
        map.put((Object)"dataType", (Object)dt.getJavaType());
        String editor = r.getString("editor");
        map.put((Object)"defaultEditor", (Object)editor);
        map.put((Object)"prompt", (Object)r.getPrompt());
        map.put((Object)"forInsert", (Object)r.isForInsert());
        map.put((Object)"forUpdate", (Object)r.isForUpdate());
        if ("comboBox".equals(editor) || "lov".equals(editor)) {
            String options = r.getString("options");
            if (dt.getDisplayType().equalsIgnoreCase("lookupCode")) {
                map.put((Object)"lookupCode", (Object)options);
                map.put((Object)"lookupField", (Object)(String.valueOf(r.getName()) + "_lookup"));
            } else {
                map.put((Object)"options", (Object)options);
            }
        }
        return map;
    }

    private CompositeMap genPkMap() {
        CompositeMap pkMap = this.newCompositeMap("primary-key");
        CompositeMap pk = this.newCompositeMap("pk-field");
        pk.put((Object)"name", (Object)this.model.getPkRecord().getName());
        pkMap.addChild(pk);
        return pkMap;
    }

    private CompositeMap genFeatureMap() {
        CompositeMap fMap = this.newCompositeMap("features");
        CompositeMap spk = this.newCompositeMap("sequence-pk", "o");
        fMap.addChild(spk);
        return fMap;
    }

    private CompositeMap genRelationMap() throws DuplicateException {
        CompositeMap rMap = this.newCompositeMap("relations");
        for (Relation r : this.model.getRelationList()) {
            if (CompositeUtil.findChild((CompositeMap)rMap, (String)"relation", (String)"name", (String)r.getName()) != null) {
                throw new DuplicateException("relation", "name", r.getName());
            }
            rMap.addChild(this.getNewRelationMap(r));
        }
        return rMap;
    }

    private CompositeMap getNewRelationMap(Relation r) {
        CompositeMap map = this.newCompositeMap("relation");
        map.put((Object)"name", (Object)r.getName());
        map.put((Object)"refModel", (Object)r.getRefTable());
        map.put((Object)"joinType", (Object)r.getJoinType());
        map.put((Object)"refAlias", (Object)this.getRefAlias(r));
        CompositeMap m = this.newCompositeMap("reference");
        m.put((Object)"localField", (Object)ModelUtil.getLocalFieldName(this.model, r.getLocalField()));
        m.put((Object)"foreignField", (Object)ModelUtil.getForeignFieldName(this.file.getProject(), r.getSrcField(), r.getRefTable()));
        map.addChild(m);
        return map;
    }

    private String getRefAlias(Relation r) {
        char c = this.seqRefAlias;
        this.seqRefAlias = (char)(c + '\u0001');
        return Character.toString(c);
    }

    protected void setUpModelMap(CompositeMap map) throws DuplicateException {
        map.put((Object)"title", (Object)this.model.getTitle());
        Record r = this.model.getDefaultDisplayRecord();
        if (r != null) {
            map.put((Object)"defaultDisplayField", (Object)r.getName());
        }
        map.addChild(this.genFieldsMap());
        map.addChild(this.genPkMap());
        map.addChild(this.genFeatureMap());
        map.addChild(this.genRelationMap());
        this.genQueryFieldsMap(map);
    }

    protected void genQueryFieldsMap(CompositeMap modelMap) {
        String refAlias = modelMap.getString((Object)"alias");
        refAlias = refAlias == null || refAlias.length() == 0 ? "" : String.valueOf(refAlias) + ".";
        CompositeMap qfMap = this.genQueryFieldMap(refAlias);
        if (qfMap.getChildsNotNull().size() > 0) {
            modelMap.addChild(qfMap);
        }
    }

    private CompositeMap genQueryFieldMap(String refAlias) {
        Record[] qfs;
        CompositeMap qfMap = this.newCompositeMap("query-fields");
        Record[] recordArray = qfs = this.model.getRecords(true);
        int n = qfs.length;
        int n2 = 0;
        while (n2 < n) {
            Record r = recordArray[n2];
            if (r.getBoolean("queryfield")) {
                String qt = r.getStringNotNull("query_op");
                String field = r.getName();
                if (qt.equals("=") || qt.equals("like")) {
                    qfMap.addChild(this.operatorQueryField(r.getName(), qt));
                } else if (qt.equals(">") || qt.equals("<") || qt.equals(">=") || qt.equals("<=")) {
                    qfMap.addChild(this.simpleQueryField(field, field, qt, refAlias, r.getType()));
                } else if (qt.equals(IDesignerConst.OP_INTERVAL)) {
                    qfMap.addChild(this.simpleQueryField(field, String.valueOf(field) + "_from", ">=", refAlias, r.getType()));
                    qfMap.addChild(this.simpleQueryField(field, String.valueOf(field) + "_to", "<=", refAlias, r.getType()));
                } else if (IDesignerConst.OP_ANY_MATCH.equals(qt) || IDesignerConst.OP_PRE_MATCH.equals(qt) || IDesignerConst.OP_END_MATCH.equals(qt)) {
                    qfMap.addChild(this.matchQueryField(field, qt));
                }
            }
            ++n2;
        }
        return qfMap;
    }

    private CompositeMap operatorQueryField(String field, String op) {
        CompositeMap q = this.newCompositeMap("query-field");
        q.put((Object)"field", (Object)field);
        q.put((Object)"queryOperator", (Object)op);
        return q;
    }

    private CompositeMap simpleQueryField(String field, String paraName, String op, String refAlias_, String type) {
        CompositeMap q = this.newCompositeMap("query-field");
        q.put((Object)"name", (Object)paraName);
        DataType dt = DataType.fromString(type);
        if (dt != null) {
            q.put((Object)"dataType", (Object)dt.getJavaType());
        }
        q.put((Object)"queryExpression", (Object)(String.valueOf(refAlias_) + field + " " + op + " ${/parameter/@" + paraName + "}"));
        return q;
    }

    private CompositeMap matchQueryField(String field, String matchType) {
        CompositeMap map = this.newCompositeMap("query-field");
        map.put((Object)"name", (Object)field);
        String para = "${/parameter/@" + field + "}";
        String matchStr = "";
        matchStr = IDesignerConst.OP_PRE_MATCH.equals(matchType) ? String.valueOf(para) + "||'%'" : (IDesignerConst.OP_END_MATCH.equals(matchType) ? "'%'||" + para : "'$'||" + para + "||'%'");
        map.put((Object)"queryExpression", (Object)(String.valueOf(field) + " like " + matchStr));
        return map;
    }
}

