/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer.editor;

import aurora.ide.AuroraPlugin;
import aurora.ide.builder.ResourceUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.gef.designer.BMCompositeMap;
import aurora.ide.meta.gef.designer.DataType;
import aurora.ide.meta.gef.designer.DesignerMessages;
import aurora.ide.meta.gef.designer.IDesignerConst;
import aurora.ide.meta.gef.designer.editor.BMModelContentProvider;
import aurora.ide.meta.gef.designer.editor.BMModelLabelProvider;
import aurora.ide.meta.gef.designer.editor.BmFieldContentProvider;
import aurora.ide.meta.gef.designer.editor.BmFieldLabelProvider;
import aurora.ide.meta.gef.designer.model.BMModel;
import aurora.ide.meta.gef.designer.model.Record;
import aurora.ide.meta.gef.designer.model.Relation;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import aurora.ide.meta.gef.editors.property.ResourceSelector;
import aurora.ide.meta.gef.editors.source.gen.DataSetFieldUtil;
import aurora.ide.meta.project.AuroraMetaProject;
import aurora.ide.search.core.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import uncertain.composite.CompositeMap;

public class RelationEditDialog
extends Dialog
implements SelectionListener {
    private Text text_relname;
    private Text text_refmodel;
    private BMModel model;
    private Relation relation;
    private Combo com_jointype;
    private AuroraMetaProject amproj;
    private IProject metaProject;
    private IProject auroraProject;
    private ComboViewer bmFieldComboViewer;
    private ComboViewer localFieldComboViewer;
    private ArrayList<CompositeMap> bmfieldList = null;
    private ArrayList<CompositeMap> refFieldList = new ArrayList();
    private ListViewer bmFieldListViewer;
    private ListViewer refFieldListViewer;
    private String refTablePkName = "";
    public List<CompositeMap> bmFieldWithoutPkList = new ArrayList<CompositeMap>();

    public RelationEditDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setModel(BMModel model) {
        this.model = model;
    }

    public void setRelation(Relation rel) {
        this.relation = rel;
    }

    public Relation getRelation() {
        return this.relation;
    }

    private void beforeCreate() {
        if (this.relation == null) {
            this.getShell().setText(DesignerMessages.RelationEditDialog_0);
            this.relation = new Relation();
        } else {
            this.getShell().setText(DesignerMessages.RelationEditDialog_1);
        }
        this.metaProject = AuroraPlugin.getActiveIFile().getProject();
        this.amproj = new AuroraMetaProject(this.metaProject);
        try {
            this.auroraProject = this.amproj.getAuroraProject();
        }
        catch (ResourceNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.beforeCreate();
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)container.getLayout();
        gridLayout.numColumns = 3;
        Label label = new Label(container, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label.setText(DesignerMessages.RelationEditDialog_2);
        this.text_relname = new Text(container, 2048);
        this.text_relname.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.text_relname.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Relation[] rels = RelationEditDialog.this.model.getRelations();
                String newName = RelationEditDialog.this.text_relname.getText();
                Button b = RelationEditDialog.this.getButton(9);
                boolean exists = false;
                Relation[] relationArray = rels;
                int n = rels.length;
                int n2 = 0;
                while (n2 < n) {
                    Relation r = relationArray[n2];
                    if (r != RelationEditDialog.this.relation && r.getName().equals(newName)) {
                        exists = true;
                        break;
                    }
                    ++n2;
                }
                if (b != null) {
                    b.setEnabled(!exists);
                }
                RelationEditDialog.this.text_relname.setBackground((Color)(exists ? ColorConstants.WRONG_COLOR : null));
                RelationEditDialog.this.text_relname.setToolTipText(exists ? "Relation name is already used." : null);
            }
        });
        this.text_relname.setText(this.relation.getName());
        new Label(container, 0);
        Label label_1 = new Label(container, 0);
        label_1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label_1.setText(DesignerMessages.RelationEditDialog_3);
        this.text_refmodel = new Text(container, 2056){

            public void setText(String str) {
                if (str.equals(this.getText())) {
                    return;
                }
                super.setText(str);
            }

            protected void checkSubclass() {
            }
        };
        this.text_refmodel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.text_refmodel.addModifyListener((ModifyListener)new RefModelModifyListener());
        Button btnNewButton = new Button(container, 0);
        btnNewButton.addSelectionListener((SelectionListener)new BmSelectListener());
        btnNewButton.setText(DesignerMessages.RelationEditDialog_4);
        Label lblNewLabel = new Label(container, 0);
        lblNewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel.setText(DesignerMessages.RelationEditDialog_5);
        this.localFieldComboViewer = new ComboViewer(container, 8);
        Combo combo_1 = this.localFieldComboViewer.getCombo();
        this.localFieldComboViewer.setContentProvider((IContentProvider)new BMModelContentProvider(0));
        this.localFieldComboViewer.setLabelProvider((IBaseLabelProvider)new BMModelLabelProvider(0));
        combo_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.localFieldComboViewer.setInput((Object)this.model);
        Record[] rs = this.model.getRecords();
        int i = 0;
        while (i < rs.length) {
            if (rs[i].getPrompt().equals(this.relation.getLocalField())) {
                combo_1.select(i);
                break;
            }
            ++i;
        }
        this.localFieldComboViewer.addSelectionChangedListener((ISelectionChangedListener)new LocalFieldChangeListener());
        new Label(container, 0);
        Label lblNewLabel_1 = new Label(container, 0);
        lblNewLabel_1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel_1.setText(DesignerMessages.RelationEditDialog_6);
        this.bmFieldComboViewer = new ComboViewer(container, 8);
        Combo combo = this.bmFieldComboViewer.getCombo();
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.bmFieldComboViewer.setContentProvider((IContentProvider)new BmFieldContentProvider());
        this.bmFieldComboViewer.setLabelProvider((IBaseLabelProvider)new BmFieldLabelProvider());
        this.text_refmodel.setText(this.relation.getRefTable());
        new Label(container, 0);
        Label lblNewLabel_2 = new Label(container, 0);
        lblNewLabel_2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel_2.setText(DesignerMessages.RelationEditDialog_7);
        this.com_jointype = new Combo(container, 8);
        this.com_jointype.setItems(IDesignerConst.JOIN_TYPES);
        this.com_jointype.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        int idx = Arrays.asList(IDesignerConst.JOIN_TYPES).indexOf(this.relation.getJoinType());
        this.com_jointype.select(idx == -1 ? 0 : idx);
        new Label(container, 0);
        this.createRefFieldGroup(container);
        return container;
    }

    private void createRefFieldGroup(Composite container) {
        Group composite = new Group(container, 0);
        composite.setText(DesignerMessages.RelationEditDialog_13);
        GridLayout gl_composite = new GridLayout(3, false);
        gl_composite.verticalSpacing = 0;
        gl_composite.marginHeight = 0;
        gl_composite.horizontalSpacing = 0;
        composite.setLayout((Layout)gl_composite);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        Label label_2 = new Label((Composite)composite, 0);
        label_2.setText(DesignerMessages.RelationEditDialog_14);
        new Label((Composite)composite, 0);
        Label label_3 = new Label((Composite)composite, 0);
        label_3.setText(DesignerMessages.RelationEditDialog_15);
        this.bmFieldListViewer = new ListViewer((Composite)composite, 2562);
        this.bmFieldListViewer.setContentProvider((IContentProvider)new BmFieldContentProvider());
        this.bmFieldListViewer.setLabelProvider((IBaseLabelProvider)new BmFieldLabelProvider());
        this.bmFieldListViewer.setInput(this.bmFieldWithoutPkList);
        org.eclipse.swt.widgets.List list = this.bmFieldListViewer.getList();
        list.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createFieldOperateButtons((Composite)composite);
        this.refFieldListViewer = new ListViewer((Composite)composite, 2562);
        this.refFieldListViewer.setContentProvider((IContentProvider)new BmFieldContentProvider());
        this.refFieldListViewer.setLabelProvider((IBaseLabelProvider)new BmFieldLabelProvider());
        this.refFieldListViewer.setInput(this.refFieldList);
        org.eclipse.swt.widgets.List list_1 = this.refFieldListViewer.getList();
        list_1.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
    }

    private void createFieldOperateButtons(Composite composite) {
        Composite composite_1 = new Composite(composite, 0);
        composite_1.setLayoutData((Object)new GridData(16384, 0x1000000, false, true, 1, 1));
        GridLayout gl_composite_1 = new GridLayout(1, false);
        gl_composite_1.marginHeight = 0;
        gl_composite_1.verticalSpacing = 0;
        gl_composite_1.marginWidth = 0;
        gl_composite_1.horizontalSpacing = 0;
        composite_1.setLayout((Layout)gl_composite_1);
        Button button = new Button(composite_1, 0);
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        button.addSelectionListener((SelectionListener)new FieldOperationListener(2));
        button.setText(DesignerMessages.RelationEditDialog_16);
        Button button_1 = new Button(composite_1, 0);
        button_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        button_1.addSelectionListener((SelectionListener)new FieldOperationListener(4));
        button_1.setText(DesignerMessages.RelationEditDialog_17);
        Button button_2 = new Button(composite_1, 0);
        button_2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        button_2.addSelectionListener((SelectionListener)new FieldOperationListener(8));
        button_2.setText(DesignerMessages.RelationEditDialog_18);
        Button button_3 = new Button(composite_1, 0);
        button_3.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        button_3.addSelectionListener((SelectionListener)new FieldOperationListener(16));
        button_3.setText(DesignerMessages.RelationEditDialog_19);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 9, IDialogConstants.OK_LABEL, false);
        button.addSelectionListener((SelectionListener)this);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void widgetSelected(SelectionEvent e) {
        this.relation.setName(this.text_relname.getText());
        this.relation.setRefTable(this.text_refmodel.getText());
        Record r = this.getSelectedLocalField();
        this.relation.setLocalField(r == null ? "" : r.getPrompt());
        CompositeMap forMap = this.getSelectedForeignField();
        if (forMap != null) {
            this.updateLocalRecord(forMap);
            String prompt = forMap.getString((Object)"prompt");
            this.relation.setSrcField(prompt == null ? "" : prompt);
        } else {
            this.relation.setSrcField("");
        }
        int idx = this.com_jointype.getSelectionIndex();
        this.relation.setJoinType(this.com_jointype.getItem(idx == -1 ? 0 : idx));
        String[] refps = new String[this.refFieldList.size()];
        int i = 0;
        while (i < refps.length) {
            refps[i] = this.refFieldList.get(i).getString((Object)"prompt");
            ++i;
        }
        this.relation.setRefPromptsArray(refps);
        this.setReturnCode(0);
        this.close();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    private void updateLocalRecord(CompositeMap forMap) {
        Record rec = this.model.getRecordByPrompt(this.relation.getLocalField());
        if (rec == null) {
            return;
        }
        String fpk = forMap.getString((Object)"name");
        boolean isForeign = this.refTablePkName.equals(fpk);
        rec.put("foreign", isForeign);
        if (isForeign) {
            if (!this.model.getPkRecord().getName().equals(fpk)) {
                Record r = this.model.getRecordByName(fpk);
                if (r == null || r == rec) {
                    rec.setName(fpk);
                } else {
                    int suf = 0;
                    while (r != null && r != rec) {
                        r = this.model.getRecordByName(String.valueOf(fpk) + ++suf);
                    }
                    rec.setName(String.valueOf(fpk) + suf);
                }
            }
            rec.setType(DataType.BIGNIT.getDisplayType());
            rec.setEditor("comboBox");
            rec.setOptions(this.relation.getRefTable());
        }
    }

    private Record getSelectedLocalField() {
        ISelection s = this.localFieldComboViewer.getSelection();
        if (s instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)s;
            return (Record)ss.getFirstElement();
        }
        return null;
    }

    private CompositeMap getSelectedForeignField() {
        ISelection s = this.bmFieldComboViewer.getSelection();
        if (s instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)s;
            return (CompositeMap)ss.getFirstElement();
        }
        return null;
    }

    protected Point getInitialSize() {
        return new Point(430, 450);
    }

    private final class BmSelectListener
    extends SelectionAdapter {
        private BmSelectListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (RelationEditDialog.this.auroraProject == null) {
                return;
            }
            ResourceSelector rs = new ResourceSelector(RelationEditDialog.this.getShell());
            rs.setExtFilter(new String[]{"bm"});
            String bmHome = ResourceUtil.getBMHome((IProject)RelationEditDialog.this.auroraProject);
            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(bmHome));
            rs.setInput((IContainer)folder);
            IResource res = rs.getSelection();
            if (res instanceof IFile) {
                RelationEditDialog.this.text_refmodel.setText(Util.toBMPKG((IFile)((IFile)res)));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FieldOperationListener
    extends SelectionAdapter {
        final int op_add_all = 2;
        final int op_add_selection = 4;
        final int op_del_selection = 8;
        final int op_del_all = 16;
        int op;

        public FieldOperationListener(int op) {
            this.op = op;
        }

        public void widgetSelected(SelectionEvent e) {
            List<CompositeMap> als = this.getOpList();
            this.getDstList().addAll(als);
            this.getSrcList().removeAll(als);
            RelationEditDialog.this.bmFieldListViewer.refresh();
            RelationEditDialog.this.refFieldListViewer.refresh();
        }

        ArrayList<CompositeMap> getSrcList() {
            if (this.op == 2 || this.op == 4) {
                return (ArrayList)RelationEditDialog.this.bmFieldListViewer.getInput();
            }
            return RelationEditDialog.this.refFieldList;
        }

        ArrayList<CompositeMap> getDstList() {
            if (this.op == 2 || this.op == 4) {
                return RelationEditDialog.this.refFieldList;
            }
            return (ArrayList)RelationEditDialog.this.bmFieldListViewer.getInput();
        }

        List<CompositeMap> getOpList() {
            if (this.op == 2 || this.op == 16) {
                return this.getSrcList();
            }
            ISelection s = (this.op == 4 ? RelationEditDialog.this.bmFieldListViewer : RelationEditDialog.this.refFieldListViewer).getSelection();
            return ((IStructuredSelection)s).toList();
        }
    }

    private final class LocalFieldChangeListener
    implements ISelectionChangedListener {
        private LocalFieldChangeListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            boolean change;
            Record r = RelationEditDialog.this.getSelectedLocalField();
            if (r == null) {
                return;
            }
            String relname = RelationEditDialog.this.text_relname.getText();
            boolean bl = change = relname.length() == 0;
            if (!change) {
                for (Record rr : RelationEditDialog.this.model.getRecordList()) {
                    if (!relname.equals("rel_" + rr.getName())) continue;
                    change = true;
                    break;
                }
            }
            if (change) {
                RelationEditDialog.this.text_relname.setText("rel_" + r.getName());
            }
        }
    }

    private final class RefModelModifyListener
    implements ModifyListener {
        private RefModelModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            try {
                String bmPkg = RelationEditDialog.this.text_refmodel.getText();
                if (bmPkg.length() == 0) {
                    return;
                }
                DataSetFieldUtil dsfu = new DataSetFieldUtil(RelationEditDialog.this.metaProject, "", bmPkg);
                CompositeMap bmMap = dsfu.getBmMap();
                if (bmMap == null) {
                    DialogUtil.showErrorMessageBox((String)("bm :" + bmPkg + ", has syntax error."));
                    return;
                }
                BMCompositeMap bmc = new BMCompositeMap(bmMap);
                RelationEditDialog.this.bmfieldList = new ArrayList<CompositeMap>(bmc.getFields());
                RelationEditDialog.this.bmFieldWithoutPkList = bmc.getFieldsWithoutPk();
                RelationEditDialog.this.refTablePkName = bmc.getPkFieldName();
                RelationEditDialog.this.bmFieldComboViewer.setInput((Object)RelationEditDialog.this.bmfieldList);
                RelationEditDialog.this.refFieldList.clear();
                String[] refps = RelationEditDialog.this.relation.getRefPromptsArray();
                if (refps.length == 0) {
                    CompositeMap ddfMap = bmc.getDefaultDisplayField();
                    if (ddfMap != null) {
                        RelationEditDialog.this.bmFieldWithoutPkList.remove(ddfMap);
                        RelationEditDialog.this.refFieldList.add(ddfMap);
                    }
                } else {
                    String[] stringArray = refps;
                    int n = refps.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String refp = stringArray[n2];
                        CompositeMap m = bmc.getFieldByPrompt(refp);
                        if (m != null) {
                            RelationEditDialog.this.bmFieldWithoutPkList.remove(m);
                            RelationEditDialog.this.refFieldList.add(m);
                        }
                        ++n2;
                    }
                }
                if (RelationEditDialog.this.bmFieldListViewer != null) {
                    RelationEditDialog.this.bmFieldListViewer.setInput(RelationEditDialog.this.bmFieldWithoutPkList);
                }
                if (RelationEditDialog.this.refFieldListViewer != null) {
                    RelationEditDialog.this.refFieldListViewer.refresh();
                }
                String srcF = RelationEditDialog.this.relation.getSrcField();
                int pkIndex = -1;
                int i = 0;
                while (i < RelationEditDialog.this.bmfieldList.size()) {
                    String pmpt = ((CompositeMap)RelationEditDialog.this.bmfieldList.get(i)).getString((Object)"prompt");
                    String name = ((CompositeMap)RelationEditDialog.this.bmfieldList.get(i)).getString((Object)"name");
                    if (pmpt != null && pmpt.equals(srcF)) {
                        RelationEditDialog.this.bmFieldComboViewer.getCombo().select(i);
                        return;
                    }
                    if (name != null && name.equals(RelationEditDialog.this.refTablePkName)) {
                        pkIndex = i;
                    }
                    ++i;
                }
                RelationEditDialog.this.bmFieldComboViewer.getCombo().select(pkIndex);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }
}

