/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer.editor;

import aurora.ide.AuroraPlugin;
import aurora.ide.builder.ResourceUtil;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.gef.designer.editor.LookupCodeDialog;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import aurora.ide.meta.gef.editors.property.DialogCellEditor;
import aurora.ide.meta.gef.editors.property.ResourceSelector;
import aurora.ide.meta.project.AuroraMetaProject;
import aurora.ide.search.core.Util;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;

public class OptionsCellEditor
extends DialogCellEditor {
    public static final int BM = 0;
    public static final int CODE = 1;
    private int mode = 0;

    public OptionsCellEditor(Composite parent) {
        super(parent, 0);
    }

    public void setEnable(boolean enabled) {
        this.getButton().setEnabled(enabled);
    }

    public void setSelectionMode(int mode) {
        this.mode = mode;
        this.getLabel().setForeground(mode == 0 ? ColorConstants.black : ColorConstants.gray);
    }

    protected Object doGetValue() {
        String str = this.getLabel().getText();
        return str == null ? "" : str;
    }

    protected void doSetFocus() {
    }

    protected void doSetValue(Object value) {
        this.updateLabelText(value);
    }

    private void updateLabelText(Object o) {
        CLabel l = this.getLabel();
        if (o == null) {
            l.setText("");
            l.setToolTipText(null);
        } else {
            l.setText(o.toString());
            l.setToolTipText(o.toString());
        }
    }

    protected void showDialog() {
        if (this.mode == 1) {
            LookupCodeDialog d = new LookupCodeDialog(this.getLabel().getShell());
            d.setValue(this.getLabel().getText());
            d.setBlockOnOpen(true);
            if (d.open() == 0) {
                this.updateLabelText(d.getValue());
                this.fireApplyEditorValue();
            }
            return;
        }
        IFile file = AuroraPlugin.getActiveIFile();
        if (file != null) {
            AuroraMetaProject amp = new AuroraMetaProject(file.getProject());
            try {
                IProject proj = amp.getAuroraProject();
                IFolder folder = ResourceUtil.getBMHomeFolder((IProject)proj);
                ResourceSelector rs = new ResourceSelector(this.getLabel().getShell());
                rs.setExtFilter(new String[]{"bm"});
                rs.setInput((IContainer)folder);
                IResource res = rs.getSelection();
                if (res instanceof IFile) {
                    String newValue = Util.toPKG((IPath)res.getFullPath().removeFileExtension());
                    this.updateLabelText(newValue);
                    this.fireApplyEditorValue();
                }
            }
            catch (ResourceNotFoundException e1) {
                e1.printStackTrace();
            }
        }
    }
}

