/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer.editor;

import aurora.ide.AuroraPlugin;
import aurora.ide.meta.gef.designer.DesignerMessages;
import aurora.ide.meta.gef.designer.editor.LookupCodeUtil;
import aurora.ide.meta.gef.designer.editor.LookupCodeViewer;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import uncertain.composite.CompositeMap;

public class LookupCodeDialog
extends Dialog
implements SelectionListener,
ISelectionChangedListener,
MouseListener {
    private Text text;
    private String value;
    CompositeMap codemap;
    String errorMessage = null;
    private Tree tree;
    private LookupCodeViewer treeViewer;

    public LookupCodeDialog(Shell parentShell) {
        super(parentShell);
        IFile file = AuroraPlugin.getActiveIFile();
        if (file != null) {
            try {
                this.codemap = LookupCodeUtil.load(file.getProject());
            }
            catch (Exception e) {
                this.errorMessage = e.getMessage();
            }
        }
    }

    public Control createDialogArea(Composite parent) {
        parent.getShell().setText(DesignerMessages.LookupCodeDialog_2);
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblLookupcode = new Label(container, 0);
        lblLookupcode.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblLookupcode.setText(DesignerMessages.LookupCodeDialog_1);
        this.text = new Text(container, 2048);
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.text != null) {
                    e.text = e.text.toUpperCase();
                }
                e.character = Character.toUpperCase(e.character);
            }
        });
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.value != null) {
            this.text.setText(this.value);
        }
        Label lblcode = new Label(container, 0);
        lblcode.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblcode.setText(DesignerMessages.LookupCodeDialog_0);
        if (this.errorMessage != null) {
            Text errText = new Text(container, 10);
            errText.setText(this.errorMessage);
            errText.setForeground(ColorConstants.red);
            errText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        } else {
            this.treeViewer = new LookupCodeViewer(container, 2564);
            this.tree = this.treeViewer.getTree();
            this.tree.addMouseListener((MouseListener)this);
            this.tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            this.treeViewer.setInput(this.codemap);
            this.treeViewer.select(this.value);
            this.treeViewer.addSelectionChangedListener(this);
        }
        this.text.selectAll();
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button btn = this.createButton(parent, 9, IDialogConstants.OK_LABEL, true);
        btn.addSelectionListener((SelectionListener)this);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    public void setValue(String value) {
        if (value == null || value.indexOf(46) != -1 || !value.toUpperCase().equals(value)) {
            return;
        }
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void widgetSelected(SelectionEvent e) {
        this.performFinish();
    }

    private void performFinish() {
        this.value = this.text.getText().toUpperCase();
        this.setReturnCode(0);
        this.close();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection sel = event.getSelection();
        if (sel instanceof IStructuredSelection) {
            Object m = ((IStructuredSelection)sel).getFirstElement();
            if ((m = LookupCodeUtil.getCodeRoot(m)) != null) {
                this.text.setText(LookupCodeUtil.getCode(m));
            }
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        TreeItem ti = this.tree.getItem(new Point(e.x, e.y));
        if (ti != null) {
            this.performFinish();
        }
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }
}

