/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer.editor;

import aurora.ide.meta.gef.designer.DesignerMessages;
import aurora.ide.meta.gef.designer.IDesignerConst;
import aurora.ide.meta.gef.designer.editor.BMModelCellModifier;
import aurora.ide.meta.gef.designer.editor.BMModelContentProvider;
import aurora.ide.meta.gef.designer.editor.BMModelLabelProvider;
import aurora.ide.meta.gef.designer.editor.ComboBoxCellEditor;
import aurora.ide.meta.gef.designer.editor.OptionsCellEditor;
import aurora.ide.meta.gef.designer.editor.RecordCellEditorListener;
import aurora.ide.meta.gef.designer.model.BMModel;
import aurora.ide.meta.gef.designer.model.ModelUtil;
import aurora.ide.meta.gef.designer.model.Record;
import aurora.ide.meta.gef.editors.property.BooleanCellEditor;
import aurora.ide.meta.gef.editors.property.StringCellEditor;
import aurora.plugin.source.gen.screen.model.Input;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class BMModelViewer
extends TableViewer
implements IDesignerConst {
    public static final String[] editor_types = Input.INPUT_TYPES;
    private HashMap<String, CellEditor> editorMap = new HashMap(1000);
    private HashMap<String, RecordCellEditorListener> editorListenerMap = new HashMap();

    public BMModelViewer(Composite parent) {
        super(parent);
        this.config();
    }

    public BMModelViewer(Composite parent, int style) {
        super(parent, style);
        this.config();
    }

    private void config() {
        Table table = this.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn zColumn = new TableColumn(table, 0);
        zColumn.setResizable(false);
        zColumn.setWidth(0);
        TableColumn column = new TableColumn(table, 0x1000000);
        column.setText(DesignerMessages.BMModelViewer_0);
        column.pack();
        column.setResizable(false);
        column = new TableColumn(table, 0);
        column.setText(DesignerMessages.BMModelViewer_1);
        column.setWidth(100);
        column = new TableColumn(table, 0);
        column.setText(DesignerMessages.BMModelViewer_2);
        column.setWidth(100);
        column = new TableColumn(table, 0);
        column.setText(DesignerMessages.BMModelViewer_3);
        column.setWidth(100);
        column = new TableColumn(table, 0);
        column.setText(DesignerMessages.BMModelViewer_4);
        column.setWidth(100);
        column = new TableColumn(table, 0);
        column.setText(DesignerMessages.BMModelViewer_5);
        column.pack();
        column = new TableColumn(table, 0);
        column.setText("Options");
        column.setWidth(100);
        this.setContentProvider((IContentProvider)new BMModelContentProvider(0));
        this.setLabelProvider((IBaseLabelProvider)new BMModelLabelProvider(0, TABLE_COLUMN_PROPERTIES));
        this.setCellModifier(new BMModelCellModifier(this, 0));
        this.setColumnProperties(TABLE_COLUMN_PROPERTIES);
        this.setCellEditors(this.getNewCellEditors(null));
    }

    public void refresh() {
        super.refresh();
        Table table = this.getTable();
        ArrayList<String> keys = new ArrayList<String>(this.editorMap.keySet());
        int r = 0;
        while (r < table.getItemCount()) {
            TableItem item = table.getItem(r);
            Record record = (Record)item.getData();
            CellEditor[] ces = this.getCellEditors();
            CellEditor[] newCes = null;
            int c = 0;
            while (c < ces.length) {
                if (ces[c] != null) {
                    String colpro = TABLE_COLUMN_PROPERTIES[c];
                    Object colval = record.get(colpro);
                    String key = String.valueOf(r) + "-" + c;
                    CellEditor ce = this.editorMap.get(key);
                    RecordCellEditorListener rcel = this.editorListenerMap.get(key);
                    if (!(ce == null || rcel.getCellEditor() == ce && rcel.getRecord() == record && rcel.getColumnProperty().equals(colpro))) {
                        this.disposeEditor(key);
                        ce = null;
                    }
                    if (ce == null) {
                        if (newCes == null) {
                            newCes = this.getNewCellEditors(record);
                        }
                        ce = newCes[c];
                        ce.setValue(colval);
                        this.setItemEditor(table, item, ce, r, c);
                        RecordCellEditorListener lis = new RecordCellEditorListener(record, colpro, ce);
                        ce.addListener((ICellEditorListener)lis);
                        this.editorMap.put(key, ce);
                        this.editorListenerMap.put(key, lis);
                    }
                    keys.remove(key);
                    this.updateOptionEditor(ce, record);
                    if (!ModelUtil.eq(ce.getValue(), colval)) {
                        ce.setValue(colval);
                    }
                }
                ++c;
            }
            ++r;
        }
        for (String key : keys) {
            this.disposeEditor(key);
        }
    }

    public void refresh(Record record) {
        super.refresh((Object)record);
        Table table = this.getTable();
        int r = 0;
        while (r < table.getItemCount()) {
            TableItem item = table.getItem(r);
            Record rec = (Record)item.getData();
            if (rec == record) {
                this.updateEditorOfRecord(rec, table, item, r);
                break;
            }
            ++r;
        }
    }

    private void updateEditorOfRecord(Record rec, Table table, TableItem item, int row) {
        CellEditor[] ces = this.getCellEditors();
        CellEditor[] newCes = null;
        int c = 0;
        while (c < ces.length) {
            if (ces[c] != null) {
                String colpro = TABLE_COLUMN_PROPERTIES[c];
                Object colval = rec.get(colpro);
                String key = String.valueOf(row) + "-" + c;
                CellEditor ce = this.editorMap.get(key);
                if (ce == null) {
                    if (newCes == null) {
                        newCes = this.getNewCellEditors(rec);
                    }
                    ce = newCes[c];
                    ce.setValue(colval);
                    ce.addListener((ICellEditorListener)new RecordCellEditorListener(rec, colpro, ce));
                    this.editorMap.put(key, ce);
                    this.setItemEditor(table, item, ce, row, c);
                }
                this.updateOptionEditor(ce, rec);
                if (!ModelUtil.eq(colval, ce.getValue())) {
                    ce.setValue(colval);
                }
            }
            ++c;
        }
    }

    public void disposeEditor(int row) {
        Table table = this.getTable();
        int c = 0;
        while (c < table.getColumnCount()) {
            String key = String.valueOf(row) + "-" + c;
            this.disposeEditor(key);
            ++c;
        }
    }

    private void disposeEditor(String key) {
        CellEditor ce = this.editorMap.get(key);
        if (ce != null) {
            ce.deactivate();
            ce.dispose();
            this.editorMap.put(key, null);
            this.editorListenerMap.put(key, null);
        }
    }

    private void updateOptionEditor(CellEditor ce, Record rec) {
        if (ce instanceof OptionsCellEditor) {
            boolean needOptions = "lookupCode".equals(rec.getType());
            ((OptionsCellEditor)ce).setSelectionMode(needOptions ? 1 : 0);
            if (needOptions) {
                rec.setEditor("comboBox");
            }
            if (!needOptions) {
                needOptions = rec.getEditor().equals("comboBox");
            }
            if (!needOptions) {
                needOptions = rec.getEditor().equals("lov");
            }
            ((OptionsCellEditor)ce).setEnable(needOptions);
        }
    }

    private void setItemEditor(Table table, TableItem item, CellEditor ce, int r, int c) {
        TableEditor te = new TableEditor(table);
        te.horizontalAlignment = 16384;
        te.grabHorizontal = true;
        Control ctrl = ce.getControl();
        ctrl.addKeyListener((KeyListener)new FocusMoveKeyListener(r, c));
        ctrl.addMouseListener((MouseListener)new AutoSelectListener(r, ctrl));
        te.setEditor(ctrl, item, c);
    }

    private CellEditor[] getNewCellEditors(Record record) {
        Table table = this.getTable();
        CellEditor[] cellEditorArray = new CellEditor[8];
        cellEditorArray[2] = new StringCellEditor((Composite)table);
        cellEditorArray[3] = new ComboBoxCellEditor((Composite)table, data_types);
        cellEditorArray[4] = new StringCellEditor((Composite)table);
        cellEditorArray[5] = new ComboBoxCellEditor((Composite)table, editor_types);
        cellEditorArray[6] = new BooleanCellEditor((Composite)table);
        cellEditorArray[7] = new OptionsCellEditor((Composite)table);
        return cellEditorArray;
    }

    private class AutoSelectListener
    implements MouseListener {
        private int row;

        public AutoSelectListener(int r, Control ctrl) {
            this.row = r;
            if (ctrl instanceof Composite) {
                this.updateListenerTree((Composite)ctrl);
            }
        }

        private void updateListenerTree(Composite com) {
            Control[] controlArray = com.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.addMouseListener((MouseListener)this);
                if (c instanceof Composite) {
                    this.updateListenerTree((Composite)c);
                }
                ++n2;
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            BMModel model;
            Object input = BMModelViewer.this.getInput();
            if (input instanceof BMModel && (model = (BMModel)input).getRecordList().size() > this.row) {
                Record r = model.getAt(this.row);
                BMModelViewer.this.setSelection((ISelection)new StructuredSelection((Object)r));
            }
        }

        public void mouseUp(MouseEvent e) {
        }
    }

    private class FocusMoveKeyListener
    extends KeyAdapter {
        int r;
        int c;

        public FocusMoveKeyListener(int r, int c) {
            this.r = r;
            this.c = c;
        }

        public void keyPressed(KeyEvent e) {
            int nextR;
            if (e.stateMask != 0 && e.stateMask != 131072) {
                return;
            }
            int n = nextR = e.stateMask == 0 ? this.r + 1 : this.r - 1;
            if (e.keyCode == 13) {
                String nextKey = String.format("%d-%d", nextR, this.c);
                CellEditor ce = (CellEditor)BMModelViewer.this.editorMap.get(nextKey);
                if (ce == null) {
                    return;
                }
                Control ctrl = ce.getControl();
                ctrl.forceFocus();
                BMModelViewer.this.setSelection((ISelection)new StructuredSelection(BMModelViewer.this.getTable().getItem(nextR).getData()));
                if (ctrl instanceof Text) {
                    ((Text)ctrl).selectAll();
                }
            }
        }
    }
}

