/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer;

import aurora.ide.helpers.DialogUtil;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.gef.designer.IDesignerConst;
import aurora.ide.meta.gef.designer.model.ModelMerger;
import aurora.ide.meta.gef.editors.PrototypeImagesUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class OpenBMAction
extends Action {
    private IFile bmqFile;
    private IWorkbenchPage page;
    private IFile baseBMFile;

    public OpenBMAction(IFile bmqFile, IWorkbenchPage page) {
        super("Open BM", 4);
        this.setImageDescriptor(PrototypeImagesUtils.getImageDescriptor("folder.png"));
        this.bmqFile = bmqFile;
        this.page = page;
    }

    public IMenuCreator getMenuCreator() {
        return new OpenBmMenuCreator();
    }

    public void run() {
        try {
            this.openFile(this.getFile(""));
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void openFile(IFile bmFile) {
        if (bmFile == null || !bmFile.exists()) {
            DialogUtil.showWarningMessageBox((String)"Related file does not exists.");
            return;
        }
        try {
            IWorkbenchPage page = this.getPage();
            IDE.openEditor((IWorkbenchPage)page, (IFile)bmFile, (String)"aurora.ide.BusinessModelEditor", (boolean)true);
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
    }

    public IWorkbenchPage getPage() {
        return this.page;
    }

    private IFile getFile(String sufix) throws ResourceNotFoundException {
        ModelMerger merger = new ModelMerger(this.bmqFile);
        this.baseBMFile = merger.getBMFile();
        IPath fullpath = this.baseBMFile.getFullPath();
        Path newPath = new Path(String.valueOf(fullpath.removeFileExtension().toString()) + sufix + ".bm");
        IFile f = this.baseBMFile.getProject().getParent().getFile((IPath)newPath);
        return f;
    }

    class OpenBmMenuCreator
    implements IMenuCreator,
    SelectionListener {
        OpenBmMenuCreator() {
        }

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            Menu menu = new Menu(parent);
            this.fillMenu(menu);
            return menu;
        }

        public void fillMenu(Menu menu) {
            String[] stringArray = IDesignerConst.AE_TYPES;
            int n = IDesignerConst.AE_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                MenuItem mi = new MenuItem(menu, 0);
                mi.setText("Open for " + s + " BM");
                mi.setData((Object)s);
                mi.addSelectionListener((SelectionListener)this);
                ++n2;
            }
        }

        public Menu getMenu(Menu parent) {
            Menu menu = new Menu(parent);
            this.fillMenu(menu);
            return menu;
        }

        public void widgetSelected(SelectionEvent e) {
            MenuItem mi = (MenuItem)e.getSource();
            String s = (String)mi.getData();
            try {
                OpenBMAction.this.openFile(OpenBMAction.this.getFile("_for_" + s));
            }
            catch (ResourceNotFoundException e1) {
                e1.printStackTrace();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

