/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer;

import aurora.ide.meta.gef.designer.BMCompositeMap;
import aurora.ide.meta.gef.designer.DataType;
import aurora.ide.meta.gef.designer.DesignerMessages;
import aurora.ide.meta.gef.designer.IDesignerConst;
import aurora.ide.meta.gef.designer.model.Record;
import java.util.ArrayList;
import uncertain.composite.CompositeMap;

public class DesignerUtil
implements IDesignerConst {
    public static final ArrayList<Object[]> typeMap = new ArrayList();

    static {
        typeMap.add(new Object[]{DesignerMessages.DesignerUtil_0, DataType.INTEGER});
        typeMap.add(new Object[]{DesignerMessages.DesignerUtil_1, DataType.FLOAT});
        typeMap.add(new Object[]{DesignerMessages.DesignerUtil_2, DataType.DATE});
        typeMap.add(new Object[]{DesignerMessages.DesignerUtil_3, DataType.DATE_TIME});
        typeMap.add(new Object[]{DesignerMessages.DesignerUtil_4, DataType.LONG_TEXT});
        typeMap.add(new Object[]{DesignerMessages.DesignerUtil_5, DataType.LOOPUPCODE});
        typeMap.add(new Object[]{".*", DataType.TEXT});
    }

    public static Record createRecord(String prompt) {
        Record r = new Record();
        r.put("prompt", prompt);
        DataType dt = DataType.TEXT;
        for (Object[] ss : typeMap) {
            if (!prompt.matches((String)ss[0])) continue;
            dt = (DataType)((Object)ss[1]);
            break;
        }
        r.put("name", "");
        r.put("type", dt.getDisplayType());
        r.put("editor", dt.getDefaultEditor());
        r.put("query_op", dt.getDefaultOperator());
        r.put("queryfield", false);
        r.put("foreign", false);
        r.setForInsert(true);
        r.setForUpdate(true);
        return r;
    }

    public static Record createRecord(CompositeMap bmField) {
        Record r = new Record();
        r.setName(bmField.getString((Object)"name"));
        String pt = bmField.getString((Object)"prompt");
        if (pt != null) {
            r.setPrompt(pt);
        }
        DataType type = DataType.TEXT;
        String datatype = BMCompositeMap.getMapAttribute(bmField, "datatype");
        if ("java.util.Date".equals(datatype)) {
            type = DataType.DATE;
        }
        DataType[] dataTypeArray = DataType.values();
        int n = dataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataType dt = dataTypeArray[n2];
            if (dt.getJavaType().equals(datatype)) {
                type = dt;
                break;
            }
            ++n2;
        }
        r.put("type", type.getDisplayType());
        r.put("editor", type.getDefaultEditor());
        r.put("query_op", type.getDefaultOperator());
        r.put("queryfield", false);
        r.put("foreign", false);
        r.setForInsert(true);
        r.setForUpdate(true);
        return r;
    }
}

