/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer;

import aurora.ide.helpers.StatusUtil;
import aurora.ide.meta.gef.designer.BMDesigner;
import aurora.ide.meta.gef.designer.DesignerMessages;
import aurora.ide.meta.gef.designer.DesignerUtil;
import aurora.ide.meta.gef.designer.ImportFieldAction;
import aurora.ide.meta.gef.designer.OpenBMAction;
import aurora.ide.meta.gef.designer.SettingAction;
import aurora.ide.meta.gef.designer.editor.BMModelContentProvider;
import aurora.ide.meta.gef.designer.editor.BMModelLabelProvider;
import aurora.ide.meta.gef.designer.editor.BMModelViewer;
import aurora.ide.meta.gef.designer.editor.RelationEditDialog;
import aurora.ide.meta.gef.designer.editor.RelationViewer;
import aurora.ide.meta.gef.designer.model.BMModel;
import aurora.ide.meta.gef.designer.model.Record;
import aurora.ide.meta.gef.designer.model.RecordPropertyChangeEvent;
import aurora.ide.meta.gef.designer.model.Relation;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class BMDesignPage
extends FormPage
implements PropertyChangeListener,
IResourceChangeListener,
IResourceDeltaVisitor {
    private Text quickAddText;
    private BMModel model;
    private BMModelViewer viewer;
    private Button btnNew;
    private Button btnUp;
    private Button btnDown;
    private Button btnDel;
    private Button btnClear;
    private boolean isDirty = false;
    private Text titleText;
    private Button btnNewRelation;
    private Button btnEditRelation;
    private Button btnDelRelation;
    private RelationViewer relationViewer;
    private ComboViewer defaultDisplayViewer;
    private IMessageManager messageManager;
    private IFile inputFile;
    private static String error_msg_key = "builderror";

    public BMDesignPage(String id, String title) {
        super(id, title);
    }

    public BMDesignPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        this.messageManager = form.getForm().getMessageManager();
        form.setLayout((Layout)new FillLayout(256));
        this.messageManager.setAutoUpdate(true);
        if (this.model != null) {
            form.getForm().setText(this.model.getTitle());
        }
        toolkit.decorateFormHeading(form.getForm());
        this.createActions(form.getToolBarManager());
        Composite body = form.getBody();
        body.setLayout((Layout)new GridLayout(2, false));
        this.createTitleControl(body);
        this.createQuickInputControl(managedForm);
        SashForm sh = new SashForm(body, 512);
        sh.setBackground(body.getBackground());
        sh.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Composite com1 = new Composite((Composite)sh, 0);
        com1.setBackground(body.getBackground());
        com1.setLayout((Layout)new GridLayout(2, false));
        this.createMainTable(com1);
        Composite com2 = new Composite((Composite)sh, 0);
        com2.setBackground(body.getBackground());
        com2.setLayout((Layout)new GridLayout(2, false));
        this.createRelationTable(com2);
        new Label(com2, 0);
        sh.setWeights(new int[]{2, 1});
        this.handleMarker();
    }

    private void createActions(IToolBarManager toolBarManager) {
        BMDesigner designer = (BMDesigner)this.getEditor();
        toolBarManager.add((IAction)new ImportFieldAction(this.model, designer));
        toolBarManager.add((IAction)new OpenBMAction(designer.getInputFile(), designer.getSite().getPage()));
        toolBarManager.add((IAction)new SettingAction(this.model, (IWorkbenchPart)designer));
        toolBarManager.update(true);
    }

    private void createTitleControl(Composite body) {
        Composite com = new Composite(body, 0);
        com.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        com.setBackground(body.getBackground());
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.wrap = false;
        rowLayout.center = true;
        com.setLayout((Layout)rowLayout);
        new Label(body, 0);
        Label label = new Label(com, 0);
        label.setBackground(com.getBackground());
        label.setText(DesignerMessages.BMDesignPage_0);
        this.titleText = new Text(com, 2048);
        this.titleText.setLayoutData((Object)new RowData(200, -1));
        if (this.model != null) {
            this.titleText.setText(this.model.getTitle());
        }
        this.titleText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                BMDesignPage.this.model.setTitle(BMDesignPage.this.titleText.getText());
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.titleText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.character == '\r' || e.character == '\u1000050') {
                    BMDesignPage.this.model.setTitle(BMDesignPage.this.titleText.getText());
                }
            }
        });
        this.titleText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BMDesignPage.this.model.setTitle(BMDesignPage.this.titleText.getText());
            }
        });
        Label disLabel = new Label(com, 131072);
        disLabel.setBackground(com.getBackground());
        disLabel.setText("defaultDisplayField : ");
        disLabel.setLayoutData((Object)new RowData(200, -1));
        this.defaultDisplayViewer = new ComboViewer(com, 8);
        this.defaultDisplayViewer.setContentProvider((IContentProvider)new BMModelContentProvider(0));
        this.defaultDisplayViewer.setLabelProvider((IBaseLabelProvider)new BMModelLabelProvider(0));
        this.defaultDisplayViewer.getCombo().setLayoutData((Object)new RowData(120, -1));
        if (this.model != null) {
            this.defaultDisplayViewer.setInput((Object)this.model);
            Record r = this.model.getDefaultDisplayRecord();
            if (r != null) {
                this.defaultDisplayViewer.setSelection((ISelection)new StructuredSelection((Object)r));
            }
            this.defaultDisplayViewer.refresh();
        }
        this.defaultDisplayViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Record r;
                if (event.getSelection() instanceof IStructuredSelection && (r = (Record)((IStructuredSelection)event.getSelection()).getFirstElement()) != null) {
                    BMDesignPage.this.model.setDefaultDisplay(r.getPrompt());
                }
            }
        });
    }

    private void createQuickInputControl(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        this.quickAddText = new Text(body, 2048);
        this.quickAddText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.quickAddText.setMessage(DesignerMessages.BMDesignPage_1);
        this.quickAddText.setFont(new Font(null, this.quickAddText.getFont().getFontData()[0].getName(), 12, 0));
        toolkit.adapt((Control)this.quickAddText, true, true);
        this.btnNew = new Button(body, 0);
        this.btnNew.setFont(this.quickAddText.getFont());
        toolkit.adapt((Control)this.btnNew, true, true);
        this.btnNew.setText(DesignerMessages.BMDesignPage_2);
        this.btnNew.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BMDesignPage.this.createNewLine();
            }
        });
        this.quickAddText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.character == '\r' || e.character == '\u1000050') {
                    BMDesignPage.this.createNewLine();
                }
            }
        });
    }

    private void createMainTable(Composite body) {
        this.viewer = new BMModelViewer(body, 67586);
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 6));
        new Label(body, 0);
        this.btnUp = new Button(body, 0);
        this.btnUp.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnUp.setText(DesignerMessages.BMDesignPage_3);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int n = e.getSource() == BMDesignPage.this.btnUp ? -1 : 1;
                ISelection s = BMDesignPage.this.viewer.getSelection();
                if (s instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)s;
                    Record r = (Record)ss.getFirstElement();
                    int idx = BMDesignPage.this.model.indexOf(r);
                    BMDesignPage.this.viewer.disposeEditor(idx);
                    BMDesignPage.this.viewer.disposeEditor(idx + n);
                    BMDesignPage.this.model.swap(idx, idx + n);
                    BMDesignPage.this.btnUp.setEnabled(!BMDesignPage.this.model.isFirst(r));
                    BMDesignPage.this.btnDown.setEnabled(!BMDesignPage.this.model.isLast(r));
                    BMDesignPage.this.viewer.refresh();
                }
            }
        };
        this.btnUp.addSelectionListener((SelectionListener)listener);
        this.btnDown = new Button(body, 0);
        this.btnDown.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnDown.setText(DesignerMessages.BMDesignPage_4);
        this.btnDel = new Button(body, 0);
        this.btnDel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnDown.addSelectionListener((SelectionListener)listener);
        this.btnDel.setText(DesignerMessages.BMDesignPage_5);
        this.btnDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection s = BMDesignPage.this.viewer.getSelection();
                if (s instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)s;
                    List list = ss.toList();
                    BMDesignPage.this.model.remove(list);
                    BMDesignPage.this.viewer.refresh();
                }
            }
        });
        this.btnClear = new Button(body, 0);
        this.btnClear.setText(DesignerMessages.BMDesignPage_6);
        this.btnClear.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BMDesignPage.this.model.removeAll();
                BMDesignPage.this.viewer.refresh();
            }
        });
        this.btnDel.setEnabled(false);
        this.btnUp.setEnabled(false);
        this.btnDown.setEnabled(false);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection s = event.getSelection();
                if (s instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)s;
                    BMDesignPage.this.btnDel.setEnabled(!ss.isEmpty());
                    Object[] sels = ss.toArray();
                    if (sels.length == 1) {
                        Record r = (Record)sels[0];
                        BMDesignPage.this.btnUp.setEnabled(!BMDesignPage.this.model.isFirst(r));
                        BMDesignPage.this.btnDown.setEnabled(!BMDesignPage.this.model.isLast(r));
                    } else {
                        BMDesignPage.this.btnUp.setEnabled(false);
                        BMDesignPage.this.btnDown.setEnabled(false);
                    }
                }
            }
        });
        if (this.model != null) {
            this.viewer.setInput(this.model);
            this.viewer.refresh();
        }
        new Label(body, 0);
    }

    private void createRelationTable(Composite body) {
        this.relationViewer = new RelationViewer(body, 67586);
        final Table table = this.relationViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 5));
        new Label(body, 0);
        this.btnNewRelation = new Button(body, 0);
        this.btnNewRelation.setText(DesignerMessages.BMDesignPage_7);
        this.btnNewRelation.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnNewRelation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Relation newRel;
                RelationEditDialog red = new RelationEditDialog(table.getShell());
                red.setModel(BMDesignPage.this.model);
                if (red.open() == 0 && (newRel = red.getRelation()) != null) {
                    BMDesignPage.this.model.add(newRel);
                    BMDesignPage.this.relationViewer.refresh();
                    Record r = BMDesignPage.this.model.getRecordByPrompt(newRel.getLocalField());
                    if (r != null) {
                        BMDesignPage.this.viewer.refresh(r);
                    }
                }
            }
        });
        this.btnEditRelation = new Button(body, 0);
        this.btnEditRelation.setText(DesignerMessages.BMDesignPage_8);
        this.btnEditRelation.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnEditRelation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationEditDialog red = new RelationEditDialog(table.getShell());
                red.setModel(BMDesignPage.this.model);
                red.setRelation((Relation)table.getSelection()[0].getData());
                if (red.open() == 0) {
                    Relation rel = red.getRelation();
                    BMDesignPage.this.relationViewer.refresh();
                    Record r = BMDesignPage.this.model.getRecordByPrompt(rel.getLocalField());
                    if (r != null) {
                        BMDesignPage.this.viewer.refresh(r);
                    }
                }
            }
        });
        this.btnDelRelation = new Button(body, 0);
        this.btnDelRelation.setText(DesignerMessages.BMDesignPage_9);
        this.btnDelRelation.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnDelRelation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection s = BMDesignPage.this.relationViewer.getSelection();
                if (s instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)s;
                    BMDesignPage.this.model.removeRelations(ss.toList());
                    BMDesignPage.this.relationViewer.refresh();
                }
            }
        });
        this.btnEditRelation.setEnabled(false);
        this.btnDelRelation.setEnabled(false);
        this.relationViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection s = event.getSelection();
                if (s instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)s;
                    Object[] arr = ss.toArray();
                    BMDesignPage.this.btnEditRelation.setEnabled(arr.length == 1);
                    BMDesignPage.this.btnDelRelation.setEnabled(arr.length > 0);
                }
            }
        });
        if (this.model != null) {
            this.relationViewer.setInput(this.model);
            this.relationViewer.refresh();
        }
    }

    private void createNewLine() {
        boolean mod = false;
        String[] stringArray = this.quickAddText.getText().split(DesignerMessages.BMDesignPage_10);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.length() != 0) {
                Record r = DesignerUtil.createRecord(s);
                mod = true;
                this.model.add(r);
            }
            ++n2;
        }
        this.quickAddText.setText("");
        if (mod) {
            this.viewer.refresh();
        }
    }

    public void refreshRecordViewer() {
        this.viewer.refresh();
    }

    public void setModel(BMModel model) {
        this.model = model;
        model.removePropertyChangeListener(this);
        model.addPropertyChangeListener(this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException e) {
                StatusUtil.showExceptionDialog((Shell)this.getSite().getShell(), null, null, (boolean)false, (Throwable)e);
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (this.inputFile.equals((Object)delta.getResource())) {
            this.addRemoveMarker();
            return false;
        }
        return true;
    }

    private void handleMarker() {
        this.inputFile = ((BMDesigner)this.getEditor()).getInputFile();
        this.addRemoveMarker();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 16);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    void addRemoveMarker() {
        this.getSite().getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    IMarker[] markers = BMDesignPage.this.inputFile.findMarkers("aurora.ide.meta.builderror", false, 0);
                    if (markers.length > 0) {
                        IMarker m = markers[0];
                        String error = (String)m.getAttribute("message");
                        BMDesignPage.this.messageManager.addMessage((Object)error_msg_key, error, null, 3);
                    } else {
                        BMDesignPage.this.messageManager.removeMessage((Object)error_msg_key);
                    }
                }
                catch (CoreException e) {
                    StatusUtil.showExceptionDialog((Shell)BMDesignPage.this.getSite().getShell(), null, null, (boolean)true, (Throwable)e);
                }
            }
        });
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("structure_record")) {
            this.autoUpdateDisplayField();
            this.setDirty(true);
            return;
        }
        if (evt.getPropertyName().equals("title")) {
            this.getManagedForm().getForm().getForm().setText((String)evt.getNewValue());
        }
        if (evt instanceof RecordPropertyChangeEvent) {
            Record r = (Record)evt.getSource();
            Object old = evt.getOldValue();
            if (old != null && !old.equals("")) {
                this.viewer.refresh(r);
                if ("prompt".equals(evt.getPropertyName())) {
                    this.defaultDisplayViewer.refresh();
                }
            }
        }
        this.setDirty(true);
    }

    private void autoUpdateDisplayField() {
        ArrayList<Record> list = this.model.getRecordList();
        boolean needUpdate = list.size() > 0;
        for (Record r : list) {
            if (!r.getPrompt().equals(this.model.getDefaultDisplay())) continue;
            needUpdate = false;
            break;
        }
        this.defaultDisplayViewer.refresh();
        if (needUpdate) {
            this.defaultDisplayViewer.setSelection((ISelection)new StructuredSelection(list.get(0)));
        }
    }

    public BMModel getModel() {
        return this.model;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean d) {
        this.isDirty = d;
        this.getEditor().editorDirtyStateChanged();
    }
}

