/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer;

import aurora.ide.search.cache.CacheManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import uncertain.composite.CompositeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BMCompositeMap {
    private CompositeMap bmMap;
    private List<CompositeMap> queryFields;
    private List<CompositeMap> relations;
    private List<CompositeMap> primaryKeys;
    private List<CompositeMap> fields;
    private List<CompositeMap> refFields;
    private CompositeMap fieldsMap;
    private CompositeMap primaryKeyMap;
    private CompositeMap relationMap;
    private CompositeMap refFieldsMap;
    private CompositeMap queryFieldsMap;
    private CompositeMap firstPkField;
    private CompositeMap fieldOfPk;

    public BMCompositeMap(CompositeMap map) {
        if (map == null) {
            throw new NullPointerException("parameter can not be null.");
        }
        this.bmMap = map;
    }

    public BMCompositeMap(IFile bmFile) {
        try {
            this.bmMap = CacheManager.getCompositeMap((IFile)bmFile);
            if (this.bmMap.get((Object)"extend") != null) {
                this.bmMap = CacheManager.getWholeBMCompositeMap((IFile)bmFile);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CompositeMap getBmMap() {
        return this.bmMap;
    }

    public CompositeMap getFirstPkField() {
        List<CompositeMap> list;
        if (this.firstPkField == null && (list = this.getPrimaryKeys()).size() > 0) {
            this.firstPkField = list.get(0);
        }
        return this.firstPkField;
    }

    public CompositeMap getFieldOfPk() {
        if (this.fieldOfPk == null) {
            String pkn = this.getPkFieldName();
            if (pkn == null) {
                return null;
            }
            this.fieldOfPk = this.getFieldByName(pkn);
        }
        return this.fieldOfPk;
    }

    public String getPkFieldName() {
        CompositeMap pk = this.getFirstPkField();
        if (pk != null) {
            return pk.getString((Object)"name");
        }
        return null;
    }

    public CompositeMap getFieldByProperty(String property, String value) {
        return BMCompositeMap.getChildByProperty(this.getFieldsMap(), property, value);
    }

    public static CompositeMap getChildByProperty(CompositeMap parMap, String property, String value) {
        if (parMap == null || property == null) {
            return null;
        }
        List list = parMap.getChildsNotNull();
        for (CompositeMap m : list) {
            if (!BMCompositeMap.eq(BMCompositeMap.getMapAttribute(m, property), value)) continue;
            return m;
        }
        return null;
    }

    List<CompositeMap> getChild(CompositeMap map) {
        if (map == null) {
            return Collections.emptyList();
        }
        return map.getChildsNotNull();
    }

    public static String getMapAttribute(CompositeMap map, String property) {
        if (map == null) {
            throw new NullPointerException("parameter map can not be null.");
        }
        if (property == null) {
            return map.getString(null);
        }
        String value = map.getString((Object)property);
        if (value != null) {
            return value;
        }
        for (Object key : map.keySet()) {
            if (key == null || !property.equalsIgnoreCase(key.toString())) continue;
            return map.getString(key);
        }
        return null;
    }

    public CompositeMap getFieldByName(String name) {
        return this.getFieldByProperty("name", name);
    }

    public CompositeMap getFieldByPrompt(String prompt) {
        return this.getFieldByProperty("prompt", prompt);
    }

    public static boolean eq(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static String nns(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public CompositeMap getFieldsMap() {
        if (this.fieldsMap == null) {
            this.fieldsMap = this.bmMap.getChild("fields");
        }
        return this.fieldsMap;
    }

    public CompositeMap getPrimaryKeyMap() {
        if (this.primaryKeyMap == null) {
            this.primaryKeyMap = this.bmMap.getChild("primary-key");
        }
        return this.primaryKeyMap;
    }

    public CompositeMap getRelationsMap() {
        if (this.relationMap == null) {
            this.relationMap = this.bmMap.getChild("relations");
        }
        return this.relationMap;
    }

    public CompositeMap getRefFieldsMap() {
        if (this.refFieldsMap == null) {
            this.refFieldsMap = this.bmMap.getChild("ref-fields");
        }
        return this.refFieldsMap;
    }

    public CompositeMap getQueryFieldsMap() {
        if (this.queryFieldsMap == null) {
            this.queryFieldsMap = this.bmMap.getChild("query-fields");
        }
        return this.queryFieldsMap;
    }

    List<CompositeMap> getChildOf(String nodeName) {
        CompositeMap map = this.bmMap.getChild(nodeName);
        return this.getChild(map);
    }

    public List<CompositeMap> getFields() {
        if (this.fields == null) {
            this.fields = this.getChildOf("fields");
        }
        return this.fields;
    }

    public List<CompositeMap> getFieldsWithoutPk() {
        String pkn = this.getPkFieldName();
        ArrayList<CompositeMap> fields = new ArrayList<CompositeMap>();
        for (CompositeMap m : this.getFields()) {
            if (m.getString((Object)"name").equals(pkn)) continue;
            fields.add(m);
        }
        return fields;
    }

    public List<CompositeMap> getFields(boolean pk, boolean ref) {
        ArrayList<CompositeMap> fields = new ArrayList<CompositeMap>();
        if (pk) {
            fields.addAll(this.getFields());
        } else {
            fields.addAll(this.getFieldsWithoutPk());
        }
        if (ref) {
            fields.addAll(this.getRefFields());
        }
        return fields;
    }

    public List<CompositeMap> getPrimaryKeys() {
        if (this.primaryKeys == null) {
            this.primaryKeys = this.getChildOf("primary-key");
        }
        return this.primaryKeys;
    }

    public List<CompositeMap> getRelations() {
        if (this.relations == null) {
            this.relations = this.getChildOf("relations");
        }
        return this.relations;
    }

    public List<CompositeMap> getRefFields() {
        if (this.refFields == null) {
            this.refFields = this.getChildOf("ref-fields");
        }
        return this.refFields;
    }

    public List<CompositeMap> getQueryFields() {
        if (this.queryFields == null) {
            this.queryFields = this.getChildOf("query-fields");
        }
        return this.queryFields;
    }

    public String getField_name(CompositeMap fMap) {
        return BMCompositeMap.nns(fMap.getString((Object)"name"));
    }

    public String getField_prompt(CompositeMap fMap) {
        return BMCompositeMap.nns(fMap.getString((Object)"prompt"));
    }

    public CompositeMap getDefaultDisplayField() {
        String ddf = this.getDefaultDisplayFieldName();
        return this.getFieldByName(ddf);
    }

    public String getDefaultDisplayFieldName() {
        return BMCompositeMap.getMapAttribute(this.bmMap, "defaultDisplayField");
    }
}

