/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.extensions;

import aurora.ide.meta.extensions.ExtensionComponent;
import aurora.ide.meta.extensions.PaletteCategory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionLoader {
    private static final String META_PLUGIN_ID = "aurora.ide.meta";
    private static final String ACONSULTANT_PRODUCT_PLUGIN_ID = "aurora.ide.prototype.consultant.product";
    private static final String META_EDITOR_POINT_ID = "aurora.ide.meta.uipEditor";
    private static final String META_COMPONENT_POINT_ID = "aurora.ide.meta.auroraComponent";
    private static final String PRODUCT_EDITOR_POINT_ID = "aurora.ide.prototype.consultant.product.uipEditor";
    private static final String PRODUCT_COMPONENT_POINT_ID = "aurora.ide.prototype.consultant.product.auroraComponent";
    private static List<PaletteCategory> paletteCategories = new ArrayList<PaletteCategory>();
    private static List<ExtensionComponent> extensionComponents = new ArrayList<ExtensionComponent>();

    static {
        ExtensionLoader.editorPointExtensions();
        ExtensionLoader.componentPointExtensions();
    }

    private static void editorPointExtensions() {
        ExtensionLoader.loadEditorExtension(META_EDITOR_POINT_ID);
        ExtensionLoader.loadEditorExtension(PRODUCT_EDITOR_POINT_ID);
    }

    private static void loadEditorExtension(String point_id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(point_id);
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configurationElements;
                IConfigurationElement[] iConfigurationElementArray = configurationElements = extensions[i].getConfigurationElements();
                int n = configurationElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement ice = iConfigurationElementArray[n2];
                    if ("palette".equals(ice.getName())) {
                        IConfigurationElement[] children;
                        IConfigurationElement[] iConfigurationElementArray2 = children = ice.getChildren("category");
                        int n3 = children.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement c = iConfigurationElementArray2[n4];
                            String label = c.getAttribute("label");
                            String filter = c.getAttribute("filter");
                            String id = c.getAttribute("id");
                            PaletteCategory pc = new PaletteCategory(label, filter, id);
                            paletteCategories.add(pc);
                            ++n4;
                        }
                    }
                    ++n2;
                }
                ++i;
            }
        }
    }

    private static void componentPointExtensions() {
        ExtensionLoader.loadComponentExtension(META_COMPONENT_POINT_ID);
        ExtensionLoader.loadComponentExtension(PRODUCT_COMPONENT_POINT_ID);
    }

    private static void loadComponentExtension(String pointID) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(pointID);
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configurationElements;
                IConfigurationElement[] iConfigurationElementArray = configurationElements = extensions[i].getConfigurationElements();
                int n = configurationElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement ice = iConfigurationElementArray[n2];
                    if ("component".equals(ice.getName())) {
                        String categoryId = ice.getAttribute("categoryId");
                        String creator = ice.getAttribute("creator");
                        String descriptor = ice.getAttribute("descriptor");
                        String id = ice.getAttribute("id");
                        String name = ice.getAttribute("name");
                        String ioHandler = ice.getAttribute("ioHandler");
                        String types = ice.getAttribute("types");
                        ExtensionComponent ec = new ExtensionComponent(categoryId, creator, descriptor, id, name, ioHandler);
                        ec.setTypes(types);
                        extensionComponents.add(ec);
                    }
                    ++n2;
                }
                ++i;
            }
        }
    }

    public static List<PaletteCategory> getPaletteCategories() {
        return paletteCategories;
    }

    public static List<ExtensionComponent> getExtensionComponents() {
        return extensionComponents;
    }

    public static List<String> getTypesByCategoryId(String categoryId) {
        ArrayList<String> types = new ArrayList<String>();
        List<ExtensionComponent> extensionComponents = ExtensionLoader.getExtensionComponents();
        for (ExtensionComponent ec : extensionComponents) {
            if (!categoryId.equals(ec.getCategoryId())) continue;
            List<String> _types = ec.getTypes();
            for (String t : _types) {
                types.add(t.toLowerCase());
            }
        }
        return types;
    }

    public static List<String> getComponentNamesByCategoryId(String categoryId) {
        ArrayList<String> names = new ArrayList<String>();
        List<ExtensionComponent> extensionComponents = ExtensionLoader.getExtensionComponents();
        for (ExtensionComponent ec : extensionComponents) {
            if (!categoryId.equals(ec.getCategoryId())) continue;
            names.add(ec.getName().toLowerCase());
        }
        return names;
    }
}

