/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.action.gen;

import aurora.ide.AuroraMetaProjectNature;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.meta.MetaPlugin;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.gef.Util;
import aurora.ide.meta.gef.editors.source.gen.core.ProjectGenerator;
import aurora.ide.meta.gef.i18n.Messages;
import aurora.ide.meta.project.AuroraMetaProject;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;

public class SourceCodeGeneratorWizard
extends Wizard {
    private WizardPage mainPage;
    private Text auroraProjectNameField;
    private Combo projectNameField;
    private Button overlap;
    private IWorkbenchWindow window;
    public static final String DIALOG_SETTING_SECTION = "aurora.ide.uip.action.SourceCodeGenerator";
    private static final String IS_OVERLAP = "isOverlap";

    public SourceCodeGeneratorWizard(IWorkbenchWindow window) {
        this.window = window;
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.mainPage = new WizardPage("gensource"){
            private String initialProjectFieldValue;
            private static final int SIZING_TEXT_FIELD_WIDTH = 250;

            public void createControl(Composite parent) {
                Composite composite = new Composite(parent, 0);
                this.initializeDialogUnits((Control)parent);
                composite.setLayout((Layout)new GridLayout());
                composite.setLayoutData((Object)new GridData(1808));
                Composite projectGroup = new Composite(composite, 0);
                GridLayout layout = new GridLayout();
                layout.numColumns = 2;
                projectGroup.setLayout((Layout)layout);
                projectGroup.setLayoutData((Object)new GridData(768));
                this.createProjectNameGroup(projectGroup);
                this.createAruoraProjectNameGroup(projectGroup);
                SourceCodeGeneratorWizard.this.overlap = new Button(projectGroup, 32);
                SourceCodeGeneratorWizard.this.overlap.setText(Messages.SourceCodeGeneratorWizard_3);
                this.setPageComplete(this.validatePage());
                this.setErrorMessage(null);
                this.setMessage(null);
                this.setControl((Control)composite);
                Dialog.applyDialogFont((Control)composite);
                this.initPage();
            }

            public void initPage() {
                String[] pNames;
                SourceCodeGeneratorWizard.this.overlap.setSelection(SourceCodeGeneratorWizard.this.isOverlap());
                int count = SourceCodeGeneratorWizard.this.projectNameField.getItemCount();
                SourceCodeGeneratorWizard.this.projectNameField.select(count > 0 ? 1 : 0);
                String[] stringArray = pNames = Util.evaluateEnclosingProject(SourceCodeGeneratorWizard.this.window);
                int n = pNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    int indexOf = SourceCodeGeneratorWizard.this.projectNameField.indexOf(name);
                    if (indexOf != -1) {
                        SourceCodeGeneratorWizard.this.projectNameField.select(indexOf);
                        break;
                    }
                    ++n2;
                }
                this.selecttionChanged();
            }

            private final void createProjectNameGroup(Composite projectGroup) {
                Label projectLabel = new Label(projectGroup, 0);
                projectLabel.setText(Messages.SourceCodeGeneratorWizard_4);
                projectLabel.setFont(projectGroup.getFont());
                SourceCodeGeneratorWizard.this.projectNameField = new Combo(projectGroup, 8);
                GridData data = new GridData(768);
                data.widthHint = 250;
                SourceCodeGeneratorWizard.this.projectNameField.setLayoutData((Object)data);
                SourceCodeGeneratorWizard.this.projectNameField.setFont(projectGroup.getFont());
                if (this.initialProjectFieldValue != null) {
                    SourceCodeGeneratorWizard.this.projectNameField.setText(this.initialProjectFieldValue);
                }
                SourceCodeGeneratorWizard.this.projectNameField.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        this.selecttionChanged();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProject[] projects = workspace.getRoot().getProjects();
                SourceCodeGeneratorWizard.this.projectNameField.add("");
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject p = iProjectArray[n2];
                    boolean hasAuroraNature = false;
                    try {
                        hasAuroraNature = AuroraMetaProjectNature.hasAuroraNature((IProject)p);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    if (hasAuroraNature && p.isAccessible()) {
                        SourceCodeGeneratorWizard.this.projectNameField.add(p.getName());
                    }
                    ++n2;
                }
            }

            private final void createAruoraProjectNameGroup(Composite projectGroup) {
                Label projectLabel = new Label(projectGroup, 0);
                projectLabel.setText(Messages.SourceCodeGeneratorWizard_6);
                projectLabel.setFont(projectGroup.getFont());
                SourceCodeGeneratorWizard.this.auroraProjectNameField = new Text(projectGroup, 2048);
                GridData data = new GridData(768);
                data.widthHint = 250;
                SourceCodeGeneratorWizard.this.auroraProjectNameField.setLayoutData((Object)data);
                SourceCodeGeneratorWizard.this.auroraProjectNameField.setEditable(false);
                SourceCodeGeneratorWizard.this.auroraProjectNameField.setFont(projectGroup.getFont());
            }

            protected boolean validatePage() {
                IProject handle = SourceCodeGeneratorWizard.this.getAuroraProjectHandle();
                if (handle == null || !handle.exists()) {
                    this.setErrorMessage(Messages.SourceCodeGeneratorWizard_7);
                    return false;
                }
                this.setErrorMessage(null);
                this.setMessage(null);
                return true;
            }

            public void setVisible(boolean visible) {
                this.getControl().setVisible(visible);
                if (visible) {
                    SourceCodeGeneratorWizard.this.projectNameField.setFocus();
                }
            }

            public void selecttionChanged() {
                String text = SourceCodeGeneratorWizard.this.projectNameField.getText();
                if (text == null || "".equals(text)) {
                    return;
                }
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProject project = workspace.getRoot().getProject(text);
                AuroraMetaProject amp = new AuroraMetaProject(project);
                try {
                    String name = amp.getAuroraProject().getName();
                    SourceCodeGeneratorWizard.this.auroraProjectNameField.setText(name);
                }
                catch (ResourceNotFoundException e1) {
                    SourceCodeGeneratorWizard.this.auroraProjectNameField.setText("");
                }
                this.setPageComplete(this.validatePage());
            }
        };
        this.mainPage.setTitle("Project");
        this.mainPage.setDescription(Messages.SourceCodeGeneratorWizard_11);
        this.addPage((IWizardPage)this.mainPage);
    }

    public IProject getAuroraProjectHandle() {
        if (this.auroraProjectNameField == null) {
            return null;
        }
        String trim = this.auroraProjectNameField.getText().trim();
        if ("".equals(trim)) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(trim);
    }

    public boolean performFinish() {
        String text = this.projectNameField.getText();
        boolean selection = this.overlap.getSelection();
        this.saveOverlap(selection);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(text);
        final ProjectGenerator pg = new ProjectGenerator(project, selection, this.getShell());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                pg.go(monitor);
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            DialogUtil.logErrorException((Throwable)e);
            this.mainPage.setErrorMessage(pg.getErrorMessage());
            return false;
        }
        catch (InterruptedException e) {
            return true;
        }
        return true;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    public IDialogSettings getDialogSettings() {
        IDialogSettings dialogSettingsSection = MetaPlugin.getDefault().getDialogSettingsSection(DIALOG_SETTING_SECTION);
        return dialogSettingsSection;
    }

    private boolean isOverlap() {
        return this.getDialogSettings().getBoolean(IS_OVERLAP);
    }

    private void saveOverlap(boolean value) {
        this.getDialogSettings().put(IS_OVERLAP, value);
    }
}

