/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.AppDTVImpl;
import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DTVExecuteOp;
import com.microsoft.sqlserver.jdbc.DTVImpl;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.DriverError;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.JavaType;
import com.microsoft.sqlserver.jdbc.ReaderInputStream;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerSQLXML;
import com.microsoft.sqlserver.jdbc.SQLState;
import com.microsoft.sqlserver.jdbc.ServerDTVImpl;
import com.microsoft.sqlserver.jdbc.StreamSetterArgs;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import microsoft.sql.DateTimeOffset;

final class DTV {
    private DTVImpl impl;

    DTV() {
    }

    void setValue(SQLCollation sQLCollation, JDBCType jDBCType, Object object, JavaType javaType, StreamSetterArgs streamSetterArgs, Calendar calendar, Integer n, SQLServerConnection sQLServerConnection) throws SQLServerException {
        if (null == this.impl) {
            this.impl = new AppDTVImpl();
        }
        this.impl.setValue(this, sQLCollation, jDBCType, object, javaType, streamSetterArgs, calendar, n, sQLServerConnection);
    }

    final void setValue(Object object, JavaType javaType) {
        this.impl.setValue(object, javaType);
    }

    final void clear() {
        this.impl = null;
    }

    final void skipValue(TypeInfo typeInfo, TDSReader tDSReader, boolean bl) throws SQLServerException {
        if (null == this.impl) {
            this.impl = new ServerDTVImpl();
        }
        this.impl.skipValue(typeInfo, tDSReader, bl);
    }

    final void setStreamSetterArgs(StreamSetterArgs streamSetterArgs) {
        this.impl.setStreamSetterArgs(streamSetterArgs);
    }

    final void setCalendar(Calendar calendar) {
        this.impl.setCalendar(calendar);
    }

    final void setScale(Integer n) {
        this.impl.setScale(n);
    }

    StreamSetterArgs getStreamSetterArgs() {
        return this.impl.getStreamSetterArgs();
    }

    Calendar getCalendar() {
        return this.impl.getCalendar();
    }

    Integer getScale() {
        return this.impl.getScale();
    }

    boolean isNull() {
        return null == this.impl || this.impl.isNull();
    }

    final void setJdbcType(JDBCType jDBCType) {
        if (null == this.impl) {
            this.impl = new AppDTVImpl();
        }
        this.impl.setJdbcType(jDBCType);
    }

    final JDBCType getJdbcType() {
        assert (null != this.impl);
        return this.impl.getJdbcType();
    }

    final JavaType getJavaType() {
        assert (null != this.impl);
        return this.impl.getJavaType();
    }

    Object getValue(JDBCType jDBCType, int n, InputStreamGetterArgs inputStreamGetterArgs, Calendar calendar, TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        if (null == this.impl) {
            this.impl = new ServerDTVImpl();
        }
        return this.impl.getValue(this, jDBCType, n, inputStreamGetterArgs, calendar, typeInfo, tDSReader);
    }

    Object getSetterValue() {
        return this.impl.getSetterValue();
    }

    void setImpl(DTVImpl dTVImpl) {
        this.impl = dTVImpl;
    }

    final void executeOp(DTVExecuteOp dTVExecuteOp) throws SQLServerException {
        JDBCType jDBCType = this.getJdbcType();
        Object object = this.getSetterValue();
        JavaType javaType = this.getJavaType();
        boolean bl = false;
        if (null == object) {
            switch (jDBCType) {
                case NCHAR: 
                case NVARCHAR: 
                case LONGNVARCHAR: 
                case NCLOB: {
                    dTVExecuteOp.execute(this, (String)null);
                    break;
                }
                case INTEGER: {
                    dTVExecuteOp.execute(this, (Integer)null);
                    break;
                }
                case DATE: {
                    dTVExecuteOp.execute(this, (Date)null);
                    break;
                }
                case TIME: {
                    dTVExecuteOp.execute(this, (Time)null);
                    break;
                }
                case TIMESTAMP: {
                    dTVExecuteOp.execute(this, (Timestamp)null);
                    break;
                }
                case DATETIMEOFFSET: {
                    dTVExecuteOp.execute(this, (DateTimeOffset)null);
                    break;
                }
                case FLOAT: 
                case REAL: {
                    dTVExecuteOp.execute(this, (Float)null);
                    break;
                }
                case NUMERIC: 
                case DECIMAL: {
                    dTVExecuteOp.execute(this, (BigDecimal)null);
                    break;
                }
                case BINARY: 
                case VARBINARY: 
                case LONGVARBINARY: 
                case BLOB: 
                case CHAR: 
                case VARCHAR: 
                case LONGVARCHAR: 
                case CLOB: {
                    dTVExecuteOp.execute(this, (byte[])null);
                    break;
                }
                case TINYINT: {
                    dTVExecuteOp.execute(this, (Byte)null);
                    break;
                }
                case BIGINT: {
                    dTVExecuteOp.execute(this, (Long)null);
                    break;
                }
                case DOUBLE: {
                    dTVExecuteOp.execute(this, (Double)null);
                    break;
                }
                case SMALLINT: {
                    dTVExecuteOp.execute(this, (Short)null);
                    break;
                }
                case BIT: 
                case BOOLEAN: {
                    dTVExecuteOp.execute(this, (Boolean)null);
                    break;
                }
                case SQLXML: {
                    dTVExecuteOp.execute(this, (SQLServerSQLXML)null);
                    break;
                }
                case ARRAY: 
                case DATALINK: 
                case DISTINCT: 
                case JAVA_OBJECT: 
                case NULL: 
                case OTHER: 
                case REF: 
                case ROWID: 
                case STRUCT: {
                    bl = true;
                    break;
                }
                default: {
                    assert (false) : "Unexpected JDBCType: " + (Object)((Object)jDBCType);
                    bl = true;
                    break;
                }
            }
        } else {
            switch (javaType) {
                case STRING: {
                    dTVExecuteOp.execute(this, (String)object);
                    break;
                }
                case INTEGER: {
                    dTVExecuteOp.execute(this, (Integer)object);
                    break;
                }
                case DATE: {
                    dTVExecuteOp.execute(this, (Date)object);
                    break;
                }
                case TIME: {
                    dTVExecuteOp.execute(this, (Time)object);
                    break;
                }
                case TIMESTAMP: {
                    dTVExecuteOp.execute(this, (Timestamp)object);
                    break;
                }
                case DATETIMEOFFSET: {
                    dTVExecuteOp.execute(this, (DateTimeOffset)object);
                    break;
                }
                case FLOAT: {
                    dTVExecuteOp.execute(this, (Float)object);
                    break;
                }
                case BIGDECIMAL: {
                    dTVExecuteOp.execute(this, (BigDecimal)object);
                    break;
                }
                case BYTEARRAY: {
                    dTVExecuteOp.execute(this, (byte[])object);
                    break;
                }
                case BYTE: {
                    dTVExecuteOp.execute(this, (Byte)object);
                    break;
                }
                case LONG: {
                    dTVExecuteOp.execute(this, (Long)object);
                    break;
                }
                case DOUBLE: {
                    dTVExecuteOp.execute(this, (Double)object);
                    break;
                }
                case SHORT: {
                    dTVExecuteOp.execute(this, (Short)object);
                    break;
                }
                case BOOLEAN: {
                    dTVExecuteOp.execute(this, (Boolean)object);
                    break;
                }
                case BLOB: {
                    dTVExecuteOp.execute(this, (Blob)object);
                    break;
                }
                case CLOB: 
                case NCLOB: {
                    dTVExecuteOp.execute(this, (Clob)object);
                    break;
                }
                case INPUTSTREAM: {
                    dTVExecuteOp.execute(this, (InputStream)object);
                    break;
                }
                case READER: {
                    dTVExecuteOp.execute(this, (Reader)object);
                    break;
                }
                case SQLXML: {
                    dTVExecuteOp.execute(this, (SQLServerSQLXML)object);
                    break;
                }
                default: {
                    assert (false) : "Unexpected JavaType: " + (Object)((Object)javaType);
                    bl = true;
                }
            }
        }
        if (bl) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedConversionFromTo"));
            Object[] objectArray = new Object[]{javaType, jDBCType};
            throw new SQLServerException(messageFormat.format(objectArray), SQLState.DATA_EXCEPTION_NOT_SPECIFIC, DriverError.NOT_SET, null);
        }
    }

    void sendByRPC(String string, TypeInfo typeInfo, SQLCollation sQLCollation, int n, boolean bl, TDSWriter tDSWriter, SQLServerConnection sQLServerConnection) throws SQLServerException {
        this.executeOp(new SendByRPCOp(string, typeInfo, sQLCollation, n, bl, tDSWriter, sQLServerConnection));
    }

    final class SendByRPCOp
    extends DTVExecuteOp {
        private final String name;
        private final TypeInfo typeInfo;
        private final SQLCollation collation;
        private final int outScale;
        private final boolean isOutParam;
        private final TDSWriter tdsWriter;
        private final SQLServerConnection conn;

        SendByRPCOp(String string, TypeInfo typeInfo, SQLCollation sQLCollation, int n, boolean bl, TDSWriter tDSWriter, SQLServerConnection sQLServerConnection) {
            this.name = string;
            this.typeInfo = typeInfo;
            this.collation = sQLCollation;
            this.outScale = n;
            this.isOutParam = bl;
            this.tdsWriter = tDSWriter;
            this.conn = sQLServerConnection;
        }

        void execute(DTV dTV, String string) throws SQLServerException {
            this.tdsWriter.writeRPCStringUnicode(this.name, string, this.isOutParam, this.collation);
        }

        void execute(DTV dTV, Clob clob) throws SQLServerException {
            assert (null != clob);
            long l = 0L;
            Reader reader = null;
            try {
                l = DataTypes.getCheckedLength(this.conn, dTV.getJdbcType(), clob.length(), false);
                reader = clob.getCharacterStream();
            }
            catch (SQLException sQLException) {
                SQLServerException.makeFromDriverError(this.conn, null, sQLException.getMessage(), null, false);
            }
            JDBCType jDBCType = dTV.getJdbcType();
            if (null != this.collation && (JDBCType.CHAR == jDBCType || JDBCType.VARCHAR == jDBCType || JDBCType.LONGVARCHAR == jDBCType || JDBCType.CLOB == jDBCType)) {
                if (null == reader) {
                    this.tdsWriter.writeRPCByteArray(this.name, null, this.isOutParam, jDBCType, this.collation);
                } else {
                    ReaderInputStream readerInputStream = null;
                    try {
                        readerInputStream = new ReaderInputStream(reader, this.collation.getCharset(), l);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_encodingErrorWritingTDS"));
                        Object[] objectArray = new Object[]{new String(unsupportedEncodingException.getMessage())};
                        SQLServerException.makeFromDriverError(this.conn, null, messageFormat.format(objectArray), null, true);
                    }
                    this.tdsWriter.writeRPCInputStream(this.name, readerInputStream, -1L, this.isOutParam, jDBCType, this.collation);
                }
            } else if (null == reader) {
                this.tdsWriter.writeRPCStringUnicode(this.name, null, this.isOutParam, this.collation);
            } else {
                this.tdsWriter.writeRPCReaderUnicode(this.name, reader, l, this.isOutParam, this.collation);
            }
        }

        void execute(DTV dTV, Byte by) throws SQLServerException {
            this.tdsWriter.writeRPCByte(this.name, by, this.isOutParam);
        }

        void execute(DTV dTV, Integer n) throws SQLServerException {
            this.tdsWriter.writeRPCInt(this.name, n, this.isOutParam);
        }

        void execute(DTV dTV, Time time) throws SQLServerException {
            Calendar calendar = null;
            int n = 0;
            if (null != time) {
                calendar = dTV.getCalendar();
                if (null == calendar) {
                    calendar = Calendar.getInstance(Locale.US);
                }
                calendar.setTimeInMillis(time.getTime());
                calendar.set(this.conn.baseYear(), 0, 1);
                n = 1000000 * calendar.get(14);
            }
            this.sendTemporal(JavaType.TIME, dTV.getJdbcType(), calendar, 0, n);
        }

        void execute(DTV dTV, Date date) throws SQLServerException {
            Calendar calendar = null;
            if (null != date) {
                calendar = dTV.getCalendar();
                if (null == calendar) {
                    calendar = Calendar.getInstance(Locale.US);
                }
                calendar.setTimeInMillis(date.getTime());
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
            this.sendTemporal(JavaType.DATE, dTV.getJdbcType(), calendar, 0, 0);
        }

        void execute(DTV dTV, Timestamp timestamp) throws SQLServerException {
            Calendar calendar = null;
            int n = 0;
            if (null != timestamp) {
                calendar = dTV.getCalendar();
                if (null == calendar) {
                    calendar = Calendar.getInstance(Locale.US);
                }
                n = timestamp.getNanos();
                calendar.setTimeInMillis(timestamp.getTime());
                calendar.set(14, n / 1000000);
            }
            this.sendTemporal(JavaType.TIMESTAMP, dTV.getJdbcType(), calendar, 0, n);
        }

        void execute(DTV dTV, DateTimeOffset dateTimeOffset) throws SQLServerException {
            Calendar calendar = null;
            int n = 0;
            int n2 = 0;
            if (null != dateTimeOffset) {
                Timestamp timestamp = dateTimeOffset.getTimestamp();
                n2 = timestamp.getNanos();
                n = dateTimeOffset.getMinutesOffset();
                calendar = Calendar.getInstance(new SimpleTimeZone(60000 * n, ""), Locale.US);
                calendar.setTimeInMillis(timestamp.getTime());
                calendar.set(14, n2 / 1000000);
            }
            this.sendTemporal(JavaType.DATETIMEOFFSET, dTV.getJdbcType(), calendar, n, n2);
        }

        private void sendTemporal(JavaType javaType, JDBCType jDBCType, Calendar calendar, int n, int n2) throws SQLServerException {
            block27: {
                block26: {
                    if (null == this.typeInfo) break block26;
                    switch (this.typeInfo.getSSType()) {
                        case DATETIME2: {
                            this.tdsWriter.writeRPCDateTime2(this.name, calendar, n2, this.typeInfo.getScale(), this.isOutParam);
                            break block27;
                        }
                        case DATE: {
                            this.tdsWriter.writeRPCDate(this.name, calendar, this.isOutParam);
                            break block27;
                        }
                        case TIME: {
                            this.tdsWriter.writeRPCTime(this.name, calendar, n2, this.typeInfo.getScale(), this.isOutParam);
                            break block27;
                        }
                        case DATETIMEOFFSET: {
                            if (JavaType.DATETIMEOFFSET != javaType) {
                                calendar = this.localCalendarAsUTC(calendar);
                                n = 0;
                            }
                            this.tdsWriter.writeRPCDateTimeOffset(this.name, calendar, n, n2, this.typeInfo.getScale(), this.isOutParam);
                            break block27;
                        }
                        case DATETIME: 
                        case SMALLDATETIME: {
                            this.tdsWriter.writeRPCDateTime(this.name, calendar, n2, this.isOutParam);
                            break block27;
                        }
                        default: {
                            assert (false) : "Unexpected SSType: " + (Object)((Object)this.typeInfo.getSSType());
                            break block27;
                        }
                    }
                }
                if (this.conn.isKatmaiOrLater()) {
                    assert (JDBCType.TIMESTAMP == jDBCType || JDBCType.TIME == jDBCType || JDBCType.DATE == jDBCType || JDBCType.DATETIMEOFFSET == jDBCType) : "Unexpected JDBCType: " + (Object)((Object)jDBCType);
                    switch (jDBCType) {
                        case TIMESTAMP: {
                            this.tdsWriter.writeRPCDateTime2(this.name, calendar, n2, 7, this.isOutParam);
                            break;
                        }
                        case TIME: {
                            if (this.conn.sendTimeAsDatetime()) {
                                this.tdsWriter.writeRPCDateTime(this.name, calendar, n2, this.isOutParam);
                                break;
                            }
                            this.tdsWriter.writeRPCTime(this.name, calendar, n2, 7, this.isOutParam);
                            break;
                        }
                        case DATE: {
                            this.tdsWriter.writeRPCDate(this.name, calendar, this.isOutParam);
                            break;
                        }
                        case DATETIMEOFFSET: {
                            if (JavaType.DATETIMEOFFSET != javaType) {
                                calendar = this.localCalendarAsUTC(calendar);
                                n = 0;
                            }
                            this.tdsWriter.writeRPCDateTimeOffset(this.name, calendar, n, n2, 7, this.isOutParam);
                        }
                    }
                } else {
                    assert (JDBCType.TIME == jDBCType || JDBCType.DATE == jDBCType || JDBCType.TIMESTAMP == jDBCType) : "Unexpected JDBCType: " + (Object)((Object)jDBCType);
                    if (null != calendar) {
                        switch (jDBCType) {
                            case DATE: {
                                calendar.set(11, 0);
                                calendar.set(12, 0);
                                calendar.set(13, 0);
                                calendar.set(14, 0);
                                break;
                            }
                            case TIME: {
                                calendar.set(1970, 0, 1);
                            }
                        }
                    }
                    this.tdsWriter.writeRPCDateTime(this.name, calendar, n2, this.isOutParam);
                }
            }
        }

        private Calendar localCalendarAsUTC(Calendar calendar) {
            if (null == calendar) {
                return null;
            }
            Calendar calendar2 = (Calendar)calendar.clone();
            calendar2.setTimeZone(TimeZone.getTimeZone("UTC"));
            calendar2.clear();
            calendar2.set(1, calendar.get(1));
            calendar2.set(2, calendar.get(2));
            calendar2.set(5, calendar.get(5));
            calendar2.set(11, calendar.get(11));
            calendar2.set(12, calendar.get(12));
            calendar2.set(13, calendar.get(13));
            calendar2.set(14, calendar.get(14));
            return calendar2;
        }

        void execute(DTV dTV, Float f) throws SQLServerException {
            if (JDBCType.REAL == dTV.getJdbcType()) {
                this.tdsWriter.writeRPCReal(this.name, f, this.isOutParam);
            } else {
                Double d = null == f ? null : new Double(f.floatValue());
                this.tdsWriter.writeRPCDouble(this.name, d, this.isOutParam);
            }
        }

        void execute(DTV dTV, Double d) throws SQLServerException {
            this.tdsWriter.writeRPCDouble(this.name, d, this.isOutParam);
        }

        void execute(DTV dTV, BigDecimal bigDecimal) throws SQLServerException {
            if (DDC.exceedsMaxRPCDecimalPrecisionOrScale(bigDecimal)) {
                String string = bigDecimal.toString();
                this.tdsWriter.writeRPCStringUnicode(this.name, string, this.isOutParam, this.collation);
            } else {
                this.tdsWriter.writeRPCBigDecimal(this.name, bigDecimal, this.outScale, this.isOutParam);
            }
        }

        void execute(DTV dTV, Long l) throws SQLServerException {
            this.tdsWriter.writeRPCLong(this.name, l, this.isOutParam);
        }

        void execute(DTV dTV, Short s) throws SQLServerException {
            this.tdsWriter.writeRPCShort(this.name, s, this.isOutParam);
        }

        void execute(DTV dTV, Boolean bl) throws SQLServerException {
            this.tdsWriter.writeRPCBit(this.name, bl, this.isOutParam);
        }

        void execute(DTV dTV, byte[] byArray) throws SQLServerException {
            this.tdsWriter.writeRPCByteArray(this.name, byArray, this.isOutParam, dTV.getJdbcType(), this.collation);
        }

        void execute(DTV dTV, Blob blob) throws SQLServerException {
            assert (null != blob);
            long l = 0L;
            InputStream inputStream = null;
            try {
                l = DataTypes.getCheckedLength(this.conn, dTV.getJdbcType(), blob.length(), false);
                inputStream = blob.getBinaryStream();
            }
            catch (SQLException sQLException) {
                SQLServerException.makeFromDriverError(this.conn, null, sQLException.getMessage(), null, false);
            }
            if (null == inputStream) {
                this.tdsWriter.writeRPCByteArray(this.name, null, this.isOutParam, dTV.getJdbcType(), this.collation);
            } else {
                this.tdsWriter.writeRPCInputStream(this.name, inputStream, l, this.isOutParam, dTV.getJdbcType(), this.collation);
            }
        }

        void execute(DTV dTV, SQLServerSQLXML sQLServerSQLXML) throws SQLServerException {
            ByteArrayInputStream byteArrayInputStream = null == sQLServerSQLXML ? null : sQLServerSQLXML.getValue();
            this.tdsWriter.writeRPCXML(this.name, byteArrayInputStream, null == byteArrayInputStream ? 0L : dTV.getStreamSetterArgs().getLength(), this.isOutParam);
        }

        void execute(DTV dTV, InputStream inputStream) throws SQLServerException {
            this.tdsWriter.writeRPCInputStream(this.name, inputStream, null == inputStream ? 0L : dTV.getStreamSetterArgs().getLength(), this.isOutParam, dTV.getJdbcType(), this.collation);
        }

        void execute(DTV dTV, Reader reader) throws SQLServerException {
            JDBCType jDBCType = dTV.getJdbcType();
            assert (null != reader);
            assert (JDBCType.NCHAR == jDBCType || JDBCType.NVARCHAR == jDBCType || JDBCType.LONGNVARCHAR == jDBCType || JDBCType.NCLOB == jDBCType) : "SendByRPCOp(Reader): Unexpected JDBC type " + (Object)((Object)jDBCType);
            this.tdsWriter.writeRPCReaderUnicode(this.name, reader, dTV.getStreamSetterArgs().getLength(), this.isOutParam, this.collation);
        }
    }
}

